/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev161214.interfaces.state._interface;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev161214.VxlanGpeBaseAttributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev161214.VxlanGpeNextProtocol;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev161214.VxlanGpeVni;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev161214.interfaces.state._interface.VxlanGpe;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class VxlanGpeBuilder
implements Builder<VxlanGpe> {
    private Long _decapVrfId;
    private Long _encapVrfId;
    private IpAddress _local;
    private VxlanGpeNextProtocol _nextProtocol;
    private IpAddress _remote;
    private VxlanGpeVni _vni;
    Map<Class<? extends Augmentation<VxlanGpe>>, Augmentation<VxlanGpe>> augmentation = Collections.emptyMap();

    public VxlanGpeBuilder() {
    }

    public VxlanGpeBuilder(VxlanGpeBaseAttributes arg) {
        this._local = arg.getLocal();
        this._remote = arg.getRemote();
        this._vni = arg.getVni();
        this._nextProtocol = arg.getNextProtocol();
        this._encapVrfId = arg.getEncapVrfId();
        this._decapVrfId = arg.getDecapVrfId();
    }

    public VxlanGpeBuilder(VxlanGpe base) {
        AugmentationHolder casted;
        this._decapVrfId = base.getDecapVrfId();
        this._encapVrfId = base.getEncapVrfId();
        this._local = base.getLocal();
        this._nextProtocol = base.getNextProtocol();
        this._remote = base.getRemote();
        this._vni = base.getVni();
        if (base instanceof VxlanGpeImpl) {
            VxlanGpeImpl impl = (VxlanGpeImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<VxlanGpe>>, Augmentation<VxlanGpe>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<VxlanGpe>>, Augmentation<VxlanGpe>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof VxlanGpeBaseAttributes) {
            this._local = ((VxlanGpeBaseAttributes)arg).getLocal();
            this._remote = ((VxlanGpeBaseAttributes)arg).getRemote();
            this._vni = ((VxlanGpeBaseAttributes)arg).getVni();
            this._nextProtocol = ((VxlanGpeBaseAttributes)arg).getNextProtocol();
            this._encapVrfId = ((VxlanGpeBaseAttributes)arg).getEncapVrfId();
            this._decapVrfId = ((VxlanGpeBaseAttributes)arg).getDecapVrfId();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev161214.VxlanGpeBaseAttributes] \nbut was: " + arg);
        }
    }

    public Long getDecapVrfId() {
        return this._decapVrfId;
    }

    public Long getEncapVrfId() {
        return this._encapVrfId;
    }

    public IpAddress getLocal() {
        return this._local;
    }

    public VxlanGpeNextProtocol getNextProtocol() {
        return this._nextProtocol;
    }

    public IpAddress getRemote() {
        return this._remote;
    }

    public VxlanGpeVni getVni() {
        return this._vni;
    }

    public <E extends Augmentation<VxlanGpe>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    private static void checkDecapVrfIdRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..4294967295]].", value));
    }

    public VxlanGpeBuilder setDecapVrfId(Long value) {
        if (value != null) {
            VxlanGpeBuilder.checkDecapVrfIdRange(value);
        }
        this._decapVrfId = value;
        return this;
    }

    private static void checkEncapVrfIdRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..4294967295]].", value));
    }

    public VxlanGpeBuilder setEncapVrfId(Long value) {
        if (value != null) {
            VxlanGpeBuilder.checkEncapVrfIdRange(value);
        }
        this._encapVrfId = value;
        return this;
    }

    public VxlanGpeBuilder setLocal(IpAddress value) {
        this._local = value;
        return this;
    }

    public VxlanGpeBuilder setNextProtocol(VxlanGpeNextProtocol value) {
        this._nextProtocol = value;
        return this;
    }

    public VxlanGpeBuilder setRemote(IpAddress value) {
        this._remote = value;
        return this;
    }

    public VxlanGpeBuilder setVni(VxlanGpeVni value) {
        this._vni = value;
        return this;
    }

    public VxlanGpeBuilder addAugmentation(Class<? extends Augmentation<VxlanGpe>> augmentationType, Augmentation<VxlanGpe> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<VxlanGpe>>, Augmentation<VxlanGpe>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public VxlanGpeBuilder removeAugmentation(Class<? extends Augmentation<VxlanGpe>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public VxlanGpe build() {
        return new VxlanGpeImpl(this);
    }

    private static final class VxlanGpeImpl
    implements VxlanGpe {
        private final Long _decapVrfId;
        private final Long _encapVrfId;
        private final IpAddress _local;
        private final VxlanGpeNextProtocol _nextProtocol;
        private final IpAddress _remote;
        private final VxlanGpeVni _vni;
        private Map<Class<? extends Augmentation<VxlanGpe>>, Augmentation<VxlanGpe>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<VxlanGpe> getImplementedInterface() {
            return VxlanGpe.class;
        }

        private VxlanGpeImpl(VxlanGpeBuilder base) {
            this._decapVrfId = base.getDecapVrfId();
            this._encapVrfId = base.getEncapVrfId();
            this._local = base.getLocal();
            this._nextProtocol = base.getNextProtocol();
            this._remote = base.getRemote();
            this._vni = base.getVni();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<VxlanGpe>>, Augmentation<VxlanGpe>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<VxlanGpe>>, Augmentation<VxlanGpe>>(base.augmentation);
                }
            }
        }

        @Override
        public Long getDecapVrfId() {
            return this._decapVrfId;
        }

        @Override
        public Long getEncapVrfId() {
            return this._encapVrfId;
        }

        @Override
        public IpAddress getLocal() {
            return this._local;
        }

        @Override
        public VxlanGpeNextProtocol getNextProtocol() {
            return this._nextProtocol;
        }

        @Override
        public IpAddress getRemote() {
            return this._remote;
        }

        @Override
        public VxlanGpeVni getVni() {
            return this._vni;
        }

        public <E extends Augmentation<VxlanGpe>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._decapVrfId);
            result = 31 * result + Objects.hashCode(this._encapVrfId);
            result = 31 * result + Objects.hashCode(this._local);
            result = 31 * result + Objects.hashCode((Object)this._nextProtocol);
            result = 31 * result + Objects.hashCode(this._remote);
            result = 31 * result + Objects.hashCode(this._vni);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!VxlanGpe.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            VxlanGpe other = (VxlanGpe)obj;
            if (!Objects.equals(this._decapVrfId, other.getDecapVrfId())) {
                return false;
            }
            if (!Objects.equals(this._encapVrfId, other.getEncapVrfId())) {
                return false;
            }
            if (!Objects.equals(this._local, other.getLocal())) {
                return false;
            }
            if (!Objects.equals((Object)this._nextProtocol, (Object)other.getNextProtocol())) {
                return false;
            }
            if (!Objects.equals(this._remote, other.getRemote())) {
                return false;
            }
            if (!Objects.equals(this._vni, other.getVni())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                VxlanGpeImpl otherImpl = (VxlanGpeImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<VxlanGpe>>, Augmentation<VxlanGpe>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "VxlanGpe [";
            StringBuilder builder = new StringBuilder(name);
            if (this._decapVrfId != null) {
                builder.append("_decapVrfId=");
                builder.append(this._decapVrfId);
                builder.append(", ");
            }
            if (this._encapVrfId != null) {
                builder.append("_encapVrfId=");
                builder.append(this._encapVrfId);
                builder.append(", ");
            }
            if (this._local != null) {
                builder.append("_local=");
                builder.append(this._local);
                builder.append(", ");
            }
            if (this._nextProtocol != null) {
                builder.append("_nextProtocol=");
                builder.append((Object)this._nextProtocol);
                builder.append(", ");
            }
            if (this._remote != null) {
                builder.append("_remote=");
                builder.append(this._remote);
                builder.append(", ");
            }
            if (this._vni != null) {
                builder.append("_vni=");
                builder.append(this._vni);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

