/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev161214.interfaces.state._interface;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev161214.RoutingBaseAttributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev161214.interfaces.state._interface.Routing;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class RoutingBuilder
implements Builder<Routing> {
    private Long _ipv4VrfId;
    private Long _ipv6VrfId;
    Map<Class<? extends Augmentation<Routing>>, Augmentation<Routing>> augmentation = Collections.emptyMap();

    public RoutingBuilder() {
    }

    public RoutingBuilder(RoutingBaseAttributes arg) {
        this._ipv4VrfId = arg.getIpv4VrfId();
        this._ipv6VrfId = arg.getIpv6VrfId();
    }

    public RoutingBuilder(Routing base) {
        AugmentationHolder casted;
        this._ipv4VrfId = base.getIpv4VrfId();
        this._ipv6VrfId = base.getIpv6VrfId();
        if (base instanceof RoutingImpl) {
            RoutingImpl impl = (RoutingImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Routing>>, Augmentation<Routing>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Routing>>, Augmentation<Routing>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof RoutingBaseAttributes) {
            this._ipv4VrfId = ((RoutingBaseAttributes)arg).getIpv4VrfId();
            this._ipv6VrfId = ((RoutingBaseAttributes)arg).getIpv6VrfId();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev161214.RoutingBaseAttributes] \nbut was: " + arg);
        }
    }

    public Long getIpv4VrfId() {
        return this._ipv4VrfId;
    }

    public Long getIpv6VrfId() {
        return this._ipv6VrfId;
    }

    public <E extends Augmentation<Routing>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    private static void checkIpv4VrfIdRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..4294967295]].", value));
    }

    public RoutingBuilder setIpv4VrfId(Long value) {
        if (value != null) {
            RoutingBuilder.checkIpv4VrfIdRange(value);
        }
        this._ipv4VrfId = value;
        return this;
    }

    private static void checkIpv6VrfIdRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..4294967295]].", value));
    }

    public RoutingBuilder setIpv6VrfId(Long value) {
        if (value != null) {
            RoutingBuilder.checkIpv6VrfIdRange(value);
        }
        this._ipv6VrfId = value;
        return this;
    }

    public RoutingBuilder addAugmentation(Class<? extends Augmentation<Routing>> augmentationType, Augmentation<Routing> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Routing>>, Augmentation<Routing>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public RoutingBuilder removeAugmentation(Class<? extends Augmentation<Routing>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Routing build() {
        return new RoutingImpl(this);
    }

    private static final class RoutingImpl
    implements Routing {
        private final Long _ipv4VrfId;
        private final Long _ipv6VrfId;
        private Map<Class<? extends Augmentation<Routing>>, Augmentation<Routing>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<Routing> getImplementedInterface() {
            return Routing.class;
        }

        private RoutingImpl(RoutingBuilder base) {
            this._ipv4VrfId = base.getIpv4VrfId();
            this._ipv6VrfId = base.getIpv6VrfId();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<Routing>>, Augmentation<Routing>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<Routing>>, Augmentation<Routing>>(base.augmentation);
                }
            }
        }

        @Override
        public Long getIpv4VrfId() {
            return this._ipv4VrfId;
        }

        @Override
        public Long getIpv6VrfId() {
            return this._ipv6VrfId;
        }

        public <E extends Augmentation<Routing>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._ipv4VrfId);
            result = 31 * result + Objects.hashCode(this._ipv6VrfId);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Routing.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Routing other = (Routing)obj;
            if (!Objects.equals(this._ipv4VrfId, other.getIpv4VrfId())) {
                return false;
            }
            if (!Objects.equals(this._ipv6VrfId, other.getIpv6VrfId())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                RoutingImpl otherImpl = (RoutingImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Routing>>, Augmentation<Routing>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "Routing [";
            StringBuilder builder = new StringBuilder(name);
            if (this._ipv4VrfId != null) {
                builder.append("_ipv4VrfId=");
                builder.append(this._ipv4VrfId);
                builder.append(", ");
            }
            if (this._ipv6VrfId != null) {
                builder.append("_ipv6VrfId=");
                builder.append(this._ipv6VrfId);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

