/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev161214.interfaces.state._interface;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev161214.GreBaseAttributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev161214.interfaces.state._interface.Gre;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class GreBuilder
implements Builder<Gre> {
    private IpAddress _dst;
    private Long _outerFibId;
    private IpAddress _src;
    Map<Class<? extends Augmentation<Gre>>, Augmentation<Gre>> augmentation = Collections.emptyMap();

    public GreBuilder() {
    }

    public GreBuilder(GreBaseAttributes arg) {
        this._src = arg.getSrc();
        this._dst = arg.getDst();
        this._outerFibId = arg.getOuterFibId();
    }

    public GreBuilder(Gre base) {
        AugmentationHolder casted;
        this._dst = base.getDst();
        this._outerFibId = base.getOuterFibId();
        this._src = base.getSrc();
        if (base instanceof GreImpl) {
            GreImpl impl = (GreImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Gre>>, Augmentation<Gre>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Gre>>, Augmentation<Gre>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof GreBaseAttributes) {
            this._src = ((GreBaseAttributes)arg).getSrc();
            this._dst = ((GreBaseAttributes)arg).getDst();
            this._outerFibId = ((GreBaseAttributes)arg).getOuterFibId();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev161214.GreBaseAttributes] \nbut was: " + arg);
        }
    }

    public IpAddress getDst() {
        return this._dst;
    }

    public Long getOuterFibId() {
        return this._outerFibId;
    }

    public IpAddress getSrc() {
        return this._src;
    }

    public <E extends Augmentation<Gre>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public GreBuilder setDst(IpAddress value) {
        this._dst = value;
        return this;
    }

    private static void checkOuterFibIdRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..4294967295]].", value));
    }

    public GreBuilder setOuterFibId(Long value) {
        if (value != null) {
            GreBuilder.checkOuterFibIdRange(value);
        }
        this._outerFibId = value;
        return this;
    }

    public GreBuilder setSrc(IpAddress value) {
        this._src = value;
        return this;
    }

    public GreBuilder addAugmentation(Class<? extends Augmentation<Gre>> augmentationType, Augmentation<Gre> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Gre>>, Augmentation<Gre>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public GreBuilder removeAugmentation(Class<? extends Augmentation<Gre>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Gre build() {
        return new GreImpl(this);
    }

    private static final class GreImpl
    implements Gre {
        private final IpAddress _dst;
        private final Long _outerFibId;
        private final IpAddress _src;
        private Map<Class<? extends Augmentation<Gre>>, Augmentation<Gre>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<Gre> getImplementedInterface() {
            return Gre.class;
        }

        private GreImpl(GreBuilder base) {
            this._dst = base.getDst();
            this._outerFibId = base.getOuterFibId();
            this._src = base.getSrc();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<Gre>>, Augmentation<Gre>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<Gre>>, Augmentation<Gre>>(base.augmentation);
                }
            }
        }

        @Override
        public IpAddress getDst() {
            return this._dst;
        }

        @Override
        public Long getOuterFibId() {
            return this._outerFibId;
        }

        @Override
        public IpAddress getSrc() {
            return this._src;
        }

        public <E extends Augmentation<Gre>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._dst);
            result = 31 * result + Objects.hashCode(this._outerFibId);
            result = 31 * result + Objects.hashCode(this._src);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Gre.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Gre other = (Gre)obj;
            if (!Objects.equals(this._dst, other.getDst())) {
                return false;
            }
            if (!Objects.equals(this._outerFibId, other.getOuterFibId())) {
                return false;
            }
            if (!Objects.equals(this._src, other.getSrc())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                GreImpl otherImpl = (GreImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Gre>>, Augmentation<Gre>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "Gre [";
            StringBuilder builder = new StringBuilder(name);
            if (this._dst != null) {
                builder.append("_dst=");
                builder.append(this._dst);
                builder.append(", ");
            }
            if (this._outerFibId != null) {
                builder.append("_outerFibId=");
                builder.append(this._outerFibId);
                builder.append(", ");
            }
            if (this._src != null) {
                builder.append("_src=");
                builder.append(this._src);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

