/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev161214.interfaces.state._interface;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev161214.EthernetBaseAttributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev161214.EthernetStateAttributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev161214.interfaces.state._interface.Ethernet;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class EthernetBuilder
implements Builder<Ethernet> {
    private EthernetStateAttributes.Duplex _duplex;
    private String _manufacturerDescription;
    private Integer _mtu;
    Map<Class<? extends Augmentation<Ethernet>>, Augmentation<Ethernet>> augmentation = Collections.emptyMap();

    public EthernetBuilder() {
    }

    public EthernetBuilder(EthernetStateAttributes arg) {
        this._manufacturerDescription = arg.getManufacturerDescription();
        this._duplex = arg.getDuplex();
    }

    public EthernetBuilder(EthernetBaseAttributes arg) {
        this._mtu = arg.getMtu();
    }

    public EthernetBuilder(Ethernet base) {
        AugmentationHolder casted;
        this._duplex = base.getDuplex();
        this._manufacturerDescription = base.getManufacturerDescription();
        this._mtu = base.getMtu();
        if (base instanceof EthernetImpl) {
            EthernetImpl impl = (EthernetImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Ethernet>>, Augmentation<Ethernet>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Ethernet>>, Augmentation<Ethernet>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof EthernetBaseAttributes) {
            this._mtu = ((EthernetBaseAttributes)arg).getMtu();
            isValidArg = true;
        }
        if (arg instanceof EthernetStateAttributes) {
            this._manufacturerDescription = ((EthernetStateAttributes)arg).getManufacturerDescription();
            this._duplex = ((EthernetStateAttributes)arg).getDuplex();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev161214.EthernetBaseAttributes, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev161214.EthernetStateAttributes] \nbut was: " + arg);
        }
    }

    public EthernetStateAttributes.Duplex getDuplex() {
        return this._duplex;
    }

    public String getManufacturerDescription() {
        return this._manufacturerDescription;
    }

    public Integer getMtu() {
        return this._mtu;
    }

    public <E extends Augmentation<Ethernet>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public EthernetBuilder setDuplex(EthernetStateAttributes.Duplex value) {
        this._duplex = value;
        return this;
    }

    public EthernetBuilder setManufacturerDescription(String value) {
        this._manufacturerDescription = value;
        return this;
    }

    private static void checkMtuRange(int value) {
        if (value >= 64 && value <= 9216) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[64..9216]].", value));
    }

    public EthernetBuilder setMtu(Integer value) {
        if (value != null) {
            EthernetBuilder.checkMtuRange(value);
        }
        this._mtu = value;
        return this;
    }

    public EthernetBuilder addAugmentation(Class<? extends Augmentation<Ethernet>> augmentationType, Augmentation<Ethernet> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Ethernet>>, Augmentation<Ethernet>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public EthernetBuilder removeAugmentation(Class<? extends Augmentation<Ethernet>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Ethernet build() {
        return new EthernetImpl(this);
    }

    private static final class EthernetImpl
    implements Ethernet {
        private final EthernetStateAttributes.Duplex _duplex;
        private final String _manufacturerDescription;
        private final Integer _mtu;
        private Map<Class<? extends Augmentation<Ethernet>>, Augmentation<Ethernet>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<Ethernet> getImplementedInterface() {
            return Ethernet.class;
        }

        private EthernetImpl(EthernetBuilder base) {
            this._duplex = base.getDuplex();
            this._manufacturerDescription = base.getManufacturerDescription();
            this._mtu = base.getMtu();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<Ethernet>>, Augmentation<Ethernet>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<Ethernet>>, Augmentation<Ethernet>>(base.augmentation);
                }
            }
        }

        @Override
        public EthernetStateAttributes.Duplex getDuplex() {
            return this._duplex;
        }

        @Override
        public String getManufacturerDescription() {
            return this._manufacturerDescription;
        }

        @Override
        public Integer getMtu() {
            return this._mtu;
        }

        public <E extends Augmentation<Ethernet>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode((Object)this._duplex);
            result = 31 * result + Objects.hashCode(this._manufacturerDescription);
            result = 31 * result + Objects.hashCode(this._mtu);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Ethernet.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Ethernet other = (Ethernet)obj;
            if (!Objects.equals((Object)this._duplex, (Object)other.getDuplex())) {
                return false;
            }
            if (!Objects.equals(this._manufacturerDescription, other.getManufacturerDescription())) {
                return false;
            }
            if (!Objects.equals(this._mtu, other.getMtu())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                EthernetImpl otherImpl = (EthernetImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Ethernet>>, Augmentation<Ethernet>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "Ethernet [";
            StringBuilder builder = new StringBuilder(name);
            if (this._duplex != null) {
                builder.append("_duplex=");
                builder.append((Object)this._duplex);
                builder.append(", ");
            }
            if (this._manufacturerDescription != null) {
                builder.append("_manufacturerDescription=");
                builder.append(this._manufacturerDescription);
                builder.append(", ");
            }
            if (this._mtu != null) {
                builder.append("_mtu=");
                builder.append(this._mtu);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

