/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev161214.interfaces._interface;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev161214.DecapNode;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev161214.VxlanBaseAttributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev161214.VxlanVni;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev161214.interfaces._interface.Vxlan;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class VxlanBuilder
implements Builder<Vxlan> {
    private Class<? extends DecapNode> _decapNext;
    private IpAddress _dst;
    private Long _encapVrfId;
    private IpAddress _src;
    private VxlanVni _vni;
    Map<Class<? extends Augmentation<Vxlan>>, Augmentation<Vxlan>> augmentation = Collections.emptyMap();

    public VxlanBuilder() {
    }

    public VxlanBuilder(VxlanBaseAttributes arg) {
        this._src = arg.getSrc();
        this._dst = arg.getDst();
        this._vni = arg.getVni();
        this._encapVrfId = arg.getEncapVrfId();
        this._decapNext = arg.getDecapNext();
    }

    public VxlanBuilder(Vxlan base) {
        AugmentationHolder casted;
        this._decapNext = base.getDecapNext();
        this._dst = base.getDst();
        this._encapVrfId = base.getEncapVrfId();
        this._src = base.getSrc();
        this._vni = base.getVni();
        if (base instanceof VxlanImpl) {
            VxlanImpl impl = (VxlanImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Vxlan>>, Augmentation<Vxlan>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Vxlan>>, Augmentation<Vxlan>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof VxlanBaseAttributes) {
            this._src = ((VxlanBaseAttributes)arg).getSrc();
            this._dst = ((VxlanBaseAttributes)arg).getDst();
            this._vni = ((VxlanBaseAttributes)arg).getVni();
            this._encapVrfId = ((VxlanBaseAttributes)arg).getEncapVrfId();
            this._decapNext = ((VxlanBaseAttributes)arg).getDecapNext();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev161214.VxlanBaseAttributes] \nbut was: " + arg);
        }
    }

    public Class<? extends DecapNode> getDecapNext() {
        return this._decapNext;
    }

    public IpAddress getDst() {
        return this._dst;
    }

    public Long getEncapVrfId() {
        return this._encapVrfId;
    }

    public IpAddress getSrc() {
        return this._src;
    }

    public VxlanVni getVni() {
        return this._vni;
    }

    public <E extends Augmentation<Vxlan>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public VxlanBuilder setDecapNext(Class<? extends DecapNode> value) {
        this._decapNext = value;
        return this;
    }

    public VxlanBuilder setDst(IpAddress value) {
        this._dst = value;
        return this;
    }

    private static void checkEncapVrfIdRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..4294967295]].", value));
    }

    public VxlanBuilder setEncapVrfId(Long value) {
        if (value != null) {
            VxlanBuilder.checkEncapVrfIdRange(value);
        }
        this._encapVrfId = value;
        return this;
    }

    public VxlanBuilder setSrc(IpAddress value) {
        this._src = value;
        return this;
    }

    public VxlanBuilder setVni(VxlanVni value) {
        this._vni = value;
        return this;
    }

    public VxlanBuilder addAugmentation(Class<? extends Augmentation<Vxlan>> augmentationType, Augmentation<Vxlan> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Vxlan>>, Augmentation<Vxlan>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public VxlanBuilder removeAugmentation(Class<? extends Augmentation<Vxlan>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Vxlan build() {
        return new VxlanImpl(this);
    }

    private static final class VxlanImpl
    implements Vxlan {
        private final Class<? extends DecapNode> _decapNext;
        private final IpAddress _dst;
        private final Long _encapVrfId;
        private final IpAddress _src;
        private final VxlanVni _vni;
        private Map<Class<? extends Augmentation<Vxlan>>, Augmentation<Vxlan>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<Vxlan> getImplementedInterface() {
            return Vxlan.class;
        }

        private VxlanImpl(VxlanBuilder base) {
            this._decapNext = base.getDecapNext();
            this._dst = base.getDst();
            this._encapVrfId = base.getEncapVrfId();
            this._src = base.getSrc();
            this._vni = base.getVni();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<Vxlan>>, Augmentation<Vxlan>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<Vxlan>>, Augmentation<Vxlan>>(base.augmentation);
                }
            }
        }

        @Override
        public Class<? extends DecapNode> getDecapNext() {
            return this._decapNext;
        }

        @Override
        public IpAddress getDst() {
            return this._dst;
        }

        @Override
        public Long getEncapVrfId() {
            return this._encapVrfId;
        }

        @Override
        public IpAddress getSrc() {
            return this._src;
        }

        @Override
        public VxlanVni getVni() {
            return this._vni;
        }

        public <E extends Augmentation<Vxlan>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._decapNext);
            result = 31 * result + Objects.hashCode(this._dst);
            result = 31 * result + Objects.hashCode(this._encapVrfId);
            result = 31 * result + Objects.hashCode(this._src);
            result = 31 * result + Objects.hashCode(this._vni);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Vxlan.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Vxlan other = (Vxlan)obj;
            if (!Objects.equals(this._decapNext, other.getDecapNext())) {
                return false;
            }
            if (!Objects.equals(this._dst, other.getDst())) {
                return false;
            }
            if (!Objects.equals(this._encapVrfId, other.getEncapVrfId())) {
                return false;
            }
            if (!Objects.equals(this._src, other.getSrc())) {
                return false;
            }
            if (!Objects.equals(this._vni, other.getVni())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                VxlanImpl otherImpl = (VxlanImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Vxlan>>, Augmentation<Vxlan>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "Vxlan [";
            StringBuilder builder = new StringBuilder(name);
            if (this._decapNext != null) {
                builder.append("_decapNext=");
                builder.append(this._decapNext);
                builder.append(", ");
            }
            if (this._dst != null) {
                builder.append("_dst=");
                builder.append(this._dst);
                builder.append(", ");
            }
            if (this._encapVrfId != null) {
                builder.append("_encapVrfId=");
                builder.append(this._encapVrfId);
                builder.append(", ");
            }
            if (this._src != null) {
                builder.append("_src=");
                builder.append(this._src);
                builder.append(", ");
            }
            if (this._vni != null) {
                builder.append("_vni=");
                builder.append(this._vni);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

