/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev161214.interfaces._interface;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev161214.InterfaceTag;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev161214.VhostUserInterfaceBaseAttributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev161214.VhostUserInterfaceConfigAttributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev161214.VhostUserRole;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev161214.interfaces._interface.VhostUser;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class VhostUserBuilder
implements Builder<VhostUser> {
    private Long _deviceInstance;
    private VhostUserRole _role;
    private String _socket;
    private String _tag;
    Map<Class<? extends Augmentation<VhostUser>>, Augmentation<VhostUser>> augmentation = Collections.emptyMap();

    public VhostUserBuilder() {
    }

    public VhostUserBuilder(VhostUserInterfaceBaseAttributes arg) {
        this._socket = arg.getSocket();
        this._role = arg.getRole();
        this._tag = arg.getTag();
    }

    public VhostUserBuilder(InterfaceTag arg) {
        this._tag = arg.getTag();
    }

    public VhostUserBuilder(VhostUserInterfaceConfigAttributes arg) {
        this._deviceInstance = arg.getDeviceInstance();
    }

    public VhostUserBuilder(VhostUser base) {
        AugmentationHolder casted;
        this._deviceInstance = base.getDeviceInstance();
        this._role = base.getRole();
        this._socket = base.getSocket();
        this._tag = base.getTag();
        if (base instanceof VhostUserImpl) {
            VhostUserImpl impl = (VhostUserImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<VhostUser>>, Augmentation<VhostUser>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<VhostUser>>, Augmentation<VhostUser>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof InterfaceTag) {
            this._tag = ((InterfaceTag)arg).getTag();
            isValidArg = true;
        }
        if (arg instanceof VhostUserInterfaceConfigAttributes) {
            this._deviceInstance = ((VhostUserInterfaceConfigAttributes)arg).getDeviceInstance();
            isValidArg = true;
        }
        if (arg instanceof VhostUserInterfaceBaseAttributes) {
            this._socket = ((VhostUserInterfaceBaseAttributes)arg).getSocket();
            this._role = ((VhostUserInterfaceBaseAttributes)arg).getRole();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev161214.InterfaceTag, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev161214.VhostUserInterfaceConfigAttributes, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev161214.VhostUserInterfaceBaseAttributes] \nbut was: " + arg);
        }
    }

    public Long getDeviceInstance() {
        return this._deviceInstance;
    }

    public VhostUserRole getRole() {
        return this._role;
    }

    public String getSocket() {
        return this._socket;
    }

    public String getTag() {
        return this._tag;
    }

    public <E extends Augmentation<VhostUser>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    private static void checkDeviceInstanceRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..4294967295]].", value));
    }

    public VhostUserBuilder setDeviceInstance(Long value) {
        if (value != null) {
            VhostUserBuilder.checkDeviceInstanceRange(value);
        }
        this._deviceInstance = value;
        return this;
    }

    public VhostUserBuilder setRole(VhostUserRole value) {
        this._role = value;
        return this;
    }

    private static void check_socketLength(String value) {
        int length = value.length();
        if (length >= 1 && length <= 255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid length: %s, expected: [[1..255]].", value));
    }

    public VhostUserBuilder setSocket(String value) {
        if (value != null) {
            VhostUserBuilder.check_socketLength(value);
        }
        this._socket = value;
        return this;
    }

    private static void check_tagLength(String value) {
        int length = value.length();
        if (length >= 1 && length <= 63) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid length: %s, expected: [[1..63]].", value));
    }

    public VhostUserBuilder setTag(String value) {
        if (value != null) {
            VhostUserBuilder.check_tagLength(value);
        }
        this._tag = value;
        return this;
    }

    public VhostUserBuilder addAugmentation(Class<? extends Augmentation<VhostUser>> augmentationType, Augmentation<VhostUser> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<VhostUser>>, Augmentation<VhostUser>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public VhostUserBuilder removeAugmentation(Class<? extends Augmentation<VhostUser>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public VhostUser build() {
        return new VhostUserImpl(this);
    }

    private static final class VhostUserImpl
    implements VhostUser {
        private final Long _deviceInstance;
        private final VhostUserRole _role;
        private final String _socket;
        private final String _tag;
        private Map<Class<? extends Augmentation<VhostUser>>, Augmentation<VhostUser>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<VhostUser> getImplementedInterface() {
            return VhostUser.class;
        }

        private VhostUserImpl(VhostUserBuilder base) {
            this._deviceInstance = base.getDeviceInstance();
            this._role = base.getRole();
            this._socket = base.getSocket();
            this._tag = base.getTag();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<VhostUser>>, Augmentation<VhostUser>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<VhostUser>>, Augmentation<VhostUser>>(base.augmentation);
                }
            }
        }

        @Override
        public Long getDeviceInstance() {
            return this._deviceInstance;
        }

        @Override
        public VhostUserRole getRole() {
            return this._role;
        }

        @Override
        public String getSocket() {
            return this._socket;
        }

        @Override
        public String getTag() {
            return this._tag;
        }

        public <E extends Augmentation<VhostUser>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._deviceInstance);
            result = 31 * result + Objects.hashCode((Object)this._role);
            result = 31 * result + Objects.hashCode(this._socket);
            result = 31 * result + Objects.hashCode(this._tag);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!VhostUser.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            VhostUser other = (VhostUser)obj;
            if (!Objects.equals(this._deviceInstance, other.getDeviceInstance())) {
                return false;
            }
            if (!Objects.equals((Object)this._role, (Object)other.getRole())) {
                return false;
            }
            if (!Objects.equals(this._socket, other.getSocket())) {
                return false;
            }
            if (!Objects.equals(this._tag, other.getTag())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                VhostUserImpl otherImpl = (VhostUserImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<VhostUser>>, Augmentation<VhostUser>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "VhostUser [";
            StringBuilder builder = new StringBuilder(name);
            if (this._deviceInstance != null) {
                builder.append("_deviceInstance=");
                builder.append(this._deviceInstance);
                builder.append(", ");
            }
            if (this._role != null) {
                builder.append("_role=");
                builder.append((Object)this._role);
                builder.append(", ");
            }
            if (this._socket != null) {
                builder.append("_socket=");
                builder.append(this._socket);
                builder.append(", ");
            }
            if (this._tag != null) {
                builder.append("_tag=");
                builder.append(this._tag);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

