/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev161214.interfaces._interface;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.PhysAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev161214.InterfaceTag;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev161214.TapInterfaceBaseAttributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev161214.TapInterfaceConfigAttributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev161214.interfaces._interface.Tap;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class TapBuilder
implements Builder<Tap> {
    private Long _deviceInstance;
    private PhysAddress _mac;
    private String _tag;
    private String _tapName;
    Map<Class<? extends Augmentation<Tap>>, Augmentation<Tap>> augmentation = Collections.emptyMap();

    public TapBuilder() {
    }

    public TapBuilder(TapInterfaceBaseAttributes arg) {
        this._tapName = arg.getTapName();
        this._tag = arg.getTag();
    }

    public TapBuilder(InterfaceTag arg) {
        this._tag = arg.getTag();
    }

    public TapBuilder(TapInterfaceConfigAttributes arg) {
        this._mac = arg.getMac();
        this._deviceInstance = arg.getDeviceInstance();
    }

    public TapBuilder(Tap base) {
        AugmentationHolder casted;
        this._deviceInstance = base.getDeviceInstance();
        this._mac = base.getMac();
        this._tag = base.getTag();
        this._tapName = base.getTapName();
        if (base instanceof TapImpl) {
            TapImpl impl = (TapImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Tap>>, Augmentation<Tap>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Tap>>, Augmentation<Tap>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof TapInterfaceBaseAttributes) {
            this._tapName = ((TapInterfaceBaseAttributes)arg).getTapName();
            isValidArg = true;
        }
        if (arg instanceof InterfaceTag) {
            this._tag = ((InterfaceTag)arg).getTag();
            isValidArg = true;
        }
        if (arg instanceof TapInterfaceConfigAttributes) {
            this._mac = ((TapInterfaceConfigAttributes)arg).getMac();
            this._deviceInstance = ((TapInterfaceConfigAttributes)arg).getDeviceInstance();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev161214.TapInterfaceBaseAttributes, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev161214.InterfaceTag, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev161214.TapInterfaceConfigAttributes] \nbut was: " + arg);
        }
    }

    public Long getDeviceInstance() {
        return this._deviceInstance;
    }

    public PhysAddress getMac() {
        return this._mac;
    }

    public String getTag() {
        return this._tag;
    }

    public String getTapName() {
        return this._tapName;
    }

    public <E extends Augmentation<Tap>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    private static void checkDeviceInstanceRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..4294967295]].", value));
    }

    public TapBuilder setDeviceInstance(Long value) {
        if (value != null) {
            TapBuilder.checkDeviceInstanceRange(value);
        }
        this._deviceInstance = value;
        return this;
    }

    public TapBuilder setMac(PhysAddress value) {
        this._mac = value;
        return this;
    }

    private static void check_tagLength(String value) {
        int length = value.length();
        if (length >= 1 && length <= 63) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid length: %s, expected: [[1..63]].", value));
    }

    public TapBuilder setTag(String value) {
        if (value != null) {
            TapBuilder.check_tagLength(value);
        }
        this._tag = value;
        return this;
    }

    private static void check_tapNameLength(String value) {
    }

    public TapBuilder setTapName(String value) {
        if (value != null) {
            TapBuilder.check_tapNameLength(value);
        }
        this._tapName = value;
        return this;
    }

    public TapBuilder addAugmentation(Class<? extends Augmentation<Tap>> augmentationType, Augmentation<Tap> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Tap>>, Augmentation<Tap>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public TapBuilder removeAugmentation(Class<? extends Augmentation<Tap>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Tap build() {
        return new TapImpl(this);
    }

    private static final class TapImpl
    implements Tap {
        private final Long _deviceInstance;
        private final PhysAddress _mac;
        private final String _tag;
        private final String _tapName;
        private Map<Class<? extends Augmentation<Tap>>, Augmentation<Tap>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<Tap> getImplementedInterface() {
            return Tap.class;
        }

        private TapImpl(TapBuilder base) {
            this._deviceInstance = base.getDeviceInstance();
            this._mac = base.getMac();
            this._tag = base.getTag();
            this._tapName = base.getTapName();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<Tap>>, Augmentation<Tap>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<Tap>>, Augmentation<Tap>>(base.augmentation);
                }
            }
        }

        @Override
        public Long getDeviceInstance() {
            return this._deviceInstance;
        }

        @Override
        public PhysAddress getMac() {
            return this._mac;
        }

        @Override
        public String getTag() {
            return this._tag;
        }

        @Override
        public String getTapName() {
            return this._tapName;
        }

        public <E extends Augmentation<Tap>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._deviceInstance);
            result = 31 * result + Objects.hashCode(this._mac);
            result = 31 * result + Objects.hashCode(this._tag);
            result = 31 * result + Objects.hashCode(this._tapName);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Tap.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Tap other = (Tap)obj;
            if (!Objects.equals(this._deviceInstance, other.getDeviceInstance())) {
                return false;
            }
            if (!Objects.equals(this._mac, other.getMac())) {
                return false;
            }
            if (!Objects.equals(this._tag, other.getTag())) {
                return false;
            }
            if (!Objects.equals(this._tapName, other.getTapName())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                TapImpl otherImpl = (TapImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Tap>>, Augmentation<Tap>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "Tap [";
            StringBuilder builder = new StringBuilder(name);
            if (this._deviceInstance != null) {
                builder.append("_deviceInstance=");
                builder.append(this._deviceInstance);
                builder.append(", ");
            }
            if (this._mac != null) {
                builder.append("_mac=");
                builder.append(this._mac);
                builder.append(", ");
            }
            if (this._tag != null) {
                builder.append("_tag=");
                builder.append(this._tag);
                builder.append(", ");
            }
            if (this._tapName != null) {
                builder.append("_tapName=");
                builder.append(this._tapName);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

