/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev161214.interfaces._interface;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4Address;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev161214.ProxyArpAttributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev161214.interfaces._interface.ProxyArp;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class ProxyArpBuilder
implements Builder<ProxyArp> {
    private Ipv4Address _highAddr;
    private Ipv4Address _lowAddr;
    private Long _vrfId;
    Map<Class<? extends Augmentation<ProxyArp>>, Augmentation<ProxyArp>> augmentation = Collections.emptyMap();

    public ProxyArpBuilder() {
    }

    public ProxyArpBuilder(ProxyArpAttributes arg) {
        this._vrfId = arg.getVrfId();
        this._lowAddr = arg.getLowAddr();
        this._highAddr = arg.getHighAddr();
    }

    public ProxyArpBuilder(ProxyArp base) {
        AugmentationHolder casted;
        this._highAddr = base.getHighAddr();
        this._lowAddr = base.getLowAddr();
        this._vrfId = base.getVrfId();
        if (base instanceof ProxyArpImpl) {
            ProxyArpImpl impl = (ProxyArpImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<ProxyArp>>, Augmentation<ProxyArp>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ProxyArp>>, Augmentation<ProxyArp>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof ProxyArpAttributes) {
            this._vrfId = ((ProxyArpAttributes)arg).getVrfId();
            this._lowAddr = ((ProxyArpAttributes)arg).getLowAddr();
            this._highAddr = ((ProxyArpAttributes)arg).getHighAddr();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev161214.ProxyArpAttributes] \nbut was: " + arg);
        }
    }

    public Ipv4Address getHighAddr() {
        return this._highAddr;
    }

    public Ipv4Address getLowAddr() {
        return this._lowAddr;
    }

    public Long getVrfId() {
        return this._vrfId;
    }

    public <E extends Augmentation<ProxyArp>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public ProxyArpBuilder setHighAddr(Ipv4Address value) {
        this._highAddr = value;
        return this;
    }

    public ProxyArpBuilder setLowAddr(Ipv4Address value) {
        this._lowAddr = value;
        return this;
    }

    private static void checkVrfIdRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..4294967295]].", value));
    }

    public ProxyArpBuilder setVrfId(Long value) {
        if (value != null) {
            ProxyArpBuilder.checkVrfIdRange(value);
        }
        this._vrfId = value;
        return this;
    }

    public ProxyArpBuilder addAugmentation(Class<? extends Augmentation<ProxyArp>> augmentationType, Augmentation<ProxyArp> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ProxyArp>>, Augmentation<ProxyArp>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public ProxyArpBuilder removeAugmentation(Class<? extends Augmentation<ProxyArp>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public ProxyArp build() {
        return new ProxyArpImpl(this);
    }

    private static final class ProxyArpImpl
    implements ProxyArp {
        private final Ipv4Address _highAddr;
        private final Ipv4Address _lowAddr;
        private final Long _vrfId;
        private Map<Class<? extends Augmentation<ProxyArp>>, Augmentation<ProxyArp>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<ProxyArp> getImplementedInterface() {
            return ProxyArp.class;
        }

        private ProxyArpImpl(ProxyArpBuilder base) {
            this._highAddr = base.getHighAddr();
            this._lowAddr = base.getLowAddr();
            this._vrfId = base.getVrfId();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<ProxyArp>>, Augmentation<ProxyArp>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<ProxyArp>>, Augmentation<ProxyArp>>(base.augmentation);
                }
            }
        }

        @Override
        public Ipv4Address getHighAddr() {
            return this._highAddr;
        }

        @Override
        public Ipv4Address getLowAddr() {
            return this._lowAddr;
        }

        @Override
        public Long getVrfId() {
            return this._vrfId;
        }

        public <E extends Augmentation<ProxyArp>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._highAddr);
            result = 31 * result + Objects.hashCode(this._lowAddr);
            result = 31 * result + Objects.hashCode(this._vrfId);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!ProxyArp.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            ProxyArp other = (ProxyArp)obj;
            if (!Objects.equals(this._highAddr, other.getHighAddr())) {
                return false;
            }
            if (!Objects.equals(this._lowAddr, other.getLowAddr())) {
                return false;
            }
            if (!Objects.equals(this._vrfId, other.getVrfId())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                ProxyArpImpl otherImpl = (ProxyArpImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<ProxyArp>>, Augmentation<ProxyArp>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "ProxyArp [";
            StringBuilder builder = new StringBuilder(name);
            if (this._highAddr != null) {
                builder.append("_highAddr=");
                builder.append(this._highAddr);
                builder.append(", ");
            }
            if (this._lowAddr != null) {
                builder.append("_lowAddr=");
                builder.append(this._lowAddr);
                builder.append(", ");
            }
            if (this._vrfId != null) {
                builder.append("_vrfId=");
                builder.append(this._vrfId);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

