/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev161214;

import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.Objects;

public class VxlanVni
implements Serializable {
    private static final long serialVersionUID = -1581787068544346330L;
    private final Long _value;

    private static void check_valueRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..16777215]].", value));
    }

    @ConstructorProperties(value={"value"})
    public VxlanVni(Long _value) {
        if (_value != null) {
            VxlanVni.check_valueRange(_value);
        }
        Preconditions.checkNotNull((Object)_value, (Object)"Supplied value may not be null");
        this._value = _value;
    }

    public VxlanVni(VxlanVni source) {
        this._value = source._value;
    }

    public static VxlanVni getDefaultInstance(String defaultValue) {
        return new VxlanVni(Long.valueOf(defaultValue));
    }

    public Long getValue() {
        return this._value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Objects.hashCode(this._value);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VxlanVni other = (VxlanVni)obj;
        return Objects.equals(this._value, other._value);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(VxlanVni.class.getSimpleName()).append(" [");
        boolean first = true;
        if (this._value != null) {
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("_value=");
            builder.append(this._value);
        }
        return builder.append(']').toString();
    }
}

