/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev161214;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev161214.InterfaceNameOrIndex;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev161214.InterfaceStateChange;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev161214.InterfaceStatus;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class InterfaceStateChangeBuilder
implements Builder<InterfaceStateChange> {
    private InterfaceStatus _adminStatus;
    private InterfaceNameOrIndex _name;
    private InterfaceStatus _operStatus;
    Map<Class<? extends Augmentation<InterfaceStateChange>>, Augmentation<InterfaceStateChange>> augmentation = Collections.emptyMap();

    public InterfaceStateChangeBuilder() {
    }

    public InterfaceStateChangeBuilder(InterfaceStateChange base) {
        AugmentationHolder casted;
        this._adminStatus = base.getAdminStatus();
        this._name = base.getName();
        this._operStatus = base.getOperStatus();
        if (base instanceof InterfaceStateChangeImpl) {
            InterfaceStateChangeImpl impl = (InterfaceStateChangeImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<InterfaceStateChange>>, Augmentation<InterfaceStateChange>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<InterfaceStateChange>>, Augmentation<InterfaceStateChange>>(casted.augmentations());
        }
    }

    public InterfaceStatus getAdminStatus() {
        return this._adminStatus;
    }

    public InterfaceNameOrIndex getName() {
        return this._name;
    }

    public InterfaceStatus getOperStatus() {
        return this._operStatus;
    }

    public <E extends Augmentation<InterfaceStateChange>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public InterfaceStateChangeBuilder setAdminStatus(InterfaceStatus value) {
        this._adminStatus = value;
        return this;
    }

    public InterfaceStateChangeBuilder setName(InterfaceNameOrIndex value) {
        this._name = value;
        return this;
    }

    public InterfaceStateChangeBuilder setOperStatus(InterfaceStatus value) {
        this._operStatus = value;
        return this;
    }

    public InterfaceStateChangeBuilder addAugmentation(Class<? extends Augmentation<InterfaceStateChange>> augmentationType, Augmentation<InterfaceStateChange> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<InterfaceStateChange>>, Augmentation<InterfaceStateChange>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public InterfaceStateChangeBuilder removeAugmentation(Class<? extends Augmentation<InterfaceStateChange>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public InterfaceStateChange build() {
        return new InterfaceStateChangeImpl(this);
    }

    private static final class InterfaceStateChangeImpl
    implements InterfaceStateChange {
        private final InterfaceStatus _adminStatus;
        private final InterfaceNameOrIndex _name;
        private final InterfaceStatus _operStatus;
        private Map<Class<? extends Augmentation<InterfaceStateChange>>, Augmentation<InterfaceStateChange>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<InterfaceStateChange> getImplementedInterface() {
            return InterfaceStateChange.class;
        }

        private InterfaceStateChangeImpl(InterfaceStateChangeBuilder base) {
            this._adminStatus = base.getAdminStatus();
            this._name = base.getName();
            this._operStatus = base.getOperStatus();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<InterfaceStateChange>>, Augmentation<InterfaceStateChange>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<InterfaceStateChange>>, Augmentation<InterfaceStateChange>>(base.augmentation);
                }
            }
        }

        @Override
        public InterfaceStatus getAdminStatus() {
            return this._adminStatus;
        }

        @Override
        public InterfaceNameOrIndex getName() {
            return this._name;
        }

        @Override
        public InterfaceStatus getOperStatus() {
            return this._operStatus;
        }

        public <E extends Augmentation<InterfaceStateChange>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode((Object)this._adminStatus);
            result = 31 * result + Objects.hashCode(this._name);
            result = 31 * result + Objects.hashCode((Object)this._operStatus);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!InterfaceStateChange.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            InterfaceStateChange other = (InterfaceStateChange)obj;
            if (!Objects.equals((Object)this._adminStatus, (Object)other.getAdminStatus())) {
                return false;
            }
            if (!Objects.equals(this._name, other.getName())) {
                return false;
            }
            if (!Objects.equals((Object)this._operStatus, (Object)other.getOperStatus())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                InterfaceStateChangeImpl otherImpl = (InterfaceStateChangeImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<InterfaceStateChange>>, Augmentation<InterfaceStateChange>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "InterfaceStateChange [";
            StringBuilder builder = new StringBuilder(name);
            if (this._adminStatus != null) {
                builder.append("_adminStatus=");
                builder.append((Object)this._adminStatus);
                builder.append(", ");
            }
            if (this._name != null) {
                builder.append("_name=");
                builder.append(this._name);
                builder.append(", ");
            }
            if (this._operStatus != null) {
                builder.append("_operStatus=");
                builder.append((Object)this._operStatus);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

