/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ovsdb.rev150105.ovsdb.port._interface.attributes;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.l2.types.rev130827.VlanId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ovsdb.rev150105.ovsdb.port._interface.attributes.Trunks;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class TrunksBuilder
implements Builder<Trunks> {
    private VlanId _trunk;
    Map<Class<? extends Augmentation<Trunks>>, Augmentation<Trunks>> augmentation = Collections.emptyMap();

    public TrunksBuilder() {
    }

    public TrunksBuilder(Trunks base) {
        AugmentationHolder casted;
        this._trunk = base.getTrunk();
        if (base instanceof TrunksImpl) {
            TrunksImpl impl = (TrunksImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Trunks>>, Augmentation<Trunks>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Trunks>>, Augmentation<Trunks>>(casted.augmentations());
        }
    }

    public VlanId getTrunk() {
        return this._trunk;
    }

    public <E extends Augmentation<Trunks>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public TrunksBuilder setTrunk(VlanId value) {
        this._trunk = value;
        return this;
    }

    public TrunksBuilder addAugmentation(Class<? extends Augmentation<Trunks>> augmentationType, Augmentation<Trunks> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Trunks>>, Augmentation<Trunks>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public TrunksBuilder removeAugmentation(Class<? extends Augmentation<Trunks>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Trunks build() {
        return new TrunksImpl(this);
    }

    private static final class TrunksImpl
    implements Trunks {
        private final VlanId _trunk;
        private Map<Class<? extends Augmentation<Trunks>>, Augmentation<Trunks>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<Trunks> getImplementedInterface() {
            return Trunks.class;
        }

        private TrunksImpl(TrunksBuilder base) {
            this._trunk = base.getTrunk();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<Trunks>>, Augmentation<Trunks>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<Trunks>>, Augmentation<Trunks>>(base.augmentation);
                }
            }
        }

        @Override
        public VlanId getTrunk() {
            return this._trunk;
        }

        public <E extends Augmentation<Trunks>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._trunk);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Trunks.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Trunks other = (Trunks)obj;
            if (!Objects.equals(this._trunk, other.getTrunk())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                TrunksImpl otherImpl = (TrunksImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Trunks>>, Augmentation<Trunks>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "Trunks [";
            StringBuilder builder = new StringBuilder(name);
            if (this._trunk != null) {
                builder.append("_trunk=");
                builder.append(this._trunk);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

