/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ovsdb.rev150105.ovsdb.port._interface.attributes;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ovsdb.rev150105.OvsdbQosRef;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ovsdb.rev150105.ovsdb.port._interface.attributes.QosEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ovsdb.rev150105.ovsdb.port._interface.attributes.QosEntryKey;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class QosEntryBuilder
implements Builder<QosEntry> {
    private QosEntryKey _key;
    private Long _qosKey;
    private OvsdbQosRef _qosRef;
    Map<Class<? extends Augmentation<QosEntry>>, Augmentation<QosEntry>> augmentation = Collections.emptyMap();

    public QosEntryBuilder() {
    }

    public QosEntryBuilder(QosEntry base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new QosEntryKey(base.getQosKey());
            this._qosKey = base.getQosKey();
        } else {
            this._key = base.getKey();
            this._qosKey = this._key.getQosKey();
        }
        this._qosRef = base.getQosRef();
        if (base instanceof QosEntryImpl) {
            QosEntryImpl impl = (QosEntryImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<QosEntry>>, Augmentation<QosEntry>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<QosEntry>>, Augmentation<QosEntry>>(casted.augmentations());
        }
    }

    public QosEntryKey getKey() {
        return this._key;
    }

    public Long getQosKey() {
        return this._qosKey;
    }

    public OvsdbQosRef getQosRef() {
        return this._qosRef;
    }

    public <E extends Augmentation<QosEntry>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public QosEntryBuilder setKey(QosEntryKey value) {
        this._key = value;
        return this;
    }

    private static void checkQosKeyRange(long value) {
        if (value >= 1L && value <= 1L) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[1..1]].", value));
    }

    public QosEntryBuilder setQosKey(Long value) {
        if (value != null) {
            QosEntryBuilder.checkQosKeyRange(value);
        }
        this._qosKey = value;
        return this;
    }

    public QosEntryBuilder setQosRef(OvsdbQosRef value) {
        this._qosRef = value;
        return this;
    }

    public QosEntryBuilder addAugmentation(Class<? extends Augmentation<QosEntry>> augmentationType, Augmentation<QosEntry> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<QosEntry>>, Augmentation<QosEntry>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public QosEntryBuilder removeAugmentation(Class<? extends Augmentation<QosEntry>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public QosEntry build() {
        return new QosEntryImpl(this);
    }

    private static final class QosEntryImpl
    implements QosEntry {
        private final QosEntryKey _key;
        private final Long _qosKey;
        private final OvsdbQosRef _qosRef;
        private Map<Class<? extends Augmentation<QosEntry>>, Augmentation<QosEntry>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<QosEntry> getImplementedInterface() {
            return QosEntry.class;
        }

        private QosEntryImpl(QosEntryBuilder base) {
            if (base.getKey() == null) {
                this._key = new QosEntryKey(base.getQosKey());
                this._qosKey = base.getQosKey();
            } else {
                this._key = base.getKey();
                this._qosKey = this._key.getQosKey();
            }
            this._qosRef = base.getQosRef();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<QosEntry>>, Augmentation<QosEntry>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<QosEntry>>, Augmentation<QosEntry>>(base.augmentation);
                }
            }
        }

        @Override
        public QosEntryKey getKey() {
            return this._key;
        }

        @Override
        public Long getQosKey() {
            return this._qosKey;
        }

        @Override
        public OvsdbQosRef getQosRef() {
            return this._qosRef;
        }

        public <E extends Augmentation<QosEntry>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._key);
            result = 31 * result + Objects.hashCode(this._qosKey);
            result = 31 * result + Objects.hashCode(this._qosRef);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!QosEntry.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            QosEntry other = (QosEntry)obj;
            if (!Objects.equals(this._key, other.getKey())) {
                return false;
            }
            if (!Objects.equals(this._qosKey, other.getQosKey())) {
                return false;
            }
            if (!Objects.equals(this._qosRef, other.getQosRef())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                QosEntryImpl otherImpl = (QosEntryImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<QosEntry>>, Augmentation<QosEntry>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "QosEntry [";
            StringBuilder builder = new StringBuilder(name);
            if (this._key != null) {
                builder.append("_key=");
                builder.append(this._key);
                builder.append(", ");
            }
            if (this._qosKey != null) {
                builder.append("_qosKey=");
                builder.append(this._qosKey);
                builder.append(", ");
            }
            if (this._qosRef != null) {
                builder.append("_qosRef=");
                builder.append(this._qosRef);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

