/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ovsdb.rev150105.ovsdb.port._interface.attributes;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ovsdb.rev150105.ovsdb.port._interface.attributes.Options;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ovsdb.rev150105.ovsdb.port._interface.attributes.OptionsKey;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class OptionsBuilder
implements Builder<Options> {
    private OptionsKey _key;
    private String _option;
    private String _value;
    Map<Class<? extends Augmentation<Options>>, Augmentation<Options>> augmentation = Collections.emptyMap();

    public OptionsBuilder() {
    }

    public OptionsBuilder(Options base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new OptionsKey(base.getOption());
            this._option = base.getOption();
        } else {
            this._key = base.getKey();
            this._option = this._key.getOption();
        }
        this._value = base.getValue();
        if (base instanceof OptionsImpl) {
            OptionsImpl impl = (OptionsImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Options>>, Augmentation<Options>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Options>>, Augmentation<Options>>(casted.augmentations());
        }
    }

    public OptionsKey getKey() {
        return this._key;
    }

    public String getOption() {
        return this._option;
    }

    public String getValue() {
        return this._value;
    }

    public <E extends Augmentation<Options>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public OptionsBuilder setKey(OptionsKey value) {
        this._key = value;
        return this;
    }

    public OptionsBuilder setOption(String value) {
        this._option = value;
        return this;
    }

    public OptionsBuilder setValue(String value) {
        this._value = value;
        return this;
    }

    public OptionsBuilder addAugmentation(Class<? extends Augmentation<Options>> augmentationType, Augmentation<Options> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Options>>, Augmentation<Options>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public OptionsBuilder removeAugmentation(Class<? extends Augmentation<Options>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Options build() {
        return new OptionsImpl(this);
    }

    private static final class OptionsImpl
    implements Options {
        private final OptionsKey _key;
        private final String _option;
        private final String _value;
        private Map<Class<? extends Augmentation<Options>>, Augmentation<Options>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<Options> getImplementedInterface() {
            return Options.class;
        }

        private OptionsImpl(OptionsBuilder base) {
            if (base.getKey() == null) {
                this._key = new OptionsKey(base.getOption());
                this._option = base.getOption();
            } else {
                this._key = base.getKey();
                this._option = this._key.getOption();
            }
            this._value = base.getValue();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<Options>>, Augmentation<Options>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<Options>>, Augmentation<Options>>(base.augmentation);
                }
            }
        }

        @Override
        public OptionsKey getKey() {
            return this._key;
        }

        @Override
        public String getOption() {
            return this._option;
        }

        @Override
        public String getValue() {
            return this._value;
        }

        public <E extends Augmentation<Options>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._key);
            result = 31 * result + Objects.hashCode(this._option);
            result = 31 * result + Objects.hashCode(this._value);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Options.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Options other = (Options)obj;
            if (!Objects.equals(this._key, other.getKey())) {
                return false;
            }
            if (!Objects.equals(this._option, other.getOption())) {
                return false;
            }
            if (!Objects.equals(this._value, other.getValue())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                OptionsImpl otherImpl = (OptionsImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Options>>, Augmentation<Options>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "Options [";
            StringBuilder builder = new StringBuilder(name);
            if (this._key != null) {
                builder.append("_key=");
                builder.append(this._key);
                builder.append(", ");
            }
            if (this._option != null) {
                builder.append("_option=");
                builder.append(this._option);
                builder.append(", ");
            }
            if (this._value != null) {
                builder.append("_value=");
                builder.append(this._value);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

