/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ovsdb.rev150105.ovsdb.port._interface.attributes;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ovsdb.rev150105.ovsdb.port._interface.attributes.InterfaceLldp;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ovsdb.rev150105.ovsdb.port._interface.attributes.InterfaceLldpKey;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class InterfaceLldpBuilder
implements Builder<InterfaceLldp> {
    private InterfaceLldpKey _key;
    private String _lldpKey;
    private String _lldpValue;
    Map<Class<? extends Augmentation<InterfaceLldp>>, Augmentation<InterfaceLldp>> augmentation = Collections.emptyMap();

    public InterfaceLldpBuilder() {
    }

    public InterfaceLldpBuilder(InterfaceLldp base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new InterfaceLldpKey(base.getLldpKey());
            this._lldpKey = base.getLldpKey();
        } else {
            this._key = base.getKey();
            this._lldpKey = this._key.getLldpKey();
        }
        this._lldpValue = base.getLldpValue();
        if (base instanceof InterfaceLldpImpl) {
            InterfaceLldpImpl impl = (InterfaceLldpImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<InterfaceLldp>>, Augmentation<InterfaceLldp>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<InterfaceLldp>>, Augmentation<InterfaceLldp>>(casted.augmentations());
        }
    }

    public InterfaceLldpKey getKey() {
        return this._key;
    }

    public String getLldpKey() {
        return this._lldpKey;
    }

    public String getLldpValue() {
        return this._lldpValue;
    }

    public <E extends Augmentation<InterfaceLldp>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public InterfaceLldpBuilder setKey(InterfaceLldpKey value) {
        this._key = value;
        return this;
    }

    public InterfaceLldpBuilder setLldpKey(String value) {
        this._lldpKey = value;
        return this;
    }

    public InterfaceLldpBuilder setLldpValue(String value) {
        this._lldpValue = value;
        return this;
    }

    public InterfaceLldpBuilder addAugmentation(Class<? extends Augmentation<InterfaceLldp>> augmentationType, Augmentation<InterfaceLldp> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<InterfaceLldp>>, Augmentation<InterfaceLldp>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public InterfaceLldpBuilder removeAugmentation(Class<? extends Augmentation<InterfaceLldp>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public InterfaceLldp build() {
        return new InterfaceLldpImpl(this);
    }

    private static final class InterfaceLldpImpl
    implements InterfaceLldp {
        private final InterfaceLldpKey _key;
        private final String _lldpKey;
        private final String _lldpValue;
        private Map<Class<? extends Augmentation<InterfaceLldp>>, Augmentation<InterfaceLldp>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<InterfaceLldp> getImplementedInterface() {
            return InterfaceLldp.class;
        }

        private InterfaceLldpImpl(InterfaceLldpBuilder base) {
            if (base.getKey() == null) {
                this._key = new InterfaceLldpKey(base.getLldpKey());
                this._lldpKey = base.getLldpKey();
            } else {
                this._key = base.getKey();
                this._lldpKey = this._key.getLldpKey();
            }
            this._lldpValue = base.getLldpValue();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<InterfaceLldp>>, Augmentation<InterfaceLldp>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<InterfaceLldp>>, Augmentation<InterfaceLldp>>(base.augmentation);
                }
            }
        }

        @Override
        public InterfaceLldpKey getKey() {
            return this._key;
        }

        @Override
        public String getLldpKey() {
            return this._lldpKey;
        }

        @Override
        public String getLldpValue() {
            return this._lldpValue;
        }

        public <E extends Augmentation<InterfaceLldp>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._key);
            result = 31 * result + Objects.hashCode(this._lldpKey);
            result = 31 * result + Objects.hashCode(this._lldpValue);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!InterfaceLldp.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            InterfaceLldp other = (InterfaceLldp)obj;
            if (!Objects.equals(this._key, other.getKey())) {
                return false;
            }
            if (!Objects.equals(this._lldpKey, other.getLldpKey())) {
                return false;
            }
            if (!Objects.equals(this._lldpValue, other.getLldpValue())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                InterfaceLldpImpl otherImpl = (InterfaceLldpImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<InterfaceLldp>>, Augmentation<InterfaceLldp>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "InterfaceLldp [";
            StringBuilder builder = new StringBuilder(name);
            if (this._key != null) {
                builder.append("_key=");
                builder.append(this._key);
                builder.append(", ");
            }
            if (this._lldpKey != null) {
                builder.append("_lldpKey=");
                builder.append(this._lldpKey);
                builder.append(", ");
            }
            if (this._lldpValue != null) {
                builder.append("_lldpValue=");
                builder.append(this._lldpValue);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

