/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ovsdb.rev150105.ovsdb.port._interface.attributes;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ovsdb.rev150105.ovsdb.port._interface.attributes.InterfaceExternalIds;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ovsdb.rev150105.ovsdb.port._interface.attributes.InterfaceExternalIdsKey;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class InterfaceExternalIdsBuilder
implements Builder<InterfaceExternalIds> {
    private String _externalIdKey;
    private String _externalIdValue;
    private InterfaceExternalIdsKey _key;
    Map<Class<? extends Augmentation<InterfaceExternalIds>>, Augmentation<InterfaceExternalIds>> augmentation = Collections.emptyMap();

    public InterfaceExternalIdsBuilder() {
    }

    public InterfaceExternalIdsBuilder(InterfaceExternalIds base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new InterfaceExternalIdsKey(base.getExternalIdKey());
            this._externalIdKey = base.getExternalIdKey();
        } else {
            this._key = base.getKey();
            this._externalIdKey = this._key.getExternalIdKey();
        }
        this._externalIdValue = base.getExternalIdValue();
        if (base instanceof InterfaceExternalIdsImpl) {
            InterfaceExternalIdsImpl impl = (InterfaceExternalIdsImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<InterfaceExternalIds>>, Augmentation<InterfaceExternalIds>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<InterfaceExternalIds>>, Augmentation<InterfaceExternalIds>>(casted.augmentations());
        }
    }

    public String getExternalIdKey() {
        return this._externalIdKey;
    }

    public String getExternalIdValue() {
        return this._externalIdValue;
    }

    public InterfaceExternalIdsKey getKey() {
        return this._key;
    }

    public <E extends Augmentation<InterfaceExternalIds>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public InterfaceExternalIdsBuilder setExternalIdKey(String value) {
        this._externalIdKey = value;
        return this;
    }

    public InterfaceExternalIdsBuilder setExternalIdValue(String value) {
        this._externalIdValue = value;
        return this;
    }

    public InterfaceExternalIdsBuilder setKey(InterfaceExternalIdsKey value) {
        this._key = value;
        return this;
    }

    public InterfaceExternalIdsBuilder addAugmentation(Class<? extends Augmentation<InterfaceExternalIds>> augmentationType, Augmentation<InterfaceExternalIds> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<InterfaceExternalIds>>, Augmentation<InterfaceExternalIds>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public InterfaceExternalIdsBuilder removeAugmentation(Class<? extends Augmentation<InterfaceExternalIds>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public InterfaceExternalIds build() {
        return new InterfaceExternalIdsImpl(this);
    }

    private static final class InterfaceExternalIdsImpl
    implements InterfaceExternalIds {
        private final String _externalIdKey;
        private final String _externalIdValue;
        private final InterfaceExternalIdsKey _key;
        private Map<Class<? extends Augmentation<InterfaceExternalIds>>, Augmentation<InterfaceExternalIds>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<InterfaceExternalIds> getImplementedInterface() {
            return InterfaceExternalIds.class;
        }

        private InterfaceExternalIdsImpl(InterfaceExternalIdsBuilder base) {
            if (base.getKey() == null) {
                this._key = new InterfaceExternalIdsKey(base.getExternalIdKey());
                this._externalIdKey = base.getExternalIdKey();
            } else {
                this._key = base.getKey();
                this._externalIdKey = this._key.getExternalIdKey();
            }
            this._externalIdValue = base.getExternalIdValue();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<InterfaceExternalIds>>, Augmentation<InterfaceExternalIds>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<InterfaceExternalIds>>, Augmentation<InterfaceExternalIds>>(base.augmentation);
                }
            }
        }

        @Override
        public String getExternalIdKey() {
            return this._externalIdKey;
        }

        @Override
        public String getExternalIdValue() {
            return this._externalIdValue;
        }

        @Override
        public InterfaceExternalIdsKey getKey() {
            return this._key;
        }

        public <E extends Augmentation<InterfaceExternalIds>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._externalIdKey);
            result = 31 * result + Objects.hashCode(this._externalIdValue);
            result = 31 * result + Objects.hashCode(this._key);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!InterfaceExternalIds.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            InterfaceExternalIds other = (InterfaceExternalIds)obj;
            if (!Objects.equals(this._externalIdKey, other.getExternalIdKey())) {
                return false;
            }
            if (!Objects.equals(this._externalIdValue, other.getExternalIdValue())) {
                return false;
            }
            if (!Objects.equals(this._key, other.getKey())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                InterfaceExternalIdsImpl otherImpl = (InterfaceExternalIdsImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<InterfaceExternalIds>>, Augmentation<InterfaceExternalIds>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "InterfaceExternalIds [";
            StringBuilder builder = new StringBuilder(name);
            if (this._externalIdKey != null) {
                builder.append("_externalIdKey=");
                builder.append(this._externalIdKey);
                builder.append(", ");
            }
            if (this._externalIdValue != null) {
                builder.append("_externalIdValue=");
                builder.append(this._externalIdValue);
                builder.append(", ");
            }
            if (this._key != null) {
                builder.append("_key=");
                builder.append(this._key);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

