/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ovsdb.rev150105.ovsdb.port._interface.attributes;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ovsdb.rev150105.ovsdb.port._interface.attributes.InterfaceBfd;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ovsdb.rev150105.ovsdb.port._interface.attributes.InterfaceBfdKey;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class InterfaceBfdBuilder
implements Builder<InterfaceBfd> {
    private String _bfdKey;
    private String _bfdValue;
    private InterfaceBfdKey _key;
    Map<Class<? extends Augmentation<InterfaceBfd>>, Augmentation<InterfaceBfd>> augmentation = Collections.emptyMap();

    public InterfaceBfdBuilder() {
    }

    public InterfaceBfdBuilder(InterfaceBfd base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new InterfaceBfdKey(base.getBfdKey());
            this._bfdKey = base.getBfdKey();
        } else {
            this._key = base.getKey();
            this._bfdKey = this._key.getBfdKey();
        }
        this._bfdValue = base.getBfdValue();
        if (base instanceof InterfaceBfdImpl) {
            InterfaceBfdImpl impl = (InterfaceBfdImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<InterfaceBfd>>, Augmentation<InterfaceBfd>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<InterfaceBfd>>, Augmentation<InterfaceBfd>>(casted.augmentations());
        }
    }

    public String getBfdKey() {
        return this._bfdKey;
    }

    public String getBfdValue() {
        return this._bfdValue;
    }

    public InterfaceBfdKey getKey() {
        return this._key;
    }

    public <E extends Augmentation<InterfaceBfd>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public InterfaceBfdBuilder setBfdKey(String value) {
        this._bfdKey = value;
        return this;
    }

    public InterfaceBfdBuilder setBfdValue(String value) {
        this._bfdValue = value;
        return this;
    }

    public InterfaceBfdBuilder setKey(InterfaceBfdKey value) {
        this._key = value;
        return this;
    }

    public InterfaceBfdBuilder addAugmentation(Class<? extends Augmentation<InterfaceBfd>> augmentationType, Augmentation<InterfaceBfd> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<InterfaceBfd>>, Augmentation<InterfaceBfd>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public InterfaceBfdBuilder removeAugmentation(Class<? extends Augmentation<InterfaceBfd>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public InterfaceBfd build() {
        return new InterfaceBfdImpl(this);
    }

    private static final class InterfaceBfdImpl
    implements InterfaceBfd {
        private final String _bfdKey;
        private final String _bfdValue;
        private final InterfaceBfdKey _key;
        private Map<Class<? extends Augmentation<InterfaceBfd>>, Augmentation<InterfaceBfd>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<InterfaceBfd> getImplementedInterface() {
            return InterfaceBfd.class;
        }

        private InterfaceBfdImpl(InterfaceBfdBuilder base) {
            if (base.getKey() == null) {
                this._key = new InterfaceBfdKey(base.getBfdKey());
                this._bfdKey = base.getBfdKey();
            } else {
                this._key = base.getKey();
                this._bfdKey = this._key.getBfdKey();
            }
            this._bfdValue = base.getBfdValue();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<InterfaceBfd>>, Augmentation<InterfaceBfd>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<InterfaceBfd>>, Augmentation<InterfaceBfd>>(base.augmentation);
                }
            }
        }

        @Override
        public String getBfdKey() {
            return this._bfdKey;
        }

        @Override
        public String getBfdValue() {
            return this._bfdValue;
        }

        @Override
        public InterfaceBfdKey getKey() {
            return this._key;
        }

        public <E extends Augmentation<InterfaceBfd>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._bfdKey);
            result = 31 * result + Objects.hashCode(this._bfdValue);
            result = 31 * result + Objects.hashCode(this._key);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!InterfaceBfd.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            InterfaceBfd other = (InterfaceBfd)obj;
            if (!Objects.equals(this._bfdKey, other.getBfdKey())) {
                return false;
            }
            if (!Objects.equals(this._bfdValue, other.getBfdValue())) {
                return false;
            }
            if (!Objects.equals(this._key, other.getKey())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                InterfaceBfdImpl otherImpl = (InterfaceBfdImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<InterfaceBfd>>, Augmentation<InterfaceBfd>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "InterfaceBfd [";
            StringBuilder builder = new StringBuilder(name);
            if (this._bfdKey != null) {
                builder.append("_bfdKey=");
                builder.append(this._bfdKey);
                builder.append(", ");
            }
            if (this._bfdValue != null) {
                builder.append("_bfdValue=");
                builder.append(this._bfdValue);
                builder.append(", ");
            }
            if (this._key != null) {
                builder.append("_key=");
                builder.append(this._key);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

