/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ovsdb.rev150105.ovsdb.node.attributes.autoattach;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ovsdb.rev150105.ovsdb.node.attributes.autoattach.Mappings;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ovsdb.rev150105.ovsdb.node.attributes.autoattach.MappingsKey;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class MappingsBuilder
implements Builder<Mappings> {
    private MappingsKey _key;
    private Long _mappingsKey;
    private Integer _mappingsValue;
    Map<Class<? extends Augmentation<Mappings>>, Augmentation<Mappings>> augmentation = Collections.emptyMap();

    public MappingsBuilder() {
    }

    public MappingsBuilder(Mappings base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new MappingsKey(base.getMappingsKey());
            this._mappingsKey = base.getMappingsKey();
        } else {
            this._key = base.getKey();
            this._mappingsKey = this._key.getMappingsKey();
        }
        this._mappingsValue = base.getMappingsValue();
        if (base instanceof MappingsImpl) {
            MappingsImpl impl = (MappingsImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Mappings>>, Augmentation<Mappings>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Mappings>>, Augmentation<Mappings>>(casted.augmentations());
        }
    }

    public MappingsKey getKey() {
        return this._key;
    }

    public Long getMappingsKey() {
        return this._mappingsKey;
    }

    public Integer getMappingsValue() {
        return this._mappingsValue;
    }

    public <E extends Augmentation<Mappings>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public MappingsBuilder setKey(MappingsKey value) {
        this._key = value;
        return this;
    }

    private static void checkMappingsKeyRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..16777215]].", value));
    }

    public MappingsBuilder setMappingsKey(Long value) {
        if (value != null) {
            MappingsBuilder.checkMappingsKeyRange(value);
        }
        this._mappingsKey = value;
        return this;
    }

    private static void checkMappingsValueRange(int value) {
        if (value >= 0 && value <= 4095) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..4095]].", value));
    }

    public MappingsBuilder setMappingsValue(Integer value) {
        if (value != null) {
            MappingsBuilder.checkMappingsValueRange(value);
        }
        this._mappingsValue = value;
        return this;
    }

    public MappingsBuilder addAugmentation(Class<? extends Augmentation<Mappings>> augmentationType, Augmentation<Mappings> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Mappings>>, Augmentation<Mappings>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public MappingsBuilder removeAugmentation(Class<? extends Augmentation<Mappings>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Mappings build() {
        return new MappingsImpl(this);
    }

    private static final class MappingsImpl
    implements Mappings {
        private final MappingsKey _key;
        private final Long _mappingsKey;
        private final Integer _mappingsValue;
        private Map<Class<? extends Augmentation<Mappings>>, Augmentation<Mappings>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<Mappings> getImplementedInterface() {
            return Mappings.class;
        }

        private MappingsImpl(MappingsBuilder base) {
            if (base.getKey() == null) {
                this._key = new MappingsKey(base.getMappingsKey());
                this._mappingsKey = base.getMappingsKey();
            } else {
                this._key = base.getKey();
                this._mappingsKey = this._key.getMappingsKey();
            }
            this._mappingsValue = base.getMappingsValue();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<Mappings>>, Augmentation<Mappings>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<Mappings>>, Augmentation<Mappings>>(base.augmentation);
                }
            }
        }

        @Override
        public MappingsKey getKey() {
            return this._key;
        }

        @Override
        public Long getMappingsKey() {
            return this._mappingsKey;
        }

        @Override
        public Integer getMappingsValue() {
            return this._mappingsValue;
        }

        public <E extends Augmentation<Mappings>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._key);
            result = 31 * result + Objects.hashCode(this._mappingsKey);
            result = 31 * result + Objects.hashCode(this._mappingsValue);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Mappings.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Mappings other = (Mappings)obj;
            if (!Objects.equals(this._key, other.getKey())) {
                return false;
            }
            if (!Objects.equals(this._mappingsKey, other.getMappingsKey())) {
                return false;
            }
            if (!Objects.equals(this._mappingsValue, other.getMappingsValue())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                MappingsImpl otherImpl = (MappingsImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Mappings>>, Augmentation<Mappings>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "Mappings [";
            StringBuilder builder = new StringBuilder(name);
            if (this._key != null) {
                builder.append("_key=");
                builder.append(this._key);
                builder.append(", ");
            }
            if (this._mappingsKey != null) {
                builder.append("_mappingsKey=");
                builder.append(this._mappingsKey);
                builder.append(", ");
            }
            if (this._mappingsValue != null) {
                builder.append("_mappingsValue=");
                builder.append(this._mappingsValue);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

