/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ovsdb.rev150105.ovsdb.node.attributes;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Uri;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.Uuid;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ovsdb.rev150105.ovsdb.node.attributes.Queues;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ovsdb.rev150105.ovsdb.node.attributes.QueuesKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ovsdb.rev150105.ovsdb.node.attributes.queues.QueuesExternalIds;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ovsdb.rev150105.ovsdb.node.attributes.queues.QueuesOtherConfig;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class QueuesBuilder
implements Builder<Queues> {
    private Short _dscp;
    private QueuesKey _key;
    private Uri _queueId;
    private Uuid _queueUuid;
    private List<QueuesExternalIds> _queuesExternalIds;
    private List<QueuesOtherConfig> _queuesOtherConfig;
    Map<Class<? extends Augmentation<Queues>>, Augmentation<Queues>> augmentation = Collections.emptyMap();

    public QueuesBuilder() {
    }

    public QueuesBuilder(Queues base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new QueuesKey(base.getQueueId());
            this._queueId = base.getQueueId();
        } else {
            this._key = base.getKey();
            this._queueId = this._key.getQueueId();
        }
        this._dscp = base.getDscp();
        this._queueUuid = base.getQueueUuid();
        this._queuesExternalIds = base.getQueuesExternalIds();
        this._queuesOtherConfig = base.getQueuesOtherConfig();
        if (base instanceof QueuesImpl) {
            QueuesImpl impl = (QueuesImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Queues>>, Augmentation<Queues>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Queues>>, Augmentation<Queues>>(casted.augmentations());
        }
    }

    public Short getDscp() {
        return this._dscp;
    }

    public QueuesKey getKey() {
        return this._key;
    }

    public Uri getQueueId() {
        return this._queueId;
    }

    public Uuid getQueueUuid() {
        return this._queueUuid;
    }

    public List<QueuesExternalIds> getQueuesExternalIds() {
        return this._queuesExternalIds;
    }

    public List<QueuesOtherConfig> getQueuesOtherConfig() {
        return this._queuesOtherConfig;
    }

    public <E extends Augmentation<Queues>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    private static void checkDscpRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..255]].", value));
    }

    public QueuesBuilder setDscp(Short value) {
        if (value != null) {
            QueuesBuilder.checkDscpRange(value);
        }
        this._dscp = value;
        return this;
    }

    public QueuesBuilder setKey(QueuesKey value) {
        this._key = value;
        return this;
    }

    public QueuesBuilder setQueueId(Uri value) {
        this._queueId = value;
        return this;
    }

    public QueuesBuilder setQueueUuid(Uuid value) {
        this._queueUuid = value;
        return this;
    }

    public QueuesBuilder setQueuesExternalIds(List<QueuesExternalIds> value) {
        this._queuesExternalIds = value;
        return this;
    }

    public QueuesBuilder setQueuesOtherConfig(List<QueuesOtherConfig> value) {
        this._queuesOtherConfig = value;
        return this;
    }

    public QueuesBuilder addAugmentation(Class<? extends Augmentation<Queues>> augmentationType, Augmentation<Queues> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Queues>>, Augmentation<Queues>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public QueuesBuilder removeAugmentation(Class<? extends Augmentation<Queues>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Queues build() {
        return new QueuesImpl(this);
    }

    private static final class QueuesImpl
    implements Queues {
        private final Short _dscp;
        private final QueuesKey _key;
        private final Uri _queueId;
        private final Uuid _queueUuid;
        private final List<QueuesExternalIds> _queuesExternalIds;
        private final List<QueuesOtherConfig> _queuesOtherConfig;
        private Map<Class<? extends Augmentation<Queues>>, Augmentation<Queues>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<Queues> getImplementedInterface() {
            return Queues.class;
        }

        private QueuesImpl(QueuesBuilder base) {
            if (base.getKey() == null) {
                this._key = new QueuesKey(base.getQueueId());
                this._queueId = base.getQueueId();
            } else {
                this._key = base.getKey();
                this._queueId = this._key.getQueueId();
            }
            this._dscp = base.getDscp();
            this._queueUuid = base.getQueueUuid();
            this._queuesExternalIds = base.getQueuesExternalIds();
            this._queuesOtherConfig = base.getQueuesOtherConfig();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<Queues>>, Augmentation<Queues>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<Queues>>, Augmentation<Queues>>(base.augmentation);
                }
            }
        }

        @Override
        public Short getDscp() {
            return this._dscp;
        }

        @Override
        public QueuesKey getKey() {
            return this._key;
        }

        @Override
        public Uri getQueueId() {
            return this._queueId;
        }

        @Override
        public Uuid getQueueUuid() {
            return this._queueUuid;
        }

        @Override
        public List<QueuesExternalIds> getQueuesExternalIds() {
            return this._queuesExternalIds;
        }

        @Override
        public List<QueuesOtherConfig> getQueuesOtherConfig() {
            return this._queuesOtherConfig;
        }

        public <E extends Augmentation<Queues>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._dscp);
            result = 31 * result + Objects.hashCode(this._key);
            result = 31 * result + Objects.hashCode(this._queueId);
            result = 31 * result + Objects.hashCode(this._queueUuid);
            result = 31 * result + Objects.hashCode(this._queuesExternalIds);
            result = 31 * result + Objects.hashCode(this._queuesOtherConfig);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Queues.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Queues other = (Queues)obj;
            if (!Objects.equals(this._dscp, other.getDscp())) {
                return false;
            }
            if (!Objects.equals(this._key, other.getKey())) {
                return false;
            }
            if (!Objects.equals(this._queueId, other.getQueueId())) {
                return false;
            }
            if (!Objects.equals(this._queueUuid, other.getQueueUuid())) {
                return false;
            }
            if (!Objects.equals(this._queuesExternalIds, other.getQueuesExternalIds())) {
                return false;
            }
            if (!Objects.equals(this._queuesOtherConfig, other.getQueuesOtherConfig())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                QueuesImpl otherImpl = (QueuesImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Queues>>, Augmentation<Queues>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "Queues [";
            StringBuilder builder = new StringBuilder(name);
            if (this._dscp != null) {
                builder.append("_dscp=");
                builder.append(this._dscp);
                builder.append(", ");
            }
            if (this._key != null) {
                builder.append("_key=");
                builder.append(this._key);
                builder.append(", ");
            }
            if (this._queueId != null) {
                builder.append("_queueId=");
                builder.append(this._queueId);
                builder.append(", ");
            }
            if (this._queueUuid != null) {
                builder.append("_queueUuid=");
                builder.append(this._queueUuid);
                builder.append(", ");
            }
            if (this._queuesExternalIds != null) {
                builder.append("_queuesExternalIds=");
                builder.append(this._queuesExternalIds);
                builder.append(", ");
            }
            if (this._queuesOtherConfig != null) {
                builder.append("_queuesOtherConfig=");
                builder.append(this._queuesOtherConfig);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

