/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ovsdb.rev150105.ovsdb.node.attributes;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Uri;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.Uuid;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ovsdb.rev150105.QosTypeBase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ovsdb.rev150105.ovsdb.node.attributes.QosEntries;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ovsdb.rev150105.ovsdb.node.attributes.QosEntriesKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ovsdb.rev150105.ovsdb.node.attributes.qos.entries.QosExternalIds;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ovsdb.rev150105.ovsdb.node.attributes.qos.entries.QosOtherConfig;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ovsdb.rev150105.ovsdb.node.attributes.qos.entries.QueueList;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class QosEntriesBuilder
implements Builder<QosEntries> {
    private QosEntriesKey _key;
    private List<QosExternalIds> _qosExternalIds;
    private Uri _qosId;
    private List<QosOtherConfig> _qosOtherConfig;
    private Class<? extends QosTypeBase> _qosType;
    private Uuid _qosUuid;
    private List<QueueList> _queueList;
    Map<Class<? extends Augmentation<QosEntries>>, Augmentation<QosEntries>> augmentation = Collections.emptyMap();

    public QosEntriesBuilder() {
    }

    public QosEntriesBuilder(QosEntries base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new QosEntriesKey(base.getQosId());
            this._qosId = base.getQosId();
        } else {
            this._key = base.getKey();
            this._qosId = this._key.getQosId();
        }
        this._qosExternalIds = base.getQosExternalIds();
        this._qosOtherConfig = base.getQosOtherConfig();
        this._qosType = base.getQosType();
        this._qosUuid = base.getQosUuid();
        this._queueList = base.getQueueList();
        if (base instanceof QosEntriesImpl) {
            QosEntriesImpl impl = (QosEntriesImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<QosEntries>>, Augmentation<QosEntries>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<QosEntries>>, Augmentation<QosEntries>>(casted.augmentations());
        }
    }

    public QosEntriesKey getKey() {
        return this._key;
    }

    public List<QosExternalIds> getQosExternalIds() {
        return this._qosExternalIds;
    }

    public Uri getQosId() {
        return this._qosId;
    }

    public List<QosOtherConfig> getQosOtherConfig() {
        return this._qosOtherConfig;
    }

    public Class<? extends QosTypeBase> getQosType() {
        return this._qosType;
    }

    public Uuid getQosUuid() {
        return this._qosUuid;
    }

    public List<QueueList> getQueueList() {
        return this._queueList;
    }

    public <E extends Augmentation<QosEntries>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public QosEntriesBuilder setKey(QosEntriesKey value) {
        this._key = value;
        return this;
    }

    public QosEntriesBuilder setQosExternalIds(List<QosExternalIds> value) {
        this._qosExternalIds = value;
        return this;
    }

    public QosEntriesBuilder setQosId(Uri value) {
        this._qosId = value;
        return this;
    }

    public QosEntriesBuilder setQosOtherConfig(List<QosOtherConfig> value) {
        this._qosOtherConfig = value;
        return this;
    }

    public QosEntriesBuilder setQosType(Class<? extends QosTypeBase> value) {
        this._qosType = value;
        return this;
    }

    public QosEntriesBuilder setQosUuid(Uuid value) {
        this._qosUuid = value;
        return this;
    }

    public QosEntriesBuilder setQueueList(List<QueueList> value) {
        this._queueList = value;
        return this;
    }

    public QosEntriesBuilder addAugmentation(Class<? extends Augmentation<QosEntries>> augmentationType, Augmentation<QosEntries> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<QosEntries>>, Augmentation<QosEntries>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public QosEntriesBuilder removeAugmentation(Class<? extends Augmentation<QosEntries>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public QosEntries build() {
        return new QosEntriesImpl(this);
    }

    private static final class QosEntriesImpl
    implements QosEntries {
        private final QosEntriesKey _key;
        private final List<QosExternalIds> _qosExternalIds;
        private final Uri _qosId;
        private final List<QosOtherConfig> _qosOtherConfig;
        private final Class<? extends QosTypeBase> _qosType;
        private final Uuid _qosUuid;
        private final List<QueueList> _queueList;
        private Map<Class<? extends Augmentation<QosEntries>>, Augmentation<QosEntries>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<QosEntries> getImplementedInterface() {
            return QosEntries.class;
        }

        private QosEntriesImpl(QosEntriesBuilder base) {
            if (base.getKey() == null) {
                this._key = new QosEntriesKey(base.getQosId());
                this._qosId = base.getQosId();
            } else {
                this._key = base.getKey();
                this._qosId = this._key.getQosId();
            }
            this._qosExternalIds = base.getQosExternalIds();
            this._qosOtherConfig = base.getQosOtherConfig();
            this._qosType = base.getQosType();
            this._qosUuid = base.getQosUuid();
            this._queueList = base.getQueueList();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<QosEntries>>, Augmentation<QosEntries>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<QosEntries>>, Augmentation<QosEntries>>(base.augmentation);
                }
            }
        }

        @Override
        public QosEntriesKey getKey() {
            return this._key;
        }

        @Override
        public List<QosExternalIds> getQosExternalIds() {
            return this._qosExternalIds;
        }

        @Override
        public Uri getQosId() {
            return this._qosId;
        }

        @Override
        public List<QosOtherConfig> getQosOtherConfig() {
            return this._qosOtherConfig;
        }

        @Override
        public Class<? extends QosTypeBase> getQosType() {
            return this._qosType;
        }

        @Override
        public Uuid getQosUuid() {
            return this._qosUuid;
        }

        @Override
        public List<QueueList> getQueueList() {
            return this._queueList;
        }

        public <E extends Augmentation<QosEntries>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._key);
            result = 31 * result + Objects.hashCode(this._qosExternalIds);
            result = 31 * result + Objects.hashCode(this._qosId);
            result = 31 * result + Objects.hashCode(this._qosOtherConfig);
            result = 31 * result + Objects.hashCode(this._qosType);
            result = 31 * result + Objects.hashCode(this._qosUuid);
            result = 31 * result + Objects.hashCode(this._queueList);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!QosEntries.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            QosEntries other = (QosEntries)obj;
            if (!Objects.equals(this._key, other.getKey())) {
                return false;
            }
            if (!Objects.equals(this._qosExternalIds, other.getQosExternalIds())) {
                return false;
            }
            if (!Objects.equals(this._qosId, other.getQosId())) {
                return false;
            }
            if (!Objects.equals(this._qosOtherConfig, other.getQosOtherConfig())) {
                return false;
            }
            if (!Objects.equals(this._qosType, other.getQosType())) {
                return false;
            }
            if (!Objects.equals(this._qosUuid, other.getQosUuid())) {
                return false;
            }
            if (!Objects.equals(this._queueList, other.getQueueList())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                QosEntriesImpl otherImpl = (QosEntriesImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<QosEntries>>, Augmentation<QosEntries>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "QosEntries [";
            StringBuilder builder = new StringBuilder(name);
            if (this._key != null) {
                builder.append("_key=");
                builder.append(this._key);
                builder.append(", ");
            }
            if (this._qosExternalIds != null) {
                builder.append("_qosExternalIds=");
                builder.append(this._qosExternalIds);
                builder.append(", ");
            }
            if (this._qosId != null) {
                builder.append("_qosId=");
                builder.append(this._qosId);
                builder.append(", ");
            }
            if (this._qosOtherConfig != null) {
                builder.append("_qosOtherConfig=");
                builder.append(this._qosOtherConfig);
                builder.append(", ");
            }
            if (this._qosType != null) {
                builder.append("_qosType=");
                builder.append(this._qosType);
                builder.append(", ");
            }
            if (this._qosUuid != null) {
                builder.append("_qosUuid=");
                builder.append(this._qosUuid);
                builder.append(", ");
            }
            if (this._queueList != null) {
                builder.append("_queueList=");
                builder.append(this._queueList);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

