/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ovsdb.rev150105.ovsdb.node.attributes;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Uri;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ovsdb.rev150105.ovsdb.node.attributes.ManagerEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ovsdb.rev150105.ovsdb.node.attributes.ManagerEntryKey;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class ManagerEntryBuilder
implements Builder<ManagerEntry> {
    private ManagerEntryKey _key;
    private Long _numberOfConnections;
    private Uri _target;
    private Boolean _connected;
    Map<Class<? extends Augmentation<ManagerEntry>>, Augmentation<ManagerEntry>> augmentation = Collections.emptyMap();

    public ManagerEntryBuilder() {
    }

    public ManagerEntryBuilder(ManagerEntry base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new ManagerEntryKey(base.getTarget());
            this._target = base.getTarget();
        } else {
            this._key = base.getKey();
            this._target = this._key.getTarget();
        }
        this._numberOfConnections = base.getNumberOfConnections();
        this._connected = base.isConnected();
        if (base instanceof ManagerEntryImpl) {
            ManagerEntryImpl impl = (ManagerEntryImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<ManagerEntry>>, Augmentation<ManagerEntry>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ManagerEntry>>, Augmentation<ManagerEntry>>(casted.augmentations());
        }
    }

    public ManagerEntryKey getKey() {
        return this._key;
    }

    public Long getNumberOfConnections() {
        return this._numberOfConnections;
    }

    public Uri getTarget() {
        return this._target;
    }

    public Boolean isConnected() {
        return this._connected;
    }

    public <E extends Augmentation<ManagerEntry>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public ManagerEntryBuilder setKey(ManagerEntryKey value) {
        this._key = value;
        return this;
    }

    private static void checkNumberOfConnectionsRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..4294967295]].", value));
    }

    public ManagerEntryBuilder setNumberOfConnections(Long value) {
        if (value != null) {
            ManagerEntryBuilder.checkNumberOfConnectionsRange(value);
        }
        this._numberOfConnections = value;
        return this;
    }

    public ManagerEntryBuilder setTarget(Uri value) {
        this._target = value;
        return this;
    }

    public ManagerEntryBuilder setConnected(Boolean value) {
        this._connected = value;
        return this;
    }

    public ManagerEntryBuilder addAugmentation(Class<? extends Augmentation<ManagerEntry>> augmentationType, Augmentation<ManagerEntry> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ManagerEntry>>, Augmentation<ManagerEntry>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public ManagerEntryBuilder removeAugmentation(Class<? extends Augmentation<ManagerEntry>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public ManagerEntry build() {
        return new ManagerEntryImpl(this);
    }

    private static final class ManagerEntryImpl
    implements ManagerEntry {
        private final ManagerEntryKey _key;
        private final Long _numberOfConnections;
        private final Uri _target;
        private final Boolean _connected;
        private Map<Class<? extends Augmentation<ManagerEntry>>, Augmentation<ManagerEntry>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<ManagerEntry> getImplementedInterface() {
            return ManagerEntry.class;
        }

        private ManagerEntryImpl(ManagerEntryBuilder base) {
            if (base.getKey() == null) {
                this._key = new ManagerEntryKey(base.getTarget());
                this._target = base.getTarget();
            } else {
                this._key = base.getKey();
                this._target = this._key.getTarget();
            }
            this._numberOfConnections = base.getNumberOfConnections();
            this._connected = base.isConnected();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<ManagerEntry>>, Augmentation<ManagerEntry>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<ManagerEntry>>, Augmentation<ManagerEntry>>(base.augmentation);
                }
            }
        }

        @Override
        public ManagerEntryKey getKey() {
            return this._key;
        }

        @Override
        public Long getNumberOfConnections() {
            return this._numberOfConnections;
        }

        @Override
        public Uri getTarget() {
            return this._target;
        }

        @Override
        public Boolean isConnected() {
            return this._connected;
        }

        public <E extends Augmentation<ManagerEntry>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._key);
            result = 31 * result + Objects.hashCode(this._numberOfConnections);
            result = 31 * result + Objects.hashCode(this._target);
            result = 31 * result + Objects.hashCode(this._connected);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!ManagerEntry.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            ManagerEntry other = (ManagerEntry)obj;
            if (!Objects.equals(this._key, other.getKey())) {
                return false;
            }
            if (!Objects.equals(this._numberOfConnections, other.getNumberOfConnections())) {
                return false;
            }
            if (!Objects.equals(this._target, other.getTarget())) {
                return false;
            }
            if (!Objects.equals(this._connected, other.isConnected())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                ManagerEntryImpl otherImpl = (ManagerEntryImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<ManagerEntry>>, Augmentation<ManagerEntry>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "ManagerEntry [";
            StringBuilder builder = new StringBuilder(name);
            if (this._key != null) {
                builder.append("_key=");
                builder.append(this._key);
                builder.append(", ");
            }
            if (this._numberOfConnections != null) {
                builder.append("_numberOfConnections=");
                builder.append(this._numberOfConnections);
                builder.append(", ");
            }
            if (this._target != null) {
                builder.append("_target=");
                builder.append(this._target);
                builder.append(", ");
            }
            if (this._connected != null) {
                builder.append("_connected=");
                builder.append(this._connected);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

