/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ovsdb.rev150105.ovsdb.node.attributes;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ovsdb.rev150105.OvsdbBridgeRef;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ovsdb.rev150105.ovsdb.node.attributes.ManagedNodeEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ovsdb.rev150105.ovsdb.node.attributes.ManagedNodeEntryKey;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class ManagedNodeEntryBuilder
implements Builder<ManagedNodeEntry> {
    private OvsdbBridgeRef _bridgeRef;
    private ManagedNodeEntryKey _key;
    Map<Class<? extends Augmentation<ManagedNodeEntry>>, Augmentation<ManagedNodeEntry>> augmentation = Collections.emptyMap();

    public ManagedNodeEntryBuilder() {
    }

    public ManagedNodeEntryBuilder(ManagedNodeEntry base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new ManagedNodeEntryKey(base.getBridgeRef());
            this._bridgeRef = base.getBridgeRef();
        } else {
            this._key = base.getKey();
            this._bridgeRef = this._key.getBridgeRef();
        }
        if (base instanceof ManagedNodeEntryImpl) {
            ManagedNodeEntryImpl impl = (ManagedNodeEntryImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<ManagedNodeEntry>>, Augmentation<ManagedNodeEntry>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ManagedNodeEntry>>, Augmentation<ManagedNodeEntry>>(casted.augmentations());
        }
    }

    public OvsdbBridgeRef getBridgeRef() {
        return this._bridgeRef;
    }

    public ManagedNodeEntryKey getKey() {
        return this._key;
    }

    public <E extends Augmentation<ManagedNodeEntry>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public ManagedNodeEntryBuilder setBridgeRef(OvsdbBridgeRef value) {
        this._bridgeRef = value;
        return this;
    }

    public ManagedNodeEntryBuilder setKey(ManagedNodeEntryKey value) {
        this._key = value;
        return this;
    }

    public ManagedNodeEntryBuilder addAugmentation(Class<? extends Augmentation<ManagedNodeEntry>> augmentationType, Augmentation<ManagedNodeEntry> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ManagedNodeEntry>>, Augmentation<ManagedNodeEntry>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public ManagedNodeEntryBuilder removeAugmentation(Class<? extends Augmentation<ManagedNodeEntry>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public ManagedNodeEntry build() {
        return new ManagedNodeEntryImpl(this);
    }

    private static final class ManagedNodeEntryImpl
    implements ManagedNodeEntry {
        private final OvsdbBridgeRef _bridgeRef;
        private final ManagedNodeEntryKey _key;
        private Map<Class<? extends Augmentation<ManagedNodeEntry>>, Augmentation<ManagedNodeEntry>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<ManagedNodeEntry> getImplementedInterface() {
            return ManagedNodeEntry.class;
        }

        private ManagedNodeEntryImpl(ManagedNodeEntryBuilder base) {
            if (base.getKey() == null) {
                this._key = new ManagedNodeEntryKey(base.getBridgeRef());
                this._bridgeRef = base.getBridgeRef();
            } else {
                this._key = base.getKey();
                this._bridgeRef = this._key.getBridgeRef();
            }
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<ManagedNodeEntry>>, Augmentation<ManagedNodeEntry>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<ManagedNodeEntry>>, Augmentation<ManagedNodeEntry>>(base.augmentation);
                }
            }
        }

        @Override
        public OvsdbBridgeRef getBridgeRef() {
            return this._bridgeRef;
        }

        @Override
        public ManagedNodeEntryKey getKey() {
            return this._key;
        }

        public <E extends Augmentation<ManagedNodeEntry>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._bridgeRef);
            result = 31 * result + Objects.hashCode(this._key);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!ManagedNodeEntry.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            ManagedNodeEntry other = (ManagedNodeEntry)obj;
            if (!Objects.equals(this._bridgeRef, other.getBridgeRef())) {
                return false;
            }
            if (!Objects.equals(this._key, other.getKey())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                ManagedNodeEntryImpl otherImpl = (ManagedNodeEntryImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<ManagedNodeEntry>>, Augmentation<ManagedNodeEntry>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "ManagedNodeEntry [";
            StringBuilder builder = new StringBuilder(name);
            if (this._bridgeRef != null) {
                builder.append("_bridgeRef=");
                builder.append(this._bridgeRef);
                builder.append(", ");
            }
            if (this._key != null) {
                builder.append("_key=");
                builder.append(this._key);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

