/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ovsdb.rev150105.ovsdb.node.attributes;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ovsdb.rev150105.InterfaceTypeBase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ovsdb.rev150105.ovsdb.node.attributes.InterfaceTypeEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ovsdb.rev150105.ovsdb.node.attributes.InterfaceTypeEntryKey;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class InterfaceTypeEntryBuilder
implements Builder<InterfaceTypeEntry> {
    private Class<? extends InterfaceTypeBase> _interfaceType;
    private InterfaceTypeEntryKey _key;
    Map<Class<? extends Augmentation<InterfaceTypeEntry>>, Augmentation<InterfaceTypeEntry>> augmentation = Collections.emptyMap();

    public InterfaceTypeEntryBuilder() {
    }

    public InterfaceTypeEntryBuilder(InterfaceTypeEntry base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new InterfaceTypeEntryKey(base.getInterfaceType());
            this._interfaceType = base.getInterfaceType();
        } else {
            this._key = base.getKey();
            this._interfaceType = this._key.getInterfaceType();
        }
        if (base instanceof InterfaceTypeEntryImpl) {
            InterfaceTypeEntryImpl impl = (InterfaceTypeEntryImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<InterfaceTypeEntry>>, Augmentation<InterfaceTypeEntry>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<InterfaceTypeEntry>>, Augmentation<InterfaceTypeEntry>>(casted.augmentations());
        }
    }

    public Class<? extends InterfaceTypeBase> getInterfaceType() {
        return this._interfaceType;
    }

    public InterfaceTypeEntryKey getKey() {
        return this._key;
    }

    public <E extends Augmentation<InterfaceTypeEntry>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public InterfaceTypeEntryBuilder setInterfaceType(Class<? extends InterfaceTypeBase> value) {
        this._interfaceType = value;
        return this;
    }

    public InterfaceTypeEntryBuilder setKey(InterfaceTypeEntryKey value) {
        this._key = value;
        return this;
    }

    public InterfaceTypeEntryBuilder addAugmentation(Class<? extends Augmentation<InterfaceTypeEntry>> augmentationType, Augmentation<InterfaceTypeEntry> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<InterfaceTypeEntry>>, Augmentation<InterfaceTypeEntry>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public InterfaceTypeEntryBuilder removeAugmentation(Class<? extends Augmentation<InterfaceTypeEntry>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public InterfaceTypeEntry build() {
        return new InterfaceTypeEntryImpl(this);
    }

    private static final class InterfaceTypeEntryImpl
    implements InterfaceTypeEntry {
        private final Class<? extends InterfaceTypeBase> _interfaceType;
        private final InterfaceTypeEntryKey _key;
        private Map<Class<? extends Augmentation<InterfaceTypeEntry>>, Augmentation<InterfaceTypeEntry>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<InterfaceTypeEntry> getImplementedInterface() {
            return InterfaceTypeEntry.class;
        }

        private InterfaceTypeEntryImpl(InterfaceTypeEntryBuilder base) {
            if (base.getKey() == null) {
                this._key = new InterfaceTypeEntryKey(base.getInterfaceType());
                this._interfaceType = base.getInterfaceType();
            } else {
                this._key = base.getKey();
                this._interfaceType = this._key.getInterfaceType();
            }
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<InterfaceTypeEntry>>, Augmentation<InterfaceTypeEntry>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<InterfaceTypeEntry>>, Augmentation<InterfaceTypeEntry>>(base.augmentation);
                }
            }
        }

        @Override
        public Class<? extends InterfaceTypeBase> getInterfaceType() {
            return this._interfaceType;
        }

        @Override
        public InterfaceTypeEntryKey getKey() {
            return this._key;
        }

        public <E extends Augmentation<InterfaceTypeEntry>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._interfaceType);
            result = 31 * result + Objects.hashCode(this._key);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!InterfaceTypeEntry.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            InterfaceTypeEntry other = (InterfaceTypeEntry)obj;
            if (!Objects.equals(this._interfaceType, other.getInterfaceType())) {
                return false;
            }
            if (!Objects.equals(this._key, other.getKey())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                InterfaceTypeEntryImpl otherImpl = (InterfaceTypeEntryImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<InterfaceTypeEntry>>, Augmentation<InterfaceTypeEntry>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "InterfaceTypeEntry [";
            StringBuilder builder = new StringBuilder(name);
            if (this._interfaceType != null) {
                builder.append("_interfaceType=");
                builder.append(this._interfaceType);
                builder.append(", ");
            }
            if (this._key != null) {
                builder.append("_key=");
                builder.append(this._key);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

