/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ovsdb.rev150105.ovsdb.node.attributes;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddress;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.PortNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ovsdb.rev150105.OvsdbConnectionInfoAttributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ovsdb.rev150105.ovsdb.node.attributes.ConnectionInfo;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class ConnectionInfoBuilder
implements Builder<ConnectionInfo> {
    private IpAddress _localIp;
    private PortNumber _localPort;
    private IpAddress _remoteIp;
    private PortNumber _remotePort;
    Map<Class<? extends Augmentation<ConnectionInfo>>, Augmentation<ConnectionInfo>> augmentation = Collections.emptyMap();

    public ConnectionInfoBuilder() {
    }

    public ConnectionInfoBuilder(OvsdbConnectionInfoAttributes arg) {
        this._remoteIp = arg.getRemoteIp();
        this._remotePort = arg.getRemotePort();
        this._localIp = arg.getLocalIp();
        this._localPort = arg.getLocalPort();
    }

    public ConnectionInfoBuilder(ConnectionInfo base) {
        AugmentationHolder casted;
        this._localIp = base.getLocalIp();
        this._localPort = base.getLocalPort();
        this._remoteIp = base.getRemoteIp();
        this._remotePort = base.getRemotePort();
        if (base instanceof ConnectionInfoImpl) {
            ConnectionInfoImpl impl = (ConnectionInfoImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<ConnectionInfo>>, Augmentation<ConnectionInfo>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ConnectionInfo>>, Augmentation<ConnectionInfo>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof OvsdbConnectionInfoAttributes) {
            this._remoteIp = ((OvsdbConnectionInfoAttributes)arg).getRemoteIp();
            this._remotePort = ((OvsdbConnectionInfoAttributes)arg).getRemotePort();
            this._localIp = ((OvsdbConnectionInfoAttributes)arg).getLocalIp();
            this._localPort = ((OvsdbConnectionInfoAttributes)arg).getLocalPort();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ovsdb.rev150105.OvsdbConnectionInfoAttributes] \nbut was: " + arg);
        }
    }

    public IpAddress getLocalIp() {
        return this._localIp;
    }

    public PortNumber getLocalPort() {
        return this._localPort;
    }

    public IpAddress getRemoteIp() {
        return this._remoteIp;
    }

    public PortNumber getRemotePort() {
        return this._remotePort;
    }

    public <E extends Augmentation<ConnectionInfo>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public ConnectionInfoBuilder setLocalIp(IpAddress value) {
        this._localIp = value;
        return this;
    }

    public ConnectionInfoBuilder setLocalPort(PortNumber value) {
        this._localPort = value;
        return this;
    }

    public ConnectionInfoBuilder setRemoteIp(IpAddress value) {
        this._remoteIp = value;
        return this;
    }

    public ConnectionInfoBuilder setRemotePort(PortNumber value) {
        this._remotePort = value;
        return this;
    }

    public ConnectionInfoBuilder addAugmentation(Class<? extends Augmentation<ConnectionInfo>> augmentationType, Augmentation<ConnectionInfo> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ConnectionInfo>>, Augmentation<ConnectionInfo>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public ConnectionInfoBuilder removeAugmentation(Class<? extends Augmentation<ConnectionInfo>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public ConnectionInfo build() {
        return new ConnectionInfoImpl(this);
    }

    private static final class ConnectionInfoImpl
    implements ConnectionInfo {
        private final IpAddress _localIp;
        private final PortNumber _localPort;
        private final IpAddress _remoteIp;
        private final PortNumber _remotePort;
        private Map<Class<? extends Augmentation<ConnectionInfo>>, Augmentation<ConnectionInfo>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<ConnectionInfo> getImplementedInterface() {
            return ConnectionInfo.class;
        }

        private ConnectionInfoImpl(ConnectionInfoBuilder base) {
            this._localIp = base.getLocalIp();
            this._localPort = base.getLocalPort();
            this._remoteIp = base.getRemoteIp();
            this._remotePort = base.getRemotePort();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<ConnectionInfo>>, Augmentation<ConnectionInfo>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<ConnectionInfo>>, Augmentation<ConnectionInfo>>(base.augmentation);
                }
            }
        }

        @Override
        public IpAddress getLocalIp() {
            return this._localIp;
        }

        @Override
        public PortNumber getLocalPort() {
            return this._localPort;
        }

        @Override
        public IpAddress getRemoteIp() {
            return this._remoteIp;
        }

        @Override
        public PortNumber getRemotePort() {
            return this._remotePort;
        }

        public <E extends Augmentation<ConnectionInfo>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._localIp);
            result = 31 * result + Objects.hashCode(this._localPort);
            result = 31 * result + Objects.hashCode(this._remoteIp);
            result = 31 * result + Objects.hashCode(this._remotePort);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!ConnectionInfo.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            ConnectionInfo other = (ConnectionInfo)obj;
            if (!Objects.equals(this._localIp, other.getLocalIp())) {
                return false;
            }
            if (!Objects.equals(this._localPort, other.getLocalPort())) {
                return false;
            }
            if (!Objects.equals(this._remoteIp, other.getRemoteIp())) {
                return false;
            }
            if (!Objects.equals(this._remotePort, other.getRemotePort())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                ConnectionInfoImpl otherImpl = (ConnectionInfoImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<ConnectionInfo>>, Augmentation<ConnectionInfo>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "ConnectionInfo [";
            StringBuilder builder = new StringBuilder(name);
            if (this._localIp != null) {
                builder.append("_localIp=");
                builder.append(this._localIp);
                builder.append(", ");
            }
            if (this._localPort != null) {
                builder.append("_localPort=");
                builder.append(this._localPort);
                builder.append(", ");
            }
            if (this._remoteIp != null) {
                builder.append("_remoteIp=");
                builder.append(this._remoteIp);
                builder.append(", ");
            }
            if (this._remotePort != null) {
                builder.append("_remotePort=");
                builder.append(this._remotePort);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

