/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ovsdb.rev150105.ovsdb.node.attributes;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Uri;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.Uuid;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ovsdb.rev150105.ovsdb.node.attributes.Autoattach;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ovsdb.rev150105.ovsdb.node.attributes.AutoattachKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ovsdb.rev150105.ovsdb.node.attributes.autoattach.AutoattachExternalIds;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ovsdb.rev150105.ovsdb.node.attributes.autoattach.Mappings;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class AutoattachBuilder
implements Builder<Autoattach> {
    private List<AutoattachExternalIds> _autoattachExternalIds;
    private Uri _autoattachId;
    private Uuid _autoattachUuid;
    private Uri _bridgeId;
    private AutoattachKey _key;
    private List<Mappings> _mappings;
    private String _systemDescription;
    private String _systemName;
    Map<Class<? extends Augmentation<Autoattach>>, Augmentation<Autoattach>> augmentation = Collections.emptyMap();

    public AutoattachBuilder() {
    }

    public AutoattachBuilder(Autoattach base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new AutoattachKey(base.getAutoattachId());
            this._autoattachId = base.getAutoattachId();
        } else {
            this._key = base.getKey();
            this._autoattachId = this._key.getAutoattachId();
        }
        this._autoattachExternalIds = base.getAutoattachExternalIds();
        this._autoattachUuid = base.getAutoattachUuid();
        this._bridgeId = base.getBridgeId();
        this._mappings = base.getMappings();
        this._systemDescription = base.getSystemDescription();
        this._systemName = base.getSystemName();
        if (base instanceof AutoattachImpl) {
            AutoattachImpl impl = (AutoattachImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Autoattach>>, Augmentation<Autoattach>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Autoattach>>, Augmentation<Autoattach>>(casted.augmentations());
        }
    }

    public List<AutoattachExternalIds> getAutoattachExternalIds() {
        return this._autoattachExternalIds;
    }

    public Uri getAutoattachId() {
        return this._autoattachId;
    }

    public Uuid getAutoattachUuid() {
        return this._autoattachUuid;
    }

    public Uri getBridgeId() {
        return this._bridgeId;
    }

    public AutoattachKey getKey() {
        return this._key;
    }

    public List<Mappings> getMappings() {
        return this._mappings;
    }

    public String getSystemDescription() {
        return this._systemDescription;
    }

    public String getSystemName() {
        return this._systemName;
    }

    public <E extends Augmentation<Autoattach>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public AutoattachBuilder setAutoattachExternalIds(List<AutoattachExternalIds> value) {
        this._autoattachExternalIds = value;
        return this;
    }

    public AutoattachBuilder setAutoattachId(Uri value) {
        this._autoattachId = value;
        return this;
    }

    public AutoattachBuilder setAutoattachUuid(Uuid value) {
        this._autoattachUuid = value;
        return this;
    }

    public AutoattachBuilder setBridgeId(Uri value) {
        this._bridgeId = value;
        return this;
    }

    public AutoattachBuilder setKey(AutoattachKey value) {
        this._key = value;
        return this;
    }

    public AutoattachBuilder setMappings(List<Mappings> value) {
        this._mappings = value;
        return this;
    }

    public AutoattachBuilder setSystemDescription(String value) {
        this._systemDescription = value;
        return this;
    }

    public AutoattachBuilder setSystemName(String value) {
        this._systemName = value;
        return this;
    }

    public AutoattachBuilder addAugmentation(Class<? extends Augmentation<Autoattach>> augmentationType, Augmentation<Autoattach> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Autoattach>>, Augmentation<Autoattach>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public AutoattachBuilder removeAugmentation(Class<? extends Augmentation<Autoattach>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Autoattach build() {
        return new AutoattachImpl(this);
    }

    private static final class AutoattachImpl
    implements Autoattach {
        private final List<AutoattachExternalIds> _autoattachExternalIds;
        private final Uri _autoattachId;
        private final Uuid _autoattachUuid;
        private final Uri _bridgeId;
        private final AutoattachKey _key;
        private final List<Mappings> _mappings;
        private final String _systemDescription;
        private final String _systemName;
        private Map<Class<? extends Augmentation<Autoattach>>, Augmentation<Autoattach>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<Autoattach> getImplementedInterface() {
            return Autoattach.class;
        }

        private AutoattachImpl(AutoattachBuilder base) {
            if (base.getKey() == null) {
                this._key = new AutoattachKey(base.getAutoattachId());
                this._autoattachId = base.getAutoattachId();
            } else {
                this._key = base.getKey();
                this._autoattachId = this._key.getAutoattachId();
            }
            this._autoattachExternalIds = base.getAutoattachExternalIds();
            this._autoattachUuid = base.getAutoattachUuid();
            this._bridgeId = base.getBridgeId();
            this._mappings = base.getMappings();
            this._systemDescription = base.getSystemDescription();
            this._systemName = base.getSystemName();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<Autoattach>>, Augmentation<Autoattach>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<Autoattach>>, Augmentation<Autoattach>>(base.augmentation);
                }
            }
        }

        @Override
        public List<AutoattachExternalIds> getAutoattachExternalIds() {
            return this._autoattachExternalIds;
        }

        @Override
        public Uri getAutoattachId() {
            return this._autoattachId;
        }

        @Override
        public Uuid getAutoattachUuid() {
            return this._autoattachUuid;
        }

        @Override
        public Uri getBridgeId() {
            return this._bridgeId;
        }

        @Override
        public AutoattachKey getKey() {
            return this._key;
        }

        @Override
        public List<Mappings> getMappings() {
            return this._mappings;
        }

        @Override
        public String getSystemDescription() {
            return this._systemDescription;
        }

        @Override
        public String getSystemName() {
            return this._systemName;
        }

        public <E extends Augmentation<Autoattach>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._autoattachExternalIds);
            result = 31 * result + Objects.hashCode(this._autoattachId);
            result = 31 * result + Objects.hashCode(this._autoattachUuid);
            result = 31 * result + Objects.hashCode(this._bridgeId);
            result = 31 * result + Objects.hashCode(this._key);
            result = 31 * result + Objects.hashCode(this._mappings);
            result = 31 * result + Objects.hashCode(this._systemDescription);
            result = 31 * result + Objects.hashCode(this._systemName);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Autoattach.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Autoattach other = (Autoattach)obj;
            if (!Objects.equals(this._autoattachExternalIds, other.getAutoattachExternalIds())) {
                return false;
            }
            if (!Objects.equals(this._autoattachId, other.getAutoattachId())) {
                return false;
            }
            if (!Objects.equals(this._autoattachUuid, other.getAutoattachUuid())) {
                return false;
            }
            if (!Objects.equals(this._bridgeId, other.getBridgeId())) {
                return false;
            }
            if (!Objects.equals(this._key, other.getKey())) {
                return false;
            }
            if (!Objects.equals(this._mappings, other.getMappings())) {
                return false;
            }
            if (!Objects.equals(this._systemDescription, other.getSystemDescription())) {
                return false;
            }
            if (!Objects.equals(this._systemName, other.getSystemName())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                AutoattachImpl otherImpl = (AutoattachImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Autoattach>>, Augmentation<Autoattach>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "Autoattach [";
            StringBuilder builder = new StringBuilder(name);
            if (this._autoattachExternalIds != null) {
                builder.append("_autoattachExternalIds=");
                builder.append(this._autoattachExternalIds);
                builder.append(", ");
            }
            if (this._autoattachId != null) {
                builder.append("_autoattachId=");
                builder.append(this._autoattachId);
                builder.append(", ");
            }
            if (this._autoattachUuid != null) {
                builder.append("_autoattachUuid=");
                builder.append(this._autoattachUuid);
                builder.append(", ");
            }
            if (this._bridgeId != null) {
                builder.append("_bridgeId=");
                builder.append(this._bridgeId);
                builder.append(", ");
            }
            if (this._key != null) {
                builder.append("_key=");
                builder.append(this._key);
                builder.append(", ");
            }
            if (this._mappings != null) {
                builder.append("_mappings=");
                builder.append(this._mappings);
                builder.append(", ");
            }
            if (this._systemDescription != null) {
                builder.append("_systemDescription=");
                builder.append(this._systemDescription);
                builder.append(", ");
            }
            if (this._systemName != null) {
                builder.append("_systemName=");
                builder.append(this._systemName);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

