/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ovsdb.rev150105.ovsdb.bridge.attributes;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ovsdb.rev150105.OvsdbBridgeProtocolBase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ovsdb.rev150105.ovsdb.bridge.attributes.ProtocolEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ovsdb.rev150105.ovsdb.bridge.attributes.ProtocolEntryKey;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class ProtocolEntryBuilder
implements Builder<ProtocolEntry> {
    private ProtocolEntryKey _key;
    private Class<? extends OvsdbBridgeProtocolBase> _protocol;
    Map<Class<? extends Augmentation<ProtocolEntry>>, Augmentation<ProtocolEntry>> augmentation = Collections.emptyMap();

    public ProtocolEntryBuilder() {
    }

    public ProtocolEntryBuilder(ProtocolEntry base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new ProtocolEntryKey(base.getProtocol());
            this._protocol = base.getProtocol();
        } else {
            this._key = base.getKey();
            this._protocol = this._key.getProtocol();
        }
        if (base instanceof ProtocolEntryImpl) {
            ProtocolEntryImpl impl = (ProtocolEntryImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<ProtocolEntry>>, Augmentation<ProtocolEntry>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ProtocolEntry>>, Augmentation<ProtocolEntry>>(casted.augmentations());
        }
    }

    public ProtocolEntryKey getKey() {
        return this._key;
    }

    public Class<? extends OvsdbBridgeProtocolBase> getProtocol() {
        return this._protocol;
    }

    public <E extends Augmentation<ProtocolEntry>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public ProtocolEntryBuilder setKey(ProtocolEntryKey value) {
        this._key = value;
        return this;
    }

    public ProtocolEntryBuilder setProtocol(Class<? extends OvsdbBridgeProtocolBase> value) {
        this._protocol = value;
        return this;
    }

    public ProtocolEntryBuilder addAugmentation(Class<? extends Augmentation<ProtocolEntry>> augmentationType, Augmentation<ProtocolEntry> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ProtocolEntry>>, Augmentation<ProtocolEntry>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public ProtocolEntryBuilder removeAugmentation(Class<? extends Augmentation<ProtocolEntry>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public ProtocolEntry build() {
        return new ProtocolEntryImpl(this);
    }

    private static final class ProtocolEntryImpl
    implements ProtocolEntry {
        private final ProtocolEntryKey _key;
        private final Class<? extends OvsdbBridgeProtocolBase> _protocol;
        private Map<Class<? extends Augmentation<ProtocolEntry>>, Augmentation<ProtocolEntry>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<ProtocolEntry> getImplementedInterface() {
            return ProtocolEntry.class;
        }

        private ProtocolEntryImpl(ProtocolEntryBuilder base) {
            if (base.getKey() == null) {
                this._key = new ProtocolEntryKey(base.getProtocol());
                this._protocol = base.getProtocol();
            } else {
                this._key = base.getKey();
                this._protocol = this._key.getProtocol();
            }
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<ProtocolEntry>>, Augmentation<ProtocolEntry>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<ProtocolEntry>>, Augmentation<ProtocolEntry>>(base.augmentation);
                }
            }
        }

        @Override
        public ProtocolEntryKey getKey() {
            return this._key;
        }

        @Override
        public Class<? extends OvsdbBridgeProtocolBase> getProtocol() {
            return this._protocol;
        }

        public <E extends Augmentation<ProtocolEntry>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._key);
            result = 31 * result + Objects.hashCode(this._protocol);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!ProtocolEntry.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            ProtocolEntry other = (ProtocolEntry)obj;
            if (!Objects.equals(this._key, other.getKey())) {
                return false;
            }
            if (!Objects.equals(this._protocol, other.getProtocol())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                ProtocolEntryImpl otherImpl = (ProtocolEntryImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<ProtocolEntry>>, Augmentation<ProtocolEntry>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "ProtocolEntry [";
            StringBuilder builder = new StringBuilder(name);
            if (this._key != null) {
                builder.append("_key=");
                builder.append(this._key);
                builder.append(", ");
            }
            if (this._protocol != null) {
                builder.append("_protocol=");
                builder.append(this._protocol);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

