/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ovsdb.rev150105.ovsdb.bridge.attributes;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Uri;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.Uuid;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ovsdb.rev150105.ovsdb.bridge.attributes.ControllerEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ovsdb.rev150105.ovsdb.bridge.attributes.ControllerEntryKey;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class ControllerEntryBuilder
implements Builder<ControllerEntry> {
    private Uuid _controllerUuid;
    private Long _inactivityProbe;
    private ControllerEntryKey _key;
    private Long _maxBackoff;
    private Uri _target;
    private Boolean _isConnected;
    Map<Class<? extends Augmentation<ControllerEntry>>, Augmentation<ControllerEntry>> augmentation = Collections.emptyMap();

    public ControllerEntryBuilder() {
    }

    public ControllerEntryBuilder(ControllerEntry base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new ControllerEntryKey(base.getTarget());
            this._target = base.getTarget();
        } else {
            this._key = base.getKey();
            this._target = this._key.getTarget();
        }
        this._controllerUuid = base.getControllerUuid();
        this._inactivityProbe = base.getInactivityProbe();
        this._maxBackoff = base.getMaxBackoff();
        this._isConnected = base.isIsConnected();
        if (base instanceof ControllerEntryImpl) {
            ControllerEntryImpl impl = (ControllerEntryImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<ControllerEntry>>, Augmentation<ControllerEntry>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ControllerEntry>>, Augmentation<ControllerEntry>>(casted.augmentations());
        }
    }

    public Uuid getControllerUuid() {
        return this._controllerUuid;
    }

    public Long getInactivityProbe() {
        return this._inactivityProbe;
    }

    public ControllerEntryKey getKey() {
        return this._key;
    }

    public Long getMaxBackoff() {
        return this._maxBackoff;
    }

    public Uri getTarget() {
        return this._target;
    }

    public Boolean isIsConnected() {
        return this._isConnected;
    }

    public <E extends Augmentation<ControllerEntry>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public ControllerEntryBuilder setControllerUuid(Uuid value) {
        this._controllerUuid = value;
        return this;
    }

    private static void checkInactivityProbeRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..4294967295]].", value));
    }

    public ControllerEntryBuilder setInactivityProbe(Long value) {
        if (value != null) {
            ControllerEntryBuilder.checkInactivityProbeRange(value);
        }
        this._inactivityProbe = value;
        return this;
    }

    public ControllerEntryBuilder setKey(ControllerEntryKey value) {
        this._key = value;
        return this;
    }

    private static void checkMaxBackoffRange(long value) {
        if (value >= 1000L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[1000..4294967295]].", value));
    }

    public ControllerEntryBuilder setMaxBackoff(Long value) {
        if (value != null) {
            ControllerEntryBuilder.checkMaxBackoffRange(value);
        }
        this._maxBackoff = value;
        return this;
    }

    public ControllerEntryBuilder setTarget(Uri value) {
        this._target = value;
        return this;
    }

    public ControllerEntryBuilder setIsConnected(Boolean value) {
        this._isConnected = value;
        return this;
    }

    public ControllerEntryBuilder addAugmentation(Class<? extends Augmentation<ControllerEntry>> augmentationType, Augmentation<ControllerEntry> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ControllerEntry>>, Augmentation<ControllerEntry>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public ControllerEntryBuilder removeAugmentation(Class<? extends Augmentation<ControllerEntry>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public ControllerEntry build() {
        return new ControllerEntryImpl(this);
    }

    private static final class ControllerEntryImpl
    implements ControllerEntry {
        private final Uuid _controllerUuid;
        private final Long _inactivityProbe;
        private final ControllerEntryKey _key;
        private final Long _maxBackoff;
        private final Uri _target;
        private final Boolean _isConnected;
        private Map<Class<? extends Augmentation<ControllerEntry>>, Augmentation<ControllerEntry>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<ControllerEntry> getImplementedInterface() {
            return ControllerEntry.class;
        }

        private ControllerEntryImpl(ControllerEntryBuilder base) {
            if (base.getKey() == null) {
                this._key = new ControllerEntryKey(base.getTarget());
                this._target = base.getTarget();
            } else {
                this._key = base.getKey();
                this._target = this._key.getTarget();
            }
            this._controllerUuid = base.getControllerUuid();
            this._inactivityProbe = base.getInactivityProbe();
            this._maxBackoff = base.getMaxBackoff();
            this._isConnected = base.isIsConnected();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<ControllerEntry>>, Augmentation<ControllerEntry>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<ControllerEntry>>, Augmentation<ControllerEntry>>(base.augmentation);
                }
            }
        }

        @Override
        public Uuid getControllerUuid() {
            return this._controllerUuid;
        }

        @Override
        public Long getInactivityProbe() {
            return this._inactivityProbe;
        }

        @Override
        public ControllerEntryKey getKey() {
            return this._key;
        }

        @Override
        public Long getMaxBackoff() {
            return this._maxBackoff;
        }

        @Override
        public Uri getTarget() {
            return this._target;
        }

        @Override
        public Boolean isIsConnected() {
            return this._isConnected;
        }

        public <E extends Augmentation<ControllerEntry>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._controllerUuid);
            result = 31 * result + Objects.hashCode(this._inactivityProbe);
            result = 31 * result + Objects.hashCode(this._key);
            result = 31 * result + Objects.hashCode(this._maxBackoff);
            result = 31 * result + Objects.hashCode(this._target);
            result = 31 * result + Objects.hashCode(this._isConnected);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!ControllerEntry.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            ControllerEntry other = (ControllerEntry)obj;
            if (!Objects.equals(this._controllerUuid, other.getControllerUuid())) {
                return false;
            }
            if (!Objects.equals(this._inactivityProbe, other.getInactivityProbe())) {
                return false;
            }
            if (!Objects.equals(this._key, other.getKey())) {
                return false;
            }
            if (!Objects.equals(this._maxBackoff, other.getMaxBackoff())) {
                return false;
            }
            if (!Objects.equals(this._target, other.getTarget())) {
                return false;
            }
            if (!Objects.equals(this._isConnected, other.isIsConnected())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                ControllerEntryImpl otherImpl = (ControllerEntryImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<ControllerEntry>>, Augmentation<ControllerEntry>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "ControllerEntry [";
            StringBuilder builder = new StringBuilder(name);
            if (this._controllerUuid != null) {
                builder.append("_controllerUuid=");
                builder.append(this._controllerUuid);
                builder.append(", ");
            }
            if (this._inactivityProbe != null) {
                builder.append("_inactivityProbe=");
                builder.append(this._inactivityProbe);
                builder.append(", ");
            }
            if (this._key != null) {
                builder.append("_key=");
                builder.append(this._key);
                builder.append(", ");
            }
            if (this._maxBackoff != null) {
                builder.append("_maxBackoff=");
                builder.append(this._maxBackoff);
                builder.append(", ");
            }
            if (this._target != null) {
                builder.append("_target=");
                builder.append(this._target);
                builder.append(", ");
            }
            if (this._isConnected != null) {
                builder.append("_isConnected=");
                builder.append(this._isConnected);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

