/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ovsdb.rev150105;

import java.util.List;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.Uuid;
import org.opendaylight.yang.gen.v1.urn.opendaylight.l2.types.rev130827.VlanId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ovsdb.rev150105.InterfaceTypeBase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ovsdb.rev150105.OvsdbPortInterfaceAttributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ovsdb.rev150105.OvsdbTerminationPointAugmentation;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ovsdb.rev150105.ovsdb.port._interface.attributes.InterfaceBfd;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ovsdb.rev150105.ovsdb.port._interface.attributes.InterfaceBfdStatus;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ovsdb.rev150105.ovsdb.port._interface.attributes.InterfaceExternalIds;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ovsdb.rev150105.ovsdb.port._interface.attributes.InterfaceLldp;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ovsdb.rev150105.ovsdb.port._interface.attributes.InterfaceOtherConfigs;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ovsdb.rev150105.ovsdb.port._interface.attributes.Options;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ovsdb.rev150105.ovsdb.port._interface.attributes.PortExternalIds;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ovsdb.rev150105.ovsdb.port._interface.attributes.PortOtherConfigs;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ovsdb.rev150105.ovsdb.port._interface.attributes.QosEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ovsdb.rev150105.ovsdb.port._interface.attributes.Trunks;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class OvsdbTerminationPointAugmentationBuilder
implements Builder<OvsdbTerminationPointAugmentation> {
    private Long _ifindex;
    private Long _ingressPolicingBurst;
    private Long _ingressPolicingRate;
    private List<InterfaceBfd> _interfaceBfd;
    private List<InterfaceBfdStatus> _interfaceBfdStatus;
    private List<InterfaceExternalIds> _interfaceExternalIds;
    private List<InterfaceLldp> _interfaceLldp;
    private List<InterfaceOtherConfigs> _interfaceOtherConfigs;
    private Class<? extends InterfaceTypeBase> _interfaceType;
    private Uuid _interfaceUuid;
    private String _name;
    private Long _ofport;
    private Integer _ofportRequest;
    private List<Options> _options;
    private List<PortExternalIds> _portExternalIds;
    private List<PortOtherConfigs> _portOtherConfigs;
    private Uuid _portUuid;
    private List<QosEntry> _qosEntry;
    private List<Trunks> _trunks;
    private OvsdbPortInterfaceAttributes.VlanMode _vlanMode;
    private VlanId _vlanTag;

    public OvsdbTerminationPointAugmentationBuilder() {
    }

    public OvsdbTerminationPointAugmentationBuilder(OvsdbPortInterfaceAttributes arg) {
        this._portUuid = arg.getPortUuid();
        this._interfaceUuid = arg.getInterfaceUuid();
        this._name = arg.getName();
        this._ifindex = arg.getIfindex();
        this._interfaceType = arg.getInterfaceType();
        this._options = arg.getOptions();
        this._ofport = arg.getOfport();
        this._ofportRequest = arg.getOfportRequest();
        this._vlanTag = arg.getVlanTag();
        this._trunks = arg.getTrunks();
        this._vlanMode = arg.getVlanMode();
        this._portOtherConfigs = arg.getPortOtherConfigs();
        this._interfaceOtherConfigs = arg.getInterfaceOtherConfigs();
        this._portExternalIds = arg.getPortExternalIds();
        this._interfaceExternalIds = arg.getInterfaceExternalIds();
        this._interfaceLldp = arg.getInterfaceLldp();
        this._interfaceBfd = arg.getInterfaceBfd();
        this._interfaceBfdStatus = arg.getInterfaceBfdStatus();
        this._qosEntry = arg.getQosEntry();
        this._ingressPolicingRate = arg.getIngressPolicingRate();
        this._ingressPolicingBurst = arg.getIngressPolicingBurst();
    }

    public OvsdbTerminationPointAugmentationBuilder(OvsdbTerminationPointAugmentation base) {
        this._ifindex = base.getIfindex();
        this._ingressPolicingBurst = base.getIngressPolicingBurst();
        this._ingressPolicingRate = base.getIngressPolicingRate();
        this._interfaceBfd = base.getInterfaceBfd();
        this._interfaceBfdStatus = base.getInterfaceBfdStatus();
        this._interfaceExternalIds = base.getInterfaceExternalIds();
        this._interfaceLldp = base.getInterfaceLldp();
        this._interfaceOtherConfigs = base.getInterfaceOtherConfigs();
        this._interfaceType = base.getInterfaceType();
        this._interfaceUuid = base.getInterfaceUuid();
        this._name = base.getName();
        this._ofport = base.getOfport();
        this._ofportRequest = base.getOfportRequest();
        this._options = base.getOptions();
        this._portExternalIds = base.getPortExternalIds();
        this._portOtherConfigs = base.getPortOtherConfigs();
        this._portUuid = base.getPortUuid();
        this._qosEntry = base.getQosEntry();
        this._trunks = base.getTrunks();
        this._vlanMode = base.getVlanMode();
        this._vlanTag = base.getVlanTag();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof OvsdbPortInterfaceAttributes) {
            this._portUuid = ((OvsdbPortInterfaceAttributes)arg).getPortUuid();
            this._interfaceUuid = ((OvsdbPortInterfaceAttributes)arg).getInterfaceUuid();
            this._name = ((OvsdbPortInterfaceAttributes)arg).getName();
            this._ifindex = ((OvsdbPortInterfaceAttributes)arg).getIfindex();
            this._interfaceType = ((OvsdbPortInterfaceAttributes)arg).getInterfaceType();
            this._options = ((OvsdbPortInterfaceAttributes)arg).getOptions();
            this._ofport = ((OvsdbPortInterfaceAttributes)arg).getOfport();
            this._ofportRequest = ((OvsdbPortInterfaceAttributes)arg).getOfportRequest();
            this._vlanTag = ((OvsdbPortInterfaceAttributes)arg).getVlanTag();
            this._trunks = ((OvsdbPortInterfaceAttributes)arg).getTrunks();
            this._vlanMode = ((OvsdbPortInterfaceAttributes)arg).getVlanMode();
            this._portOtherConfigs = ((OvsdbPortInterfaceAttributes)arg).getPortOtherConfigs();
            this._interfaceOtherConfigs = ((OvsdbPortInterfaceAttributes)arg).getInterfaceOtherConfigs();
            this._portExternalIds = ((OvsdbPortInterfaceAttributes)arg).getPortExternalIds();
            this._interfaceExternalIds = ((OvsdbPortInterfaceAttributes)arg).getInterfaceExternalIds();
            this._interfaceLldp = ((OvsdbPortInterfaceAttributes)arg).getInterfaceLldp();
            this._interfaceBfd = ((OvsdbPortInterfaceAttributes)arg).getInterfaceBfd();
            this._interfaceBfdStatus = ((OvsdbPortInterfaceAttributes)arg).getInterfaceBfdStatus();
            this._qosEntry = ((OvsdbPortInterfaceAttributes)arg).getQosEntry();
            this._ingressPolicingRate = ((OvsdbPortInterfaceAttributes)arg).getIngressPolicingRate();
            this._ingressPolicingBurst = ((OvsdbPortInterfaceAttributes)arg).getIngressPolicingBurst();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ovsdb.rev150105.OvsdbPortInterfaceAttributes] \nbut was: " + arg);
        }
    }

    public Long getIfindex() {
        return this._ifindex;
    }

    public Long getIngressPolicingBurst() {
        return this._ingressPolicingBurst;
    }

    public Long getIngressPolicingRate() {
        return this._ingressPolicingRate;
    }

    public List<InterfaceBfd> getInterfaceBfd() {
        return this._interfaceBfd;
    }

    public List<InterfaceBfdStatus> getInterfaceBfdStatus() {
        return this._interfaceBfdStatus;
    }

    public List<InterfaceExternalIds> getInterfaceExternalIds() {
        return this._interfaceExternalIds;
    }

    public List<InterfaceLldp> getInterfaceLldp() {
        return this._interfaceLldp;
    }

    public List<InterfaceOtherConfigs> getInterfaceOtherConfigs() {
        return this._interfaceOtherConfigs;
    }

    public Class<? extends InterfaceTypeBase> getInterfaceType() {
        return this._interfaceType;
    }

    public Uuid getInterfaceUuid() {
        return this._interfaceUuid;
    }

    public String getName() {
        return this._name;
    }

    public Long getOfport() {
        return this._ofport;
    }

    public Integer getOfportRequest() {
        return this._ofportRequest;
    }

    public List<Options> getOptions() {
        return this._options;
    }

    public List<PortExternalIds> getPortExternalIds() {
        return this._portExternalIds;
    }

    public List<PortOtherConfigs> getPortOtherConfigs() {
        return this._portOtherConfigs;
    }

    public Uuid getPortUuid() {
        return this._portUuid;
    }

    public List<QosEntry> getQosEntry() {
        return this._qosEntry;
    }

    public List<Trunks> getTrunks() {
        return this._trunks;
    }

    public OvsdbPortInterfaceAttributes.VlanMode getVlanMode() {
        return this._vlanMode;
    }

    public VlanId getVlanTag() {
        return this._vlanTag;
    }

    private static void checkIfindexRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..4294967295]].", value));
    }

    public OvsdbTerminationPointAugmentationBuilder setIfindex(Long value) {
        if (value != null) {
            OvsdbTerminationPointAugmentationBuilder.checkIfindexRange(value);
        }
        this._ifindex = value;
        return this;
    }

    private static void checkIngressPolicingBurstRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..4294967295]].", value));
    }

    public OvsdbTerminationPointAugmentationBuilder setIngressPolicingBurst(Long value) {
        if (value != null) {
            OvsdbTerminationPointAugmentationBuilder.checkIngressPolicingBurstRange(value);
        }
        this._ingressPolicingBurst = value;
        return this;
    }

    private static void checkIngressPolicingRateRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..4294967295]].", value));
    }

    public OvsdbTerminationPointAugmentationBuilder setIngressPolicingRate(Long value) {
        if (value != null) {
            OvsdbTerminationPointAugmentationBuilder.checkIngressPolicingRateRange(value);
        }
        this._ingressPolicingRate = value;
        return this;
    }

    public OvsdbTerminationPointAugmentationBuilder setInterfaceBfd(List<InterfaceBfd> value) {
        this._interfaceBfd = value;
        return this;
    }

    public OvsdbTerminationPointAugmentationBuilder setInterfaceBfdStatus(List<InterfaceBfdStatus> value) {
        this._interfaceBfdStatus = value;
        return this;
    }

    public OvsdbTerminationPointAugmentationBuilder setInterfaceExternalIds(List<InterfaceExternalIds> value) {
        this._interfaceExternalIds = value;
        return this;
    }

    public OvsdbTerminationPointAugmentationBuilder setInterfaceLldp(List<InterfaceLldp> value) {
        this._interfaceLldp = value;
        return this;
    }

    public OvsdbTerminationPointAugmentationBuilder setInterfaceOtherConfigs(List<InterfaceOtherConfigs> value) {
        this._interfaceOtherConfigs = value;
        return this;
    }

    public OvsdbTerminationPointAugmentationBuilder setInterfaceType(Class<? extends InterfaceTypeBase> value) {
        this._interfaceType = value;
        return this;
    }

    public OvsdbTerminationPointAugmentationBuilder setInterfaceUuid(Uuid value) {
        this._interfaceUuid = value;
        return this;
    }

    public OvsdbTerminationPointAugmentationBuilder setName(String value) {
        this._name = value;
        return this;
    }

    private static void checkOfportRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..4294967295]].", value));
    }

    public OvsdbTerminationPointAugmentationBuilder setOfport(Long value) {
        if (value != null) {
            OvsdbTerminationPointAugmentationBuilder.checkOfportRange(value);
        }
        this._ofport = value;
        return this;
    }

    private static void checkOfportRequestRange(int value) {
        if (value >= 1 && value <= 65279) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[1..65279]].", value));
    }

    public OvsdbTerminationPointAugmentationBuilder setOfportRequest(Integer value) {
        if (value != null) {
            OvsdbTerminationPointAugmentationBuilder.checkOfportRequestRange(value);
        }
        this._ofportRequest = value;
        return this;
    }

    public OvsdbTerminationPointAugmentationBuilder setOptions(List<Options> value) {
        this._options = value;
        return this;
    }

    public OvsdbTerminationPointAugmentationBuilder setPortExternalIds(List<PortExternalIds> value) {
        this._portExternalIds = value;
        return this;
    }

    public OvsdbTerminationPointAugmentationBuilder setPortOtherConfigs(List<PortOtherConfigs> value) {
        this._portOtherConfigs = value;
        return this;
    }

    public OvsdbTerminationPointAugmentationBuilder setPortUuid(Uuid value) {
        this._portUuid = value;
        return this;
    }

    public OvsdbTerminationPointAugmentationBuilder setQosEntry(List<QosEntry> value) {
        this._qosEntry = value;
        return this;
    }

    public OvsdbTerminationPointAugmentationBuilder setTrunks(List<Trunks> value) {
        this._trunks = value;
        return this;
    }

    public OvsdbTerminationPointAugmentationBuilder setVlanMode(OvsdbPortInterfaceAttributes.VlanMode value) {
        this._vlanMode = value;
        return this;
    }

    public OvsdbTerminationPointAugmentationBuilder setVlanTag(VlanId value) {
        this._vlanTag = value;
        return this;
    }

    public OvsdbTerminationPointAugmentation build() {
        return new OvsdbTerminationPointAugmentationImpl(this);
    }

    private static final class OvsdbTerminationPointAugmentationImpl
    implements OvsdbTerminationPointAugmentation {
        private final Long _ifindex;
        private final Long _ingressPolicingBurst;
        private final Long _ingressPolicingRate;
        private final List<InterfaceBfd> _interfaceBfd;
        private final List<InterfaceBfdStatus> _interfaceBfdStatus;
        private final List<InterfaceExternalIds> _interfaceExternalIds;
        private final List<InterfaceLldp> _interfaceLldp;
        private final List<InterfaceOtherConfigs> _interfaceOtherConfigs;
        private final Class<? extends InterfaceTypeBase> _interfaceType;
        private final Uuid _interfaceUuid;
        private final String _name;
        private final Long _ofport;
        private final Integer _ofportRequest;
        private final List<Options> _options;
        private final List<PortExternalIds> _portExternalIds;
        private final List<PortOtherConfigs> _portOtherConfigs;
        private final Uuid _portUuid;
        private final List<QosEntry> _qosEntry;
        private final List<Trunks> _trunks;
        private final OvsdbPortInterfaceAttributes.VlanMode _vlanMode;
        private final VlanId _vlanTag;
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<OvsdbTerminationPointAugmentation> getImplementedInterface() {
            return OvsdbTerminationPointAugmentation.class;
        }

        private OvsdbTerminationPointAugmentationImpl(OvsdbTerminationPointAugmentationBuilder base) {
            this._ifindex = base.getIfindex();
            this._ingressPolicingBurst = base.getIngressPolicingBurst();
            this._ingressPolicingRate = base.getIngressPolicingRate();
            this._interfaceBfd = base.getInterfaceBfd();
            this._interfaceBfdStatus = base.getInterfaceBfdStatus();
            this._interfaceExternalIds = base.getInterfaceExternalIds();
            this._interfaceLldp = base.getInterfaceLldp();
            this._interfaceOtherConfigs = base.getInterfaceOtherConfigs();
            this._interfaceType = base.getInterfaceType();
            this._interfaceUuid = base.getInterfaceUuid();
            this._name = base.getName();
            this._ofport = base.getOfport();
            this._ofportRequest = base.getOfportRequest();
            this._options = base.getOptions();
            this._portExternalIds = base.getPortExternalIds();
            this._portOtherConfigs = base.getPortOtherConfigs();
            this._portUuid = base.getPortUuid();
            this._qosEntry = base.getQosEntry();
            this._trunks = base.getTrunks();
            this._vlanMode = base.getVlanMode();
            this._vlanTag = base.getVlanTag();
        }

        @Override
        public Long getIfindex() {
            return this._ifindex;
        }

        @Override
        public Long getIngressPolicingBurst() {
            return this._ingressPolicingBurst;
        }

        @Override
        public Long getIngressPolicingRate() {
            return this._ingressPolicingRate;
        }

        @Override
        public List<InterfaceBfd> getInterfaceBfd() {
            return this._interfaceBfd;
        }

        @Override
        public List<InterfaceBfdStatus> getInterfaceBfdStatus() {
            return this._interfaceBfdStatus;
        }

        @Override
        public List<InterfaceExternalIds> getInterfaceExternalIds() {
            return this._interfaceExternalIds;
        }

        @Override
        public List<InterfaceLldp> getInterfaceLldp() {
            return this._interfaceLldp;
        }

        @Override
        public List<InterfaceOtherConfigs> getInterfaceOtherConfigs() {
            return this._interfaceOtherConfigs;
        }

        @Override
        public Class<? extends InterfaceTypeBase> getInterfaceType() {
            return this._interfaceType;
        }

        @Override
        public Uuid getInterfaceUuid() {
            return this._interfaceUuid;
        }

        @Override
        public String getName() {
            return this._name;
        }

        @Override
        public Long getOfport() {
            return this._ofport;
        }

        @Override
        public Integer getOfportRequest() {
            return this._ofportRequest;
        }

        @Override
        public List<Options> getOptions() {
            return this._options;
        }

        @Override
        public List<PortExternalIds> getPortExternalIds() {
            return this._portExternalIds;
        }

        @Override
        public List<PortOtherConfigs> getPortOtherConfigs() {
            return this._portOtherConfigs;
        }

        @Override
        public Uuid getPortUuid() {
            return this._portUuid;
        }

        @Override
        public List<QosEntry> getQosEntry() {
            return this._qosEntry;
        }

        @Override
        public List<Trunks> getTrunks() {
            return this._trunks;
        }

        @Override
        public OvsdbPortInterfaceAttributes.VlanMode getVlanMode() {
            return this._vlanMode;
        }

        @Override
        public VlanId getVlanTag() {
            return this._vlanTag;
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._ifindex);
            result = 31 * result + Objects.hashCode(this._ingressPolicingBurst);
            result = 31 * result + Objects.hashCode(this._ingressPolicingRate);
            result = 31 * result + Objects.hashCode(this._interfaceBfd);
            result = 31 * result + Objects.hashCode(this._interfaceBfdStatus);
            result = 31 * result + Objects.hashCode(this._interfaceExternalIds);
            result = 31 * result + Objects.hashCode(this._interfaceLldp);
            result = 31 * result + Objects.hashCode(this._interfaceOtherConfigs);
            result = 31 * result + Objects.hashCode(this._interfaceType);
            result = 31 * result + Objects.hashCode(this._interfaceUuid);
            result = 31 * result + Objects.hashCode(this._name);
            result = 31 * result + Objects.hashCode(this._ofport);
            result = 31 * result + Objects.hashCode(this._ofportRequest);
            result = 31 * result + Objects.hashCode(this._options);
            result = 31 * result + Objects.hashCode(this._portExternalIds);
            result = 31 * result + Objects.hashCode(this._portOtherConfigs);
            result = 31 * result + Objects.hashCode(this._portUuid);
            result = 31 * result + Objects.hashCode(this._qosEntry);
            result = 31 * result + Objects.hashCode(this._trunks);
            result = 31 * result + Objects.hashCode((Object)this._vlanMode);
            this.hash = result = 31 * result + Objects.hashCode(this._vlanTag);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!OvsdbTerminationPointAugmentation.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            OvsdbTerminationPointAugmentation other = (OvsdbTerminationPointAugmentation)obj;
            if (!Objects.equals(this._ifindex, other.getIfindex())) {
                return false;
            }
            if (!Objects.equals(this._ingressPolicingBurst, other.getIngressPolicingBurst())) {
                return false;
            }
            if (!Objects.equals(this._ingressPolicingRate, other.getIngressPolicingRate())) {
                return false;
            }
            if (!Objects.equals(this._interfaceBfd, other.getInterfaceBfd())) {
                return false;
            }
            if (!Objects.equals(this._interfaceBfdStatus, other.getInterfaceBfdStatus())) {
                return false;
            }
            if (!Objects.equals(this._interfaceExternalIds, other.getInterfaceExternalIds())) {
                return false;
            }
            if (!Objects.equals(this._interfaceLldp, other.getInterfaceLldp())) {
                return false;
            }
            if (!Objects.equals(this._interfaceOtherConfigs, other.getInterfaceOtherConfigs())) {
                return false;
            }
            if (!Objects.equals(this._interfaceType, other.getInterfaceType())) {
                return false;
            }
            if (!Objects.equals(this._interfaceUuid, other.getInterfaceUuid())) {
                return false;
            }
            if (!Objects.equals(this._name, other.getName())) {
                return false;
            }
            if (!Objects.equals(this._ofport, other.getOfport())) {
                return false;
            }
            if (!Objects.equals(this._ofportRequest, other.getOfportRequest())) {
                return false;
            }
            if (!Objects.equals(this._options, other.getOptions())) {
                return false;
            }
            if (!Objects.equals(this._portExternalIds, other.getPortExternalIds())) {
                return false;
            }
            if (!Objects.equals(this._portOtherConfigs, other.getPortOtherConfigs())) {
                return false;
            }
            if (!Objects.equals(this._portUuid, other.getPortUuid())) {
                return false;
            }
            if (!Objects.equals(this._qosEntry, other.getQosEntry())) {
                return false;
            }
            if (!Objects.equals(this._trunks, other.getTrunks())) {
                return false;
            }
            if (!Objects.equals((Object)this._vlanMode, (Object)other.getVlanMode())) {
                return false;
            }
            return Objects.equals(this._vlanTag, other.getVlanTag());
        }

        public String toString() {
            String name = "OvsdbTerminationPointAugmentation [";
            StringBuilder builder = new StringBuilder(name);
            if (this._ifindex != null) {
                builder.append("_ifindex=");
                builder.append(this._ifindex);
                builder.append(", ");
            }
            if (this._ingressPolicingBurst != null) {
                builder.append("_ingressPolicingBurst=");
                builder.append(this._ingressPolicingBurst);
                builder.append(", ");
            }
            if (this._ingressPolicingRate != null) {
                builder.append("_ingressPolicingRate=");
                builder.append(this._ingressPolicingRate);
                builder.append(", ");
            }
            if (this._interfaceBfd != null) {
                builder.append("_interfaceBfd=");
                builder.append(this._interfaceBfd);
                builder.append(", ");
            }
            if (this._interfaceBfdStatus != null) {
                builder.append("_interfaceBfdStatus=");
                builder.append(this._interfaceBfdStatus);
                builder.append(", ");
            }
            if (this._interfaceExternalIds != null) {
                builder.append("_interfaceExternalIds=");
                builder.append(this._interfaceExternalIds);
                builder.append(", ");
            }
            if (this._interfaceLldp != null) {
                builder.append("_interfaceLldp=");
                builder.append(this._interfaceLldp);
                builder.append(", ");
            }
            if (this._interfaceOtherConfigs != null) {
                builder.append("_interfaceOtherConfigs=");
                builder.append(this._interfaceOtherConfigs);
                builder.append(", ");
            }
            if (this._interfaceType != null) {
                builder.append("_interfaceType=");
                builder.append(this._interfaceType);
                builder.append(", ");
            }
            if (this._interfaceUuid != null) {
                builder.append("_interfaceUuid=");
                builder.append(this._interfaceUuid);
                builder.append(", ");
            }
            if (this._name != null) {
                builder.append("_name=");
                builder.append(this._name);
                builder.append(", ");
            }
            if (this._ofport != null) {
                builder.append("_ofport=");
                builder.append(this._ofport);
                builder.append(", ");
            }
            if (this._ofportRequest != null) {
                builder.append("_ofportRequest=");
                builder.append(this._ofportRequest);
                builder.append(", ");
            }
            if (this._options != null) {
                builder.append("_options=");
                builder.append(this._options);
                builder.append(", ");
            }
            if (this._portExternalIds != null) {
                builder.append("_portExternalIds=");
                builder.append(this._portExternalIds);
                builder.append(", ");
            }
            if (this._portOtherConfigs != null) {
                builder.append("_portOtherConfigs=");
                builder.append(this._portOtherConfigs);
                builder.append(", ");
            }
            if (this._portUuid != null) {
                builder.append("_portUuid=");
                builder.append(this._portUuid);
                builder.append(", ");
            }
            if (this._qosEntry != null) {
                builder.append("_qosEntry=");
                builder.append(this._qosEntry);
                builder.append(", ");
            }
            if (this._trunks != null) {
                builder.append("_trunks=");
                builder.append(this._trunks);
                builder.append(", ");
            }
            if (this._vlanMode != null) {
                builder.append("_vlanMode=");
                builder.append((Object)this._vlanMode);
                builder.append(", ");
            }
            if (this._vlanTag != null) {
                builder.append("_vlanTag=");
                builder.append(this._vlanTag);
            }
            return builder.append(']').toString();
        }
    }
}

