/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ovsdb.rev150105;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.Uuid;
import org.opendaylight.yang.gen.v1.urn.opendaylight.l2.types.rev130827.VlanId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ovsdb.rev150105.InterfaceTypeBase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ovsdb.rev150105.ovsdb.port._interface.attributes.InterfaceBfd;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ovsdb.rev150105.ovsdb.port._interface.attributes.InterfaceBfdStatus;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ovsdb.rev150105.ovsdb.port._interface.attributes.InterfaceExternalIds;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ovsdb.rev150105.ovsdb.port._interface.attributes.InterfaceLldp;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ovsdb.rev150105.ovsdb.port._interface.attributes.InterfaceOtherConfigs;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ovsdb.rev150105.ovsdb.port._interface.attributes.Options;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ovsdb.rev150105.ovsdb.port._interface.attributes.PortExternalIds;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ovsdb.rev150105.ovsdb.port._interface.attributes.PortOtherConfigs;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ovsdb.rev150105.ovsdb.port._interface.attributes.QosEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ovsdb.rev150105.ovsdb.port._interface.attributes.Trunks;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

public interface OvsdbPortInterfaceAttributes
extends DataObject {
    public static final QName QNAME = QName.create((String)"urn:opendaylight:params:xml:ns:yang:ovsdb", (String)"2015-01-05", (String)"ovsdb-port-interface-attributes").intern();

    public Uuid getPortUuid();

    public Uuid getInterfaceUuid();

    public String getName();

    public Long getIfindex();

    public Class<? extends InterfaceTypeBase> getInterfaceType();

    public List<Options> getOptions();

    public Long getOfport();

    public Integer getOfportRequest();

    public VlanId getVlanTag();

    public List<Trunks> getTrunks();

    public VlanMode getVlanMode();

    public List<PortOtherConfigs> getPortOtherConfigs();

    public List<InterfaceOtherConfigs> getInterfaceOtherConfigs();

    public List<PortExternalIds> getPortExternalIds();

    public List<InterfaceExternalIds> getInterfaceExternalIds();

    public List<InterfaceLldp> getInterfaceLldp();

    public List<InterfaceBfd> getInterfaceBfd();

    public List<InterfaceBfdStatus> getInterfaceBfdStatus();

    public List<QosEntry> getQosEntry();

    public Long getIngressPolicingRate();

    public Long getIngressPolicingBurst();

    public static enum VlanMode {
        Access(1, "access"),
        NativeTagged(2, "native-tagged"),
        NativeUntagged(3, "native-untagged"),
        Trunk(4, "trunk");

        private static final Map<Integer, VlanMode> VALUE_MAP;
        private final String name;
        private final int value;

        private VlanMode(int value, String name) {
            this.value = value;
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public int getIntValue() {
            return this.value;
        }

        public static VlanMode forValue(int valueArg) {
            return VALUE_MAP.get(valueArg);
        }

        static {
            ImmutableMap.Builder b = ImmutableMap.builder();
            for (VlanMode enumItem : VlanMode.values()) {
                b.put((Object)enumItem.value, (Object)enumItem);
            }
            VALUE_MAP = b.build();
        }
    }
}

