/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.overlay.rev150105;

import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddress;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.PortNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.overlay.rev150105.IpPortLocator;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.overlay.rev150105.TunnelSourceParameters;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class TunnelSourceParametersBuilder
implements Builder<TunnelSourceParameters> {
    private IpAddress _ip;
    private PortNumber _port;

    public TunnelSourceParametersBuilder() {
    }

    public TunnelSourceParametersBuilder(IpPortLocator arg) {
        this._ip = arg.getIp();
        this._port = arg.getPort();
    }

    public TunnelSourceParametersBuilder(TunnelSourceParameters base) {
        this._ip = base.getIp();
        this._port = base.getPort();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof IpPortLocator) {
            this._ip = ((IpPortLocator)arg).getIp();
            this._port = ((IpPortLocator)arg).getPort();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.overlay.rev150105.IpPortLocator] \nbut was: " + arg);
        }
    }

    public IpAddress getIp() {
        return this._ip;
    }

    public PortNumber getPort() {
        return this._port;
    }

    public TunnelSourceParametersBuilder setIp(IpAddress value) {
        this._ip = value;
        return this;
    }

    public TunnelSourceParametersBuilder setPort(PortNumber value) {
        this._port = value;
        return this;
    }

    public TunnelSourceParameters build() {
        return new TunnelSourceParametersImpl(this);
    }

    private static final class TunnelSourceParametersImpl
    implements TunnelSourceParameters {
        private final IpAddress _ip;
        private final PortNumber _port;
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<TunnelSourceParameters> getImplementedInterface() {
            return TunnelSourceParameters.class;
        }

        private TunnelSourceParametersImpl(TunnelSourceParametersBuilder base) {
            this._ip = base.getIp();
            this._port = base.getPort();
        }

        @Override
        public IpAddress getIp() {
            return this._ip;
        }

        @Override
        public PortNumber getPort() {
            return this._port;
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._ip);
            this.hash = result = 31 * result + Objects.hashCode(this._port);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!TunnelSourceParameters.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            TunnelSourceParameters other = (TunnelSourceParameters)obj;
            if (!Objects.equals(this._ip, other.getIp())) {
                return false;
            }
            return Objects.equals(this._port, other.getPort());
        }

        public String toString() {
            String name = "TunnelSourceParameters [";
            StringBuilder builder = new StringBuilder(name);
            if (this._ip != null) {
                builder.append("_ip=");
                builder.append(this._ip);
                builder.append(", ");
            }
            if (this._port != null) {
                builder.append("_port=");
                builder.append(this._port);
            }
            return builder.append(']').toString();
        }
    }
}

