/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.intel.params.xml.ns.sf.desc.mon.rpt.rev141105.sf.monitoring.info.resource.utilization.sf.ports.bandwidth.utilization;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.ZeroBasedCounter64;
import org.opendaylight.yang.gen.v1.urn.intel.params.xml.ns.sf.desc.mon.rpt.rev141105.sf.monitoring.info.resource.utilization.sf.ports.bandwidth.utilization.PortBandwidthUtilization;
import org.opendaylight.yang.gen.v1.urn.intel.params.xml.ns.sf.desc.mon.rpt.rev141105.sf.monitoring.info.resource.utilization.sf.ports.bandwidth.utilization.PortBandwidthUtilizationKey;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class PortBandwidthUtilizationBuilder
implements Builder<PortBandwidthUtilization> {
    private Long _bandwidthUtilization;
    private PortBandwidthUtilizationKey _key;
    private Long _portId;
    private ZeroBasedCounter64 _rxBytes;
    private Long _rxBytesRate;
    private ZeroBasedCounter64 _rxPacket;
    private Long _rxPacketRate;
    private ZeroBasedCounter64 _txBytes;
    private Long _txBytesRate;
    private ZeroBasedCounter64 _txPacket;
    private Long _txPacketRate;
    Map<Class<? extends Augmentation<PortBandwidthUtilization>>, Augmentation<PortBandwidthUtilization>> augmentation = Collections.emptyMap();

    public PortBandwidthUtilizationBuilder() {
    }

    public PortBandwidthUtilizationBuilder(PortBandwidthUtilization base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new PortBandwidthUtilizationKey(base.getPortId());
            this._portId = base.getPortId();
        } else {
            this._key = base.getKey();
            this._portId = this._key.getPortId();
        }
        this._bandwidthUtilization = base.getBandwidthUtilization();
        this._rxBytes = base.getRxBytes();
        this._rxBytesRate = base.getRxBytesRate();
        this._rxPacket = base.getRxPacket();
        this._rxPacketRate = base.getRxPacketRate();
        this._txBytes = base.getTxBytes();
        this._txBytesRate = base.getTxBytesRate();
        this._txPacket = base.getTxPacket();
        this._txPacketRate = base.getTxPacketRate();
        if (base instanceof PortBandwidthUtilizationImpl) {
            PortBandwidthUtilizationImpl impl = (PortBandwidthUtilizationImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<PortBandwidthUtilization>>, Augmentation<PortBandwidthUtilization>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<PortBandwidthUtilization>>, Augmentation<PortBandwidthUtilization>>(casted.augmentations());
        }
    }

    public Long getBandwidthUtilization() {
        return this._bandwidthUtilization;
    }

    public PortBandwidthUtilizationKey getKey() {
        return this._key;
    }

    public Long getPortId() {
        return this._portId;
    }

    public ZeroBasedCounter64 getRxBytes() {
        return this._rxBytes;
    }

    public Long getRxBytesRate() {
        return this._rxBytesRate;
    }

    public ZeroBasedCounter64 getRxPacket() {
        return this._rxPacket;
    }

    public Long getRxPacketRate() {
        return this._rxPacketRate;
    }

    public ZeroBasedCounter64 getTxBytes() {
        return this._txBytes;
    }

    public Long getTxBytesRate() {
        return this._txBytesRate;
    }

    public ZeroBasedCounter64 getTxPacket() {
        return this._txPacket;
    }

    public Long getTxPacketRate() {
        return this._txPacketRate;
    }

    public <E extends Augmentation<PortBandwidthUtilization>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    private static void checkBandwidthUtilizationRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..4294967295]].", value));
    }

    public PortBandwidthUtilizationBuilder setBandwidthUtilization(Long value) {
        if (value != null) {
            PortBandwidthUtilizationBuilder.checkBandwidthUtilizationRange(value);
        }
        this._bandwidthUtilization = value;
        return this;
    }

    public PortBandwidthUtilizationBuilder setKey(PortBandwidthUtilizationKey value) {
        this._key = value;
        return this;
    }

    private static void checkPortIdRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..4294967295]].", value));
    }

    public PortBandwidthUtilizationBuilder setPortId(Long value) {
        if (value != null) {
            PortBandwidthUtilizationBuilder.checkPortIdRange(value);
        }
        this._portId = value;
        return this;
    }

    public PortBandwidthUtilizationBuilder setRxBytes(ZeroBasedCounter64 value) {
        this._rxBytes = value;
        return this;
    }

    private static void checkRxBytesRateRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..4294967295]].", value));
    }

    public PortBandwidthUtilizationBuilder setRxBytesRate(Long value) {
        if (value != null) {
            PortBandwidthUtilizationBuilder.checkRxBytesRateRange(value);
        }
        this._rxBytesRate = value;
        return this;
    }

    public PortBandwidthUtilizationBuilder setRxPacket(ZeroBasedCounter64 value) {
        this._rxPacket = value;
        return this;
    }

    private static void checkRxPacketRateRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..4294967295]].", value));
    }

    public PortBandwidthUtilizationBuilder setRxPacketRate(Long value) {
        if (value != null) {
            PortBandwidthUtilizationBuilder.checkRxPacketRateRange(value);
        }
        this._rxPacketRate = value;
        return this;
    }

    public PortBandwidthUtilizationBuilder setTxBytes(ZeroBasedCounter64 value) {
        this._txBytes = value;
        return this;
    }

    private static void checkTxBytesRateRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..4294967295]].", value));
    }

    public PortBandwidthUtilizationBuilder setTxBytesRate(Long value) {
        if (value != null) {
            PortBandwidthUtilizationBuilder.checkTxBytesRateRange(value);
        }
        this._txBytesRate = value;
        return this;
    }

    public PortBandwidthUtilizationBuilder setTxPacket(ZeroBasedCounter64 value) {
        this._txPacket = value;
        return this;
    }

    private static void checkTxPacketRateRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..4294967295]].", value));
    }

    public PortBandwidthUtilizationBuilder setTxPacketRate(Long value) {
        if (value != null) {
            PortBandwidthUtilizationBuilder.checkTxPacketRateRange(value);
        }
        this._txPacketRate = value;
        return this;
    }

    public PortBandwidthUtilizationBuilder addAugmentation(Class<? extends Augmentation<PortBandwidthUtilization>> augmentationType, Augmentation<PortBandwidthUtilization> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<PortBandwidthUtilization>>, Augmentation<PortBandwidthUtilization>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public PortBandwidthUtilizationBuilder removeAugmentation(Class<? extends Augmentation<PortBandwidthUtilization>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public PortBandwidthUtilization build() {
        return new PortBandwidthUtilizationImpl(this);
    }

    private static final class PortBandwidthUtilizationImpl
    implements PortBandwidthUtilization {
        private final Long _bandwidthUtilization;
        private final PortBandwidthUtilizationKey _key;
        private final Long _portId;
        private final ZeroBasedCounter64 _rxBytes;
        private final Long _rxBytesRate;
        private final ZeroBasedCounter64 _rxPacket;
        private final Long _rxPacketRate;
        private final ZeroBasedCounter64 _txBytes;
        private final Long _txBytesRate;
        private final ZeroBasedCounter64 _txPacket;
        private final Long _txPacketRate;
        private Map<Class<? extends Augmentation<PortBandwidthUtilization>>, Augmentation<PortBandwidthUtilization>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<PortBandwidthUtilization> getImplementedInterface() {
            return PortBandwidthUtilization.class;
        }

        private PortBandwidthUtilizationImpl(PortBandwidthUtilizationBuilder base) {
            if (base.getKey() == null) {
                this._key = new PortBandwidthUtilizationKey(base.getPortId());
                this._portId = base.getPortId();
            } else {
                this._key = base.getKey();
                this._portId = this._key.getPortId();
            }
            this._bandwidthUtilization = base.getBandwidthUtilization();
            this._rxBytes = base.getRxBytes();
            this._rxBytesRate = base.getRxBytesRate();
            this._rxPacket = base.getRxPacket();
            this._rxPacketRate = base.getRxPacketRate();
            this._txBytes = base.getTxBytes();
            this._txBytesRate = base.getTxBytesRate();
            this._txPacket = base.getTxPacket();
            this._txPacketRate = base.getTxPacketRate();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<PortBandwidthUtilization>>, Augmentation<PortBandwidthUtilization>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<PortBandwidthUtilization>>, Augmentation<PortBandwidthUtilization>>(base.augmentation);
                }
            }
        }

        @Override
        public Long getBandwidthUtilization() {
            return this._bandwidthUtilization;
        }

        @Override
        public PortBandwidthUtilizationKey getKey() {
            return this._key;
        }

        @Override
        public Long getPortId() {
            return this._portId;
        }

        @Override
        public ZeroBasedCounter64 getRxBytes() {
            return this._rxBytes;
        }

        @Override
        public Long getRxBytesRate() {
            return this._rxBytesRate;
        }

        @Override
        public ZeroBasedCounter64 getRxPacket() {
            return this._rxPacket;
        }

        @Override
        public Long getRxPacketRate() {
            return this._rxPacketRate;
        }

        @Override
        public ZeroBasedCounter64 getTxBytes() {
            return this._txBytes;
        }

        @Override
        public Long getTxBytesRate() {
            return this._txBytesRate;
        }

        @Override
        public ZeroBasedCounter64 getTxPacket() {
            return this._txPacket;
        }

        @Override
        public Long getTxPacketRate() {
            return this._txPacketRate;
        }

        public <E extends Augmentation<PortBandwidthUtilization>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._bandwidthUtilization);
            result = 31 * result + Objects.hashCode(this._key);
            result = 31 * result + Objects.hashCode(this._portId);
            result = 31 * result + Objects.hashCode(this._rxBytes);
            result = 31 * result + Objects.hashCode(this._rxBytesRate);
            result = 31 * result + Objects.hashCode(this._rxPacket);
            result = 31 * result + Objects.hashCode(this._rxPacketRate);
            result = 31 * result + Objects.hashCode(this._txBytes);
            result = 31 * result + Objects.hashCode(this._txBytesRate);
            result = 31 * result + Objects.hashCode(this._txPacket);
            result = 31 * result + Objects.hashCode(this._txPacketRate);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!PortBandwidthUtilization.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            PortBandwidthUtilization other = (PortBandwidthUtilization)obj;
            if (!Objects.equals(this._bandwidthUtilization, other.getBandwidthUtilization())) {
                return false;
            }
            if (!Objects.equals(this._key, other.getKey())) {
                return false;
            }
            if (!Objects.equals(this._portId, other.getPortId())) {
                return false;
            }
            if (!Objects.equals(this._rxBytes, other.getRxBytes())) {
                return false;
            }
            if (!Objects.equals(this._rxBytesRate, other.getRxBytesRate())) {
                return false;
            }
            if (!Objects.equals(this._rxPacket, other.getRxPacket())) {
                return false;
            }
            if (!Objects.equals(this._rxPacketRate, other.getRxPacketRate())) {
                return false;
            }
            if (!Objects.equals(this._txBytes, other.getTxBytes())) {
                return false;
            }
            if (!Objects.equals(this._txBytesRate, other.getTxBytesRate())) {
                return false;
            }
            if (!Objects.equals(this._txPacket, other.getTxPacket())) {
                return false;
            }
            if (!Objects.equals(this._txPacketRate, other.getTxPacketRate())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                PortBandwidthUtilizationImpl otherImpl = (PortBandwidthUtilizationImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<PortBandwidthUtilization>>, Augmentation<PortBandwidthUtilization>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "PortBandwidthUtilization [";
            StringBuilder builder = new StringBuilder(name);
            if (this._bandwidthUtilization != null) {
                builder.append("_bandwidthUtilization=");
                builder.append(this._bandwidthUtilization);
                builder.append(", ");
            }
            if (this._key != null) {
                builder.append("_key=");
                builder.append(this._key);
                builder.append(", ");
            }
            if (this._portId != null) {
                builder.append("_portId=");
                builder.append(this._portId);
                builder.append(", ");
            }
            if (this._rxBytes != null) {
                builder.append("_rxBytes=");
                builder.append(this._rxBytes);
                builder.append(", ");
            }
            if (this._rxBytesRate != null) {
                builder.append("_rxBytesRate=");
                builder.append(this._rxBytesRate);
                builder.append(", ");
            }
            if (this._rxPacket != null) {
                builder.append("_rxPacket=");
                builder.append(this._rxPacket);
                builder.append(", ");
            }
            if (this._rxPacketRate != null) {
                builder.append("_rxPacketRate=");
                builder.append(this._rxPacketRate);
                builder.append(", ");
            }
            if (this._txBytes != null) {
                builder.append("_txBytes=");
                builder.append(this._txBytes);
                builder.append(", ");
            }
            if (this._txBytesRate != null) {
                builder.append("_txBytesRate=");
                builder.append(this._txBytesRate);
                builder.append(", ");
            }
            if (this._txPacket != null) {
                builder.append("_txPacket=");
                builder.append(this._txPacket);
                builder.append(", ");
            }
            if (this._txPacketRate != null) {
                builder.append("_txPacketRate=");
                builder.append(this._txPacketRate);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

