/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.intel.params.xml.ns.sf.desc.mon.rpt.rev141105.sf.monitoring.info;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.intel.params.xml.ns.sf.desc.mon.rpt.rev141105.sf.monitoring.info.ResourceUtilization;
import org.opendaylight.yang.gen.v1.urn.intel.params.xml.ns.sf.desc.mon.rpt.rev141105.sf.monitoring.info.resource.utilization.SFPortsBandwidthUtilization;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class ResourceUtilizationBuilder
implements Builder<ResourceUtilization> {
    private Long _availableMemory;
    private Long _bandwidthUtilization;
    private Long _cPUUtilization;
    private Long _fIBUtilization;
    private Long _memoryUtilization;
    private Long _packetRateUtilization;
    private Long _powerUtilization;
    private Long _rIBUtilization;
    private SFPortsBandwidthUtilization _sFPortsBandwidthUtilization;
    Map<Class<? extends Augmentation<ResourceUtilization>>, Augmentation<ResourceUtilization>> augmentation = Collections.emptyMap();

    public ResourceUtilizationBuilder() {
    }

    public ResourceUtilizationBuilder(ResourceUtilization base) {
        AugmentationHolder casted;
        this._availableMemory = base.getAvailableMemory();
        this._bandwidthUtilization = base.getBandwidthUtilization();
        this._cPUUtilization = base.getCPUUtilization();
        this._fIBUtilization = base.getFIBUtilization();
        this._memoryUtilization = base.getMemoryUtilization();
        this._packetRateUtilization = base.getPacketRateUtilization();
        this._powerUtilization = base.getPowerUtilization();
        this._rIBUtilization = base.getRIBUtilization();
        this._sFPortsBandwidthUtilization = base.getSFPortsBandwidthUtilization();
        if (base instanceof ResourceUtilizationImpl) {
            ResourceUtilizationImpl impl = (ResourceUtilizationImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<ResourceUtilization>>, Augmentation<ResourceUtilization>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ResourceUtilization>>, Augmentation<ResourceUtilization>>(casted.augmentations());
        }
    }

    public Long getAvailableMemory() {
        return this._availableMemory;
    }

    public Long getBandwidthUtilization() {
        return this._bandwidthUtilization;
    }

    public Long getCPUUtilization() {
        return this._cPUUtilization;
    }

    public Long getFIBUtilization() {
        return this._fIBUtilization;
    }

    public Long getMemoryUtilization() {
        return this._memoryUtilization;
    }

    public Long getPacketRateUtilization() {
        return this._packetRateUtilization;
    }

    public Long getPowerUtilization() {
        return this._powerUtilization;
    }

    public Long getRIBUtilization() {
        return this._rIBUtilization;
    }

    public SFPortsBandwidthUtilization getSFPortsBandwidthUtilization() {
        return this._sFPortsBandwidthUtilization;
    }

    public <E extends Augmentation<ResourceUtilization>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    private static void checkAvailableMemoryRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..4294967295]].", value));
    }

    public ResourceUtilizationBuilder setAvailableMemory(Long value) {
        if (value != null) {
            ResourceUtilizationBuilder.checkAvailableMemoryRange(value);
        }
        this._availableMemory = value;
        return this;
    }

    private static void checkBandwidthUtilizationRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..4294967295]].", value));
    }

    public ResourceUtilizationBuilder setBandwidthUtilization(Long value) {
        if (value != null) {
            ResourceUtilizationBuilder.checkBandwidthUtilizationRange(value);
        }
        this._bandwidthUtilization = value;
        return this;
    }

    private static void checkCPUUtilizationRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..4294967295]].", value));
    }

    public ResourceUtilizationBuilder setCPUUtilization(Long value) {
        if (value != null) {
            ResourceUtilizationBuilder.checkCPUUtilizationRange(value);
        }
        this._cPUUtilization = value;
        return this;
    }

    private static void checkFIBUtilizationRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..4294967295]].", value));
    }

    public ResourceUtilizationBuilder setFIBUtilization(Long value) {
        if (value != null) {
            ResourceUtilizationBuilder.checkFIBUtilizationRange(value);
        }
        this._fIBUtilization = value;
        return this;
    }

    private static void checkMemoryUtilizationRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..4294967295]].", value));
    }

    public ResourceUtilizationBuilder setMemoryUtilization(Long value) {
        if (value != null) {
            ResourceUtilizationBuilder.checkMemoryUtilizationRange(value);
        }
        this._memoryUtilization = value;
        return this;
    }

    private static void checkPacketRateUtilizationRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..4294967295]].", value));
    }

    public ResourceUtilizationBuilder setPacketRateUtilization(Long value) {
        if (value != null) {
            ResourceUtilizationBuilder.checkPacketRateUtilizationRange(value);
        }
        this._packetRateUtilization = value;
        return this;
    }

    private static void checkPowerUtilizationRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..4294967295]].", value));
    }

    public ResourceUtilizationBuilder setPowerUtilization(Long value) {
        if (value != null) {
            ResourceUtilizationBuilder.checkPowerUtilizationRange(value);
        }
        this._powerUtilization = value;
        return this;
    }

    private static void checkRIBUtilizationRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..4294967295]].", value));
    }

    public ResourceUtilizationBuilder setRIBUtilization(Long value) {
        if (value != null) {
            ResourceUtilizationBuilder.checkRIBUtilizationRange(value);
        }
        this._rIBUtilization = value;
        return this;
    }

    public ResourceUtilizationBuilder setSFPortsBandwidthUtilization(SFPortsBandwidthUtilization value) {
        this._sFPortsBandwidthUtilization = value;
        return this;
    }

    public ResourceUtilizationBuilder addAugmentation(Class<? extends Augmentation<ResourceUtilization>> augmentationType, Augmentation<ResourceUtilization> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ResourceUtilization>>, Augmentation<ResourceUtilization>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public ResourceUtilizationBuilder removeAugmentation(Class<? extends Augmentation<ResourceUtilization>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public ResourceUtilization build() {
        return new ResourceUtilizationImpl(this);
    }

    private static final class ResourceUtilizationImpl
    implements ResourceUtilization {
        private final Long _availableMemory;
        private final Long _bandwidthUtilization;
        private final Long _cPUUtilization;
        private final Long _fIBUtilization;
        private final Long _memoryUtilization;
        private final Long _packetRateUtilization;
        private final Long _powerUtilization;
        private final Long _rIBUtilization;
        private final SFPortsBandwidthUtilization _sFPortsBandwidthUtilization;
        private Map<Class<? extends Augmentation<ResourceUtilization>>, Augmentation<ResourceUtilization>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<ResourceUtilization> getImplementedInterface() {
            return ResourceUtilization.class;
        }

        private ResourceUtilizationImpl(ResourceUtilizationBuilder base) {
            this._availableMemory = base.getAvailableMemory();
            this._bandwidthUtilization = base.getBandwidthUtilization();
            this._cPUUtilization = base.getCPUUtilization();
            this._fIBUtilization = base.getFIBUtilization();
            this._memoryUtilization = base.getMemoryUtilization();
            this._packetRateUtilization = base.getPacketRateUtilization();
            this._powerUtilization = base.getPowerUtilization();
            this._rIBUtilization = base.getRIBUtilization();
            this._sFPortsBandwidthUtilization = base.getSFPortsBandwidthUtilization();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<ResourceUtilization>>, Augmentation<ResourceUtilization>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<ResourceUtilization>>, Augmentation<ResourceUtilization>>(base.augmentation);
                }
            }
        }

        @Override
        public Long getAvailableMemory() {
            return this._availableMemory;
        }

        @Override
        public Long getBandwidthUtilization() {
            return this._bandwidthUtilization;
        }

        @Override
        public Long getCPUUtilization() {
            return this._cPUUtilization;
        }

        @Override
        public Long getFIBUtilization() {
            return this._fIBUtilization;
        }

        @Override
        public Long getMemoryUtilization() {
            return this._memoryUtilization;
        }

        @Override
        public Long getPacketRateUtilization() {
            return this._packetRateUtilization;
        }

        @Override
        public Long getPowerUtilization() {
            return this._powerUtilization;
        }

        @Override
        public Long getRIBUtilization() {
            return this._rIBUtilization;
        }

        @Override
        public SFPortsBandwidthUtilization getSFPortsBandwidthUtilization() {
            return this._sFPortsBandwidthUtilization;
        }

        public <E extends Augmentation<ResourceUtilization>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._availableMemory);
            result = 31 * result + Objects.hashCode(this._bandwidthUtilization);
            result = 31 * result + Objects.hashCode(this._cPUUtilization);
            result = 31 * result + Objects.hashCode(this._fIBUtilization);
            result = 31 * result + Objects.hashCode(this._memoryUtilization);
            result = 31 * result + Objects.hashCode(this._packetRateUtilization);
            result = 31 * result + Objects.hashCode(this._powerUtilization);
            result = 31 * result + Objects.hashCode(this._rIBUtilization);
            result = 31 * result + Objects.hashCode(this._sFPortsBandwidthUtilization);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!ResourceUtilization.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            ResourceUtilization other = (ResourceUtilization)obj;
            if (!Objects.equals(this._availableMemory, other.getAvailableMemory())) {
                return false;
            }
            if (!Objects.equals(this._bandwidthUtilization, other.getBandwidthUtilization())) {
                return false;
            }
            if (!Objects.equals(this._cPUUtilization, other.getCPUUtilization())) {
                return false;
            }
            if (!Objects.equals(this._fIBUtilization, other.getFIBUtilization())) {
                return false;
            }
            if (!Objects.equals(this._memoryUtilization, other.getMemoryUtilization())) {
                return false;
            }
            if (!Objects.equals(this._packetRateUtilization, other.getPacketRateUtilization())) {
                return false;
            }
            if (!Objects.equals(this._powerUtilization, other.getPowerUtilization())) {
                return false;
            }
            if (!Objects.equals(this._rIBUtilization, other.getRIBUtilization())) {
                return false;
            }
            if (!Objects.equals(this._sFPortsBandwidthUtilization, other.getSFPortsBandwidthUtilization())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                ResourceUtilizationImpl otherImpl = (ResourceUtilizationImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<ResourceUtilization>>, Augmentation<ResourceUtilization>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "ResourceUtilization [";
            StringBuilder builder = new StringBuilder(name);
            if (this._availableMemory != null) {
                builder.append("_availableMemory=");
                builder.append(this._availableMemory);
                builder.append(", ");
            }
            if (this._bandwidthUtilization != null) {
                builder.append("_bandwidthUtilization=");
                builder.append(this._bandwidthUtilization);
                builder.append(", ");
            }
            if (this._cPUUtilization != null) {
                builder.append("_cPUUtilization=");
                builder.append(this._cPUUtilization);
                builder.append(", ");
            }
            if (this._fIBUtilization != null) {
                builder.append("_fIBUtilization=");
                builder.append(this._fIBUtilization);
                builder.append(", ");
            }
            if (this._memoryUtilization != null) {
                builder.append("_memoryUtilization=");
                builder.append(this._memoryUtilization);
                builder.append(", ");
            }
            if (this._packetRateUtilization != null) {
                builder.append("_packetRateUtilization=");
                builder.append(this._packetRateUtilization);
                builder.append(", ");
            }
            if (this._powerUtilization != null) {
                builder.append("_powerUtilization=");
                builder.append(this._powerUtilization);
                builder.append(", ");
            }
            if (this._rIBUtilization != null) {
                builder.append("_rIBUtilization=");
                builder.append(this._rIBUtilization);
                builder.append(", ");
            }
            if (this._sFPortsBandwidthUtilization != null) {
                builder.append("_sFPortsBandwidthUtilization=");
                builder.append(this._sFPortsBandwidthUtilization);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

