/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.intel.params.xml.ns.sf.desc.mon.rpt.rev141105.sf.description.capabilities.ports.bandwidth;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4Address;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.MacAddress;
import org.opendaylight.yang.gen.v1.urn.intel.params.xml.ns.sf.desc.mon.rpt.rev141105.sf.description.capabilities.ports.bandwidth.PortBandwidth;
import org.opendaylight.yang.gen.v1.urn.intel.params.xml.ns.sf.desc.mon.rpt.rev141105.sf.description.capabilities.ports.bandwidth.PortBandwidthKey;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class PortBandwidthBuilder
implements Builder<PortBandwidth> {
    private Ipv4Address _ipaddress;
    private PortBandwidthKey _key;
    private MacAddress _macaddress;
    private Long _portId;
    private Long _supportedBandwidth;
    Map<Class<? extends Augmentation<PortBandwidth>>, Augmentation<PortBandwidth>> augmentation = Collections.emptyMap();

    public PortBandwidthBuilder() {
    }

    public PortBandwidthBuilder(PortBandwidth base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new PortBandwidthKey(base.getPortId());
            this._portId = base.getPortId();
        } else {
            this._key = base.getKey();
            this._portId = this._key.getPortId();
        }
        this._ipaddress = base.getIpaddress();
        this._macaddress = base.getMacaddress();
        this._supportedBandwidth = base.getSupportedBandwidth();
        if (base instanceof PortBandwidthImpl) {
            PortBandwidthImpl impl = (PortBandwidthImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<PortBandwidth>>, Augmentation<PortBandwidth>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<PortBandwidth>>, Augmentation<PortBandwidth>>(casted.augmentations());
        }
    }

    public Ipv4Address getIpaddress() {
        return this._ipaddress;
    }

    public PortBandwidthKey getKey() {
        return this._key;
    }

    public MacAddress getMacaddress() {
        return this._macaddress;
    }

    public Long getPortId() {
        return this._portId;
    }

    public Long getSupportedBandwidth() {
        return this._supportedBandwidth;
    }

    public <E extends Augmentation<PortBandwidth>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public PortBandwidthBuilder setIpaddress(Ipv4Address value) {
        this._ipaddress = value;
        return this;
    }

    public PortBandwidthBuilder setKey(PortBandwidthKey value) {
        this._key = value;
        return this;
    }

    public PortBandwidthBuilder setMacaddress(MacAddress value) {
        this._macaddress = value;
        return this;
    }

    private static void checkPortIdRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..4294967295]].", value));
    }

    public PortBandwidthBuilder setPortId(Long value) {
        if (value != null) {
            PortBandwidthBuilder.checkPortIdRange(value);
        }
        this._portId = value;
        return this;
    }

    private static void checkSupportedBandwidthRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..4294967295]].", value));
    }

    public PortBandwidthBuilder setSupportedBandwidth(Long value) {
        if (value != null) {
            PortBandwidthBuilder.checkSupportedBandwidthRange(value);
        }
        this._supportedBandwidth = value;
        return this;
    }

    public PortBandwidthBuilder addAugmentation(Class<? extends Augmentation<PortBandwidth>> augmentationType, Augmentation<PortBandwidth> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<PortBandwidth>>, Augmentation<PortBandwidth>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public PortBandwidthBuilder removeAugmentation(Class<? extends Augmentation<PortBandwidth>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public PortBandwidth build() {
        return new PortBandwidthImpl(this);
    }

    private static final class PortBandwidthImpl
    implements PortBandwidth {
        private final Ipv4Address _ipaddress;
        private final PortBandwidthKey _key;
        private final MacAddress _macaddress;
        private final Long _portId;
        private final Long _supportedBandwidth;
        private Map<Class<? extends Augmentation<PortBandwidth>>, Augmentation<PortBandwidth>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<PortBandwidth> getImplementedInterface() {
            return PortBandwidth.class;
        }

        private PortBandwidthImpl(PortBandwidthBuilder base) {
            if (base.getKey() == null) {
                this._key = new PortBandwidthKey(base.getPortId());
                this._portId = base.getPortId();
            } else {
                this._key = base.getKey();
                this._portId = this._key.getPortId();
            }
            this._ipaddress = base.getIpaddress();
            this._macaddress = base.getMacaddress();
            this._supportedBandwidth = base.getSupportedBandwidth();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<PortBandwidth>>, Augmentation<PortBandwidth>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<PortBandwidth>>, Augmentation<PortBandwidth>>(base.augmentation);
                }
            }
        }

        @Override
        public Ipv4Address getIpaddress() {
            return this._ipaddress;
        }

        @Override
        public PortBandwidthKey getKey() {
            return this._key;
        }

        @Override
        public MacAddress getMacaddress() {
            return this._macaddress;
        }

        @Override
        public Long getPortId() {
            return this._portId;
        }

        @Override
        public Long getSupportedBandwidth() {
            return this._supportedBandwidth;
        }

        public <E extends Augmentation<PortBandwidth>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._ipaddress);
            result = 31 * result + Objects.hashCode(this._key);
            result = 31 * result + Objects.hashCode(this._macaddress);
            result = 31 * result + Objects.hashCode(this._portId);
            result = 31 * result + Objects.hashCode(this._supportedBandwidth);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!PortBandwidth.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            PortBandwidth other = (PortBandwidth)obj;
            if (!Objects.equals(this._ipaddress, other.getIpaddress())) {
                return false;
            }
            if (!Objects.equals(this._key, other.getKey())) {
                return false;
            }
            if (!Objects.equals(this._macaddress, other.getMacaddress())) {
                return false;
            }
            if (!Objects.equals(this._portId, other.getPortId())) {
                return false;
            }
            if (!Objects.equals(this._supportedBandwidth, other.getSupportedBandwidth())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                PortBandwidthImpl otherImpl = (PortBandwidthImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<PortBandwidth>>, Augmentation<PortBandwidth>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "PortBandwidth [";
            StringBuilder builder = new StringBuilder(name);
            if (this._ipaddress != null) {
                builder.append("_ipaddress=");
                builder.append(this._ipaddress);
                builder.append(", ");
            }
            if (this._key != null) {
                builder.append("_key=");
                builder.append(this._key);
                builder.append(", ");
            }
            if (this._macaddress != null) {
                builder.append("_macaddress=");
                builder.append(this._macaddress);
                builder.append(", ");
            }
            if (this._portId != null) {
                builder.append("_portId=");
                builder.append(this._portId);
                builder.append(", ");
            }
            if (this._supportedBandwidth != null) {
                builder.append("_supportedBandwidth=");
                builder.append(this._supportedBandwidth);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

