/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.intel.params.xml.ns.sf.desc.mon.rpt.rev141105.sf.description;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.intel.params.xml.ns.sf.desc.mon.rpt.rev141105.sf.description.Capabilities;
import org.opendaylight.yang.gen.v1.urn.intel.params.xml.ns.sf.desc.mon.rpt.rev141105.sf.description.capabilities.PortsBandwidth;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class CapabilitiesBuilder
implements Builder<Capabilities> {
    private Long _fIBSize;
    private PortsBandwidth _portsBandwidth;
    private Long _rIBSize;
    private Long _supportedACLNumber;
    private Long _supportedBandwidth;
    private Long _supportedPacketRate;
    Map<Class<? extends Augmentation<Capabilities>>, Augmentation<Capabilities>> augmentation = Collections.emptyMap();

    public CapabilitiesBuilder() {
    }

    public CapabilitiesBuilder(Capabilities base) {
        AugmentationHolder casted;
        this._fIBSize = base.getFIBSize();
        this._portsBandwidth = base.getPortsBandwidth();
        this._rIBSize = base.getRIBSize();
        this._supportedACLNumber = base.getSupportedACLNumber();
        this._supportedBandwidth = base.getSupportedBandwidth();
        this._supportedPacketRate = base.getSupportedPacketRate();
        if (base instanceof CapabilitiesImpl) {
            CapabilitiesImpl impl = (CapabilitiesImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Capabilities>>, Augmentation<Capabilities>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Capabilities>>, Augmentation<Capabilities>>(casted.augmentations());
        }
    }

    public Long getFIBSize() {
        return this._fIBSize;
    }

    public PortsBandwidth getPortsBandwidth() {
        return this._portsBandwidth;
    }

    public Long getRIBSize() {
        return this._rIBSize;
    }

    public Long getSupportedACLNumber() {
        return this._supportedACLNumber;
    }

    public Long getSupportedBandwidth() {
        return this._supportedBandwidth;
    }

    public Long getSupportedPacketRate() {
        return this._supportedPacketRate;
    }

    public <E extends Augmentation<Capabilities>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    private static void checkFIBSizeRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..4294967295]].", value));
    }

    public CapabilitiesBuilder setFIBSize(Long value) {
        if (value != null) {
            CapabilitiesBuilder.checkFIBSizeRange(value);
        }
        this._fIBSize = value;
        return this;
    }

    public CapabilitiesBuilder setPortsBandwidth(PortsBandwidth value) {
        this._portsBandwidth = value;
        return this;
    }

    private static void checkRIBSizeRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..4294967295]].", value));
    }

    public CapabilitiesBuilder setRIBSize(Long value) {
        if (value != null) {
            CapabilitiesBuilder.checkRIBSizeRange(value);
        }
        this._rIBSize = value;
        return this;
    }

    private static void checkSupportedACLNumberRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..4294967295]].", value));
    }

    public CapabilitiesBuilder setSupportedACLNumber(Long value) {
        if (value != null) {
            CapabilitiesBuilder.checkSupportedACLNumberRange(value);
        }
        this._supportedACLNumber = value;
        return this;
    }

    private static void checkSupportedBandwidthRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..4294967295]].", value));
    }

    public CapabilitiesBuilder setSupportedBandwidth(Long value) {
        if (value != null) {
            CapabilitiesBuilder.checkSupportedBandwidthRange(value);
        }
        this._supportedBandwidth = value;
        return this;
    }

    private static void checkSupportedPacketRateRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..4294967295]].", value));
    }

    public CapabilitiesBuilder setSupportedPacketRate(Long value) {
        if (value != null) {
            CapabilitiesBuilder.checkSupportedPacketRateRange(value);
        }
        this._supportedPacketRate = value;
        return this;
    }

    public CapabilitiesBuilder addAugmentation(Class<? extends Augmentation<Capabilities>> augmentationType, Augmentation<Capabilities> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Capabilities>>, Augmentation<Capabilities>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public CapabilitiesBuilder removeAugmentation(Class<? extends Augmentation<Capabilities>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Capabilities build() {
        return new CapabilitiesImpl(this);
    }

    private static final class CapabilitiesImpl
    implements Capabilities {
        private final Long _fIBSize;
        private final PortsBandwidth _portsBandwidth;
        private final Long _rIBSize;
        private final Long _supportedACLNumber;
        private final Long _supportedBandwidth;
        private final Long _supportedPacketRate;
        private Map<Class<? extends Augmentation<Capabilities>>, Augmentation<Capabilities>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<Capabilities> getImplementedInterface() {
            return Capabilities.class;
        }

        private CapabilitiesImpl(CapabilitiesBuilder base) {
            this._fIBSize = base.getFIBSize();
            this._portsBandwidth = base.getPortsBandwidth();
            this._rIBSize = base.getRIBSize();
            this._supportedACLNumber = base.getSupportedACLNumber();
            this._supportedBandwidth = base.getSupportedBandwidth();
            this._supportedPacketRate = base.getSupportedPacketRate();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<Capabilities>>, Augmentation<Capabilities>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<Capabilities>>, Augmentation<Capabilities>>(base.augmentation);
                }
            }
        }

        @Override
        public Long getFIBSize() {
            return this._fIBSize;
        }

        @Override
        public PortsBandwidth getPortsBandwidth() {
            return this._portsBandwidth;
        }

        @Override
        public Long getRIBSize() {
            return this._rIBSize;
        }

        @Override
        public Long getSupportedACLNumber() {
            return this._supportedACLNumber;
        }

        @Override
        public Long getSupportedBandwidth() {
            return this._supportedBandwidth;
        }

        @Override
        public Long getSupportedPacketRate() {
            return this._supportedPacketRate;
        }

        public <E extends Augmentation<Capabilities>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._fIBSize);
            result = 31 * result + Objects.hashCode(this._portsBandwidth);
            result = 31 * result + Objects.hashCode(this._rIBSize);
            result = 31 * result + Objects.hashCode(this._supportedACLNumber);
            result = 31 * result + Objects.hashCode(this._supportedBandwidth);
            result = 31 * result + Objects.hashCode(this._supportedPacketRate);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Capabilities.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Capabilities other = (Capabilities)obj;
            if (!Objects.equals(this._fIBSize, other.getFIBSize())) {
                return false;
            }
            if (!Objects.equals(this._portsBandwidth, other.getPortsBandwidth())) {
                return false;
            }
            if (!Objects.equals(this._rIBSize, other.getRIBSize())) {
                return false;
            }
            if (!Objects.equals(this._supportedACLNumber, other.getSupportedACLNumber())) {
                return false;
            }
            if (!Objects.equals(this._supportedBandwidth, other.getSupportedBandwidth())) {
                return false;
            }
            if (!Objects.equals(this._supportedPacketRate, other.getSupportedPacketRate())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                CapabilitiesImpl otherImpl = (CapabilitiesImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Capabilities>>, Augmentation<Capabilities>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "Capabilities [";
            StringBuilder builder = new StringBuilder(name);
            if (this._fIBSize != null) {
                builder.append("_fIBSize=");
                builder.append(this._fIBSize);
                builder.append(", ");
            }
            if (this._portsBandwidth != null) {
                builder.append("_portsBandwidth=");
                builder.append(this._portsBandwidth);
                builder.append(", ");
            }
            if (this._rIBSize != null) {
                builder.append("_rIBSize=");
                builder.append(this._rIBSize);
                builder.append(", ");
            }
            if (this._supportedACLNumber != null) {
                builder.append("_supportedACLNumber=");
                builder.append(this._supportedACLNumber);
                builder.append(", ");
            }
            if (this._supportedBandwidth != null) {
                builder.append("_supportedBandwidth=");
                builder.append(this._supportedBandwidth);
                builder.append(", ");
            }
            if (this._supportedPacketRate != null) {
                builder.append("_supportedPacketRate=");
                builder.append(this._supportedPacketRate);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

