/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.intel.params.xml.ns.sf.desc.mon.rpt.rev141105;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.intel.params.xml.ns.sf.desc.mon.rpt.rev141105.ServiceFunction;
import org.opendaylight.yang.gen.v1.urn.intel.params.xml.ns.sf.desc.mon.rpt.rev141105.service.function.DescriptionInfo;
import org.opendaylight.yang.gen.v1.urn.intel.params.xml.ns.sf.desc.mon.rpt.rev141105.service.function.MonitoringInfo;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class ServiceFunctionBuilder
implements Builder<ServiceFunction> {
    private DescriptionInfo _descriptionInfo;
    private MonitoringInfo _monitoringInfo;
    Map<Class<? extends Augmentation<ServiceFunction>>, Augmentation<ServiceFunction>> augmentation = Collections.emptyMap();

    public ServiceFunctionBuilder() {
    }

    public ServiceFunctionBuilder(ServiceFunction base) {
        AugmentationHolder casted;
        this._descriptionInfo = base.getDescriptionInfo();
        this._monitoringInfo = base.getMonitoringInfo();
        if (base instanceof ServiceFunctionImpl) {
            ServiceFunctionImpl impl = (ServiceFunctionImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<ServiceFunction>>, Augmentation<ServiceFunction>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ServiceFunction>>, Augmentation<ServiceFunction>>(casted.augmentations());
        }
    }

    public DescriptionInfo getDescriptionInfo() {
        return this._descriptionInfo;
    }

    public MonitoringInfo getMonitoringInfo() {
        return this._monitoringInfo;
    }

    public <E extends Augmentation<ServiceFunction>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public ServiceFunctionBuilder setDescriptionInfo(DescriptionInfo value) {
        this._descriptionInfo = value;
        return this;
    }

    public ServiceFunctionBuilder setMonitoringInfo(MonitoringInfo value) {
        this._monitoringInfo = value;
        return this;
    }

    public ServiceFunctionBuilder addAugmentation(Class<? extends Augmentation<ServiceFunction>> augmentationType, Augmentation<ServiceFunction> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ServiceFunction>>, Augmentation<ServiceFunction>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public ServiceFunctionBuilder removeAugmentation(Class<? extends Augmentation<ServiceFunction>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public ServiceFunction build() {
        return new ServiceFunctionImpl(this);
    }

    private static final class ServiceFunctionImpl
    implements ServiceFunction {
        private final DescriptionInfo _descriptionInfo;
        private final MonitoringInfo _monitoringInfo;
        private Map<Class<? extends Augmentation<ServiceFunction>>, Augmentation<ServiceFunction>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<ServiceFunction> getImplementedInterface() {
            return ServiceFunction.class;
        }

        private ServiceFunctionImpl(ServiceFunctionBuilder base) {
            this._descriptionInfo = base.getDescriptionInfo();
            this._monitoringInfo = base.getMonitoringInfo();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<ServiceFunction>>, Augmentation<ServiceFunction>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<ServiceFunction>>, Augmentation<ServiceFunction>>(base.augmentation);
                }
            }
        }

        @Override
        public DescriptionInfo getDescriptionInfo() {
            return this._descriptionInfo;
        }

        @Override
        public MonitoringInfo getMonitoringInfo() {
            return this._monitoringInfo;
        }

        public <E extends Augmentation<ServiceFunction>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._descriptionInfo);
            result = 31 * result + Objects.hashCode(this._monitoringInfo);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!ServiceFunction.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            ServiceFunction other = (ServiceFunction)obj;
            if (!Objects.equals(this._descriptionInfo, other.getDescriptionInfo())) {
                return false;
            }
            if (!Objects.equals(this._monitoringInfo, other.getMonitoringInfo())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                ServiceFunctionImpl otherImpl = (ServiceFunctionImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<ServiceFunction>>, Augmentation<ServiceFunction>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "ServiceFunction [";
            StringBuilder builder = new StringBuilder(name);
            if (this._descriptionInfo != null) {
                builder.append("_descriptionInfo=");
                builder.append(this._descriptionInfo);
                builder.append(", ");
            }
            if (this._monitoringInfo != null) {
                builder.append("_monitoringInfo=");
                builder.append(this._monitoringInfo);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

