/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.intel.params.xml.ns.sf.desc.mon.rev141201.service.functions.state.service.function.state.sfc.sf.desc.mon;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddress;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.PortNumber;
import org.opendaylight.yang.gen.v1.urn.intel.params.xml.ns.sf.desc.mon.rev141201.service.functions.state.service.function.state.sfc.sf.desc.mon.DescriptionInfo;
import org.opendaylight.yang.gen.v1.urn.intel.params.xml.ns.sf.desc.mon.rpt.rev141105.SFDescription;
import org.opendaylight.yang.gen.v1.urn.intel.params.xml.ns.sf.desc.mon.rpt.rev141105.sf.description.Capabilities;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class DescriptionInfoBuilder
implements Builder<DescriptionInfo> {
    private Capabilities _capabilities;
    private IpAddress _dataPlaneIp;
    private PortNumber _dataPlanePort;
    private Long _numberOfDataports;
    private String _type;
    Map<Class<? extends Augmentation<DescriptionInfo>>, Augmentation<DescriptionInfo>> augmentation = Collections.emptyMap();

    public DescriptionInfoBuilder() {
    }

    public DescriptionInfoBuilder(SFDescription arg) {
        this._dataPlaneIp = arg.getDataPlaneIp();
        this._dataPlanePort = arg.getDataPlanePort();
        this._type = arg.getType();
        this._numberOfDataports = arg.getNumberOfDataports();
        this._capabilities = arg.getCapabilities();
    }

    public DescriptionInfoBuilder(DescriptionInfo base) {
        AugmentationHolder casted;
        this._capabilities = base.getCapabilities();
        this._dataPlaneIp = base.getDataPlaneIp();
        this._dataPlanePort = base.getDataPlanePort();
        this._numberOfDataports = base.getNumberOfDataports();
        this._type = base.getType();
        if (base instanceof DescriptionInfoImpl) {
            DescriptionInfoImpl impl = (DescriptionInfoImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<DescriptionInfo>>, Augmentation<DescriptionInfo>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<DescriptionInfo>>, Augmentation<DescriptionInfo>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof SFDescription) {
            this._dataPlaneIp = ((SFDescription)arg).getDataPlaneIp();
            this._dataPlanePort = ((SFDescription)arg).getDataPlanePort();
            this._type = ((SFDescription)arg).getType();
            this._numberOfDataports = ((SFDescription)arg).getNumberOfDataports();
            this._capabilities = ((SFDescription)arg).getCapabilities();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.intel.params.xml.ns.sf.desc.mon.rpt.rev141105.SFDescription] \nbut was: " + arg);
        }
    }

    public Capabilities getCapabilities() {
        return this._capabilities;
    }

    public IpAddress getDataPlaneIp() {
        return this._dataPlaneIp;
    }

    public PortNumber getDataPlanePort() {
        return this._dataPlanePort;
    }

    public Long getNumberOfDataports() {
        return this._numberOfDataports;
    }

    public String getType() {
        return this._type;
    }

    public <E extends Augmentation<DescriptionInfo>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public DescriptionInfoBuilder setCapabilities(Capabilities value) {
        this._capabilities = value;
        return this;
    }

    public DescriptionInfoBuilder setDataPlaneIp(IpAddress value) {
        this._dataPlaneIp = value;
        return this;
    }

    public DescriptionInfoBuilder setDataPlanePort(PortNumber value) {
        this._dataPlanePort = value;
        return this;
    }

    private static void checkNumberOfDataportsRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..4294967295]].", value));
    }

    public DescriptionInfoBuilder setNumberOfDataports(Long value) {
        if (value != null) {
            DescriptionInfoBuilder.checkNumberOfDataportsRange(value);
        }
        this._numberOfDataports = value;
        return this;
    }

    public DescriptionInfoBuilder setType(String value) {
        this._type = value;
        return this;
    }

    public DescriptionInfoBuilder addAugmentation(Class<? extends Augmentation<DescriptionInfo>> augmentationType, Augmentation<DescriptionInfo> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<DescriptionInfo>>, Augmentation<DescriptionInfo>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public DescriptionInfoBuilder removeAugmentation(Class<? extends Augmentation<DescriptionInfo>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public DescriptionInfo build() {
        return new DescriptionInfoImpl(this);
    }

    private static final class DescriptionInfoImpl
    implements DescriptionInfo {
        private final Capabilities _capabilities;
        private final IpAddress _dataPlaneIp;
        private final PortNumber _dataPlanePort;
        private final Long _numberOfDataports;
        private final String _type;
        private Map<Class<? extends Augmentation<DescriptionInfo>>, Augmentation<DescriptionInfo>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<DescriptionInfo> getImplementedInterface() {
            return DescriptionInfo.class;
        }

        private DescriptionInfoImpl(DescriptionInfoBuilder base) {
            this._capabilities = base.getCapabilities();
            this._dataPlaneIp = base.getDataPlaneIp();
            this._dataPlanePort = base.getDataPlanePort();
            this._numberOfDataports = base.getNumberOfDataports();
            this._type = base.getType();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<DescriptionInfo>>, Augmentation<DescriptionInfo>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<DescriptionInfo>>, Augmentation<DescriptionInfo>>(base.augmentation);
                }
            }
        }

        @Override
        public Capabilities getCapabilities() {
            return this._capabilities;
        }

        @Override
        public IpAddress getDataPlaneIp() {
            return this._dataPlaneIp;
        }

        @Override
        public PortNumber getDataPlanePort() {
            return this._dataPlanePort;
        }

        @Override
        public Long getNumberOfDataports() {
            return this._numberOfDataports;
        }

        @Override
        public String getType() {
            return this._type;
        }

        public <E extends Augmentation<DescriptionInfo>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._capabilities);
            result = 31 * result + Objects.hashCode(this._dataPlaneIp);
            result = 31 * result + Objects.hashCode(this._dataPlanePort);
            result = 31 * result + Objects.hashCode(this._numberOfDataports);
            result = 31 * result + Objects.hashCode(this._type);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!DescriptionInfo.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            DescriptionInfo other = (DescriptionInfo)obj;
            if (!Objects.equals(this._capabilities, other.getCapabilities())) {
                return false;
            }
            if (!Objects.equals(this._dataPlaneIp, other.getDataPlaneIp())) {
                return false;
            }
            if (!Objects.equals(this._dataPlanePort, other.getDataPlanePort())) {
                return false;
            }
            if (!Objects.equals(this._numberOfDataports, other.getNumberOfDataports())) {
                return false;
            }
            if (!Objects.equals(this._type, other.getType())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                DescriptionInfoImpl otherImpl = (DescriptionInfoImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<DescriptionInfo>>, Augmentation<DescriptionInfo>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "DescriptionInfo [";
            StringBuilder builder = new StringBuilder(name);
            if (this._capabilities != null) {
                builder.append("_capabilities=");
                builder.append(this._capabilities);
                builder.append(", ");
            }
            if (this._dataPlaneIp != null) {
                builder.append("_dataPlaneIp=");
                builder.append(this._dataPlaneIp);
                builder.append(", ");
            }
            if (this._dataPlanePort != null) {
                builder.append("_dataPlanePort=");
                builder.append(this._dataPlanePort);
                builder.append(", ");
            }
            if (this._numberOfDataports != null) {
                builder.append("_numberOfDataports=");
                builder.append(this._numberOfDataports);
                builder.append(", ");
            }
            if (this._type != null) {
                builder.append("_type=");
                builder.append(this._type);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

