/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ipfix.application.information.rev150410.application.id.dictionary;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ipfix.application.information.rev150410.application.id.dictionary.ApplicationId;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ipfix.application.information.rev150410.application.id.dictionary.ApplicationIdKey;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class ApplicationIdBuilder
implements Builder<ApplicationId> {
    private String _applicationCategoryName;
    private String _applicationDescription;
    private String _applicationGroupName;
    private String _applicationName;
    private String _applicationSubCategoryName;
    private Short _classId;
    private ApplicationIdKey _key;
    private Long _pen;
    private Long _selectorId;
    Map<Class<? extends Augmentation<ApplicationId>>, Augmentation<ApplicationId>> augmentation = Collections.emptyMap();

    public ApplicationIdBuilder() {
    }

    public ApplicationIdBuilder(ApplicationId base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new ApplicationIdKey(base.getApplicationName());
            this._applicationName = base.getApplicationName();
        } else {
            this._key = base.getKey();
            this._applicationName = this._key.getApplicationName();
        }
        this._applicationCategoryName = base.getApplicationCategoryName();
        this._applicationDescription = base.getApplicationDescription();
        this._applicationGroupName = base.getApplicationGroupName();
        this._applicationSubCategoryName = base.getApplicationSubCategoryName();
        this._classId = base.getClassId();
        this._pen = base.getPen();
        this._selectorId = base.getSelectorId();
        if (base instanceof ApplicationIdImpl) {
            ApplicationIdImpl impl = (ApplicationIdImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<ApplicationId>>, Augmentation<ApplicationId>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ApplicationId>>, Augmentation<ApplicationId>>(casted.augmentations());
        }
    }

    public String getApplicationCategoryName() {
        return this._applicationCategoryName;
    }

    public String getApplicationDescription() {
        return this._applicationDescription;
    }

    public String getApplicationGroupName() {
        return this._applicationGroupName;
    }

    public String getApplicationName() {
        return this._applicationName;
    }

    public String getApplicationSubCategoryName() {
        return this._applicationSubCategoryName;
    }

    public Short getClassId() {
        return this._classId;
    }

    public ApplicationIdKey getKey() {
        return this._key;
    }

    public Long getPen() {
        return this._pen;
    }

    public Long getSelectorId() {
        return this._selectorId;
    }

    public <E extends Augmentation<ApplicationId>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public ApplicationIdBuilder setApplicationCategoryName(String value) {
        this._applicationCategoryName = value;
        return this;
    }

    public ApplicationIdBuilder setApplicationDescription(String value) {
        this._applicationDescription = value;
        return this;
    }

    public ApplicationIdBuilder setApplicationGroupName(String value) {
        this._applicationGroupName = value;
        return this;
    }

    public ApplicationIdBuilder setApplicationName(String value) {
        this._applicationName = value;
        return this;
    }

    public ApplicationIdBuilder setApplicationSubCategoryName(String value) {
        this._applicationSubCategoryName = value;
        return this;
    }

    private static void checkClassIdRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..255]].", value));
    }

    public ApplicationIdBuilder setClassId(Short value) {
        if (value != null) {
            ApplicationIdBuilder.checkClassIdRange(value);
        }
        this._classId = value;
        return this;
    }

    public ApplicationIdBuilder setKey(ApplicationIdKey value) {
        this._key = value;
        return this;
    }

    private static void checkPenRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..4294967295]].", value));
    }

    public ApplicationIdBuilder setPen(Long value) {
        if (value != null) {
            ApplicationIdBuilder.checkPenRange(value);
        }
        this._pen = value;
        return this;
    }

    private static void checkSelectorIdRange(long value) {
        if (value >= 0L && value <= 0x1000000L) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..16777216]].", value));
    }

    public ApplicationIdBuilder setSelectorId(Long value) {
        if (value != null) {
            ApplicationIdBuilder.checkSelectorIdRange(value);
        }
        this._selectorId = value;
        return this;
    }

    public ApplicationIdBuilder addAugmentation(Class<? extends Augmentation<ApplicationId>> augmentationType, Augmentation<ApplicationId> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ApplicationId>>, Augmentation<ApplicationId>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public ApplicationIdBuilder removeAugmentation(Class<? extends Augmentation<ApplicationId>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public ApplicationId build() {
        return new ApplicationIdImpl(this);
    }

    private static final class ApplicationIdImpl
    implements ApplicationId {
        private final String _applicationCategoryName;
        private final String _applicationDescription;
        private final String _applicationGroupName;
        private final String _applicationName;
        private final String _applicationSubCategoryName;
        private final Short _classId;
        private final ApplicationIdKey _key;
        private final Long _pen;
        private final Long _selectorId;
        private Map<Class<? extends Augmentation<ApplicationId>>, Augmentation<ApplicationId>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<ApplicationId> getImplementedInterface() {
            return ApplicationId.class;
        }

        private ApplicationIdImpl(ApplicationIdBuilder base) {
            if (base.getKey() == null) {
                this._key = new ApplicationIdKey(base.getApplicationName());
                this._applicationName = base.getApplicationName();
            } else {
                this._key = base.getKey();
                this._applicationName = this._key.getApplicationName();
            }
            this._applicationCategoryName = base.getApplicationCategoryName();
            this._applicationDescription = base.getApplicationDescription();
            this._applicationGroupName = base.getApplicationGroupName();
            this._applicationSubCategoryName = base.getApplicationSubCategoryName();
            this._classId = base.getClassId();
            this._pen = base.getPen();
            this._selectorId = base.getSelectorId();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<ApplicationId>>, Augmentation<ApplicationId>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<ApplicationId>>, Augmentation<ApplicationId>>(base.augmentation);
                }
            }
        }

        @Override
        public String getApplicationCategoryName() {
            return this._applicationCategoryName;
        }

        @Override
        public String getApplicationDescription() {
            return this._applicationDescription;
        }

        @Override
        public String getApplicationGroupName() {
            return this._applicationGroupName;
        }

        @Override
        public String getApplicationName() {
            return this._applicationName;
        }

        @Override
        public String getApplicationSubCategoryName() {
            return this._applicationSubCategoryName;
        }

        @Override
        public Short getClassId() {
            return this._classId;
        }

        @Override
        public ApplicationIdKey getKey() {
            return this._key;
        }

        @Override
        public Long getPen() {
            return this._pen;
        }

        @Override
        public Long getSelectorId() {
            return this._selectorId;
        }

        public <E extends Augmentation<ApplicationId>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._applicationCategoryName);
            result = 31 * result + Objects.hashCode(this._applicationDescription);
            result = 31 * result + Objects.hashCode(this._applicationGroupName);
            result = 31 * result + Objects.hashCode(this._applicationName);
            result = 31 * result + Objects.hashCode(this._applicationSubCategoryName);
            result = 31 * result + Objects.hashCode(this._classId);
            result = 31 * result + Objects.hashCode(this._key);
            result = 31 * result + Objects.hashCode(this._pen);
            result = 31 * result + Objects.hashCode(this._selectorId);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!ApplicationId.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            ApplicationId other = (ApplicationId)obj;
            if (!Objects.equals(this._applicationCategoryName, other.getApplicationCategoryName())) {
                return false;
            }
            if (!Objects.equals(this._applicationDescription, other.getApplicationDescription())) {
                return false;
            }
            if (!Objects.equals(this._applicationGroupName, other.getApplicationGroupName())) {
                return false;
            }
            if (!Objects.equals(this._applicationName, other.getApplicationName())) {
                return false;
            }
            if (!Objects.equals(this._applicationSubCategoryName, other.getApplicationSubCategoryName())) {
                return false;
            }
            if (!Objects.equals(this._classId, other.getClassId())) {
                return false;
            }
            if (!Objects.equals(this._key, other.getKey())) {
                return false;
            }
            if (!Objects.equals(this._pen, other.getPen())) {
                return false;
            }
            if (!Objects.equals(this._selectorId, other.getSelectorId())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                ApplicationIdImpl otherImpl = (ApplicationIdImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<ApplicationId>>, Augmentation<ApplicationId>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "ApplicationId [";
            StringBuilder builder = new StringBuilder(name);
            if (this._applicationCategoryName != null) {
                builder.append("_applicationCategoryName=");
                builder.append(this._applicationCategoryName);
                builder.append(", ");
            }
            if (this._applicationDescription != null) {
                builder.append("_applicationDescription=");
                builder.append(this._applicationDescription);
                builder.append(", ");
            }
            if (this._applicationGroupName != null) {
                builder.append("_applicationGroupName=");
                builder.append(this._applicationGroupName);
                builder.append(", ");
            }
            if (this._applicationName != null) {
                builder.append("_applicationName=");
                builder.append(this._applicationName);
                builder.append(", ");
            }
            if (this._applicationSubCategoryName != null) {
                builder.append("_applicationSubCategoryName=");
                builder.append(this._applicationSubCategoryName);
                builder.append(", ");
            }
            if (this._classId != null) {
                builder.append("_classId=");
                builder.append(this._classId);
                builder.append(", ");
            }
            if (this._key != null) {
                builder.append("_key=");
                builder.append(this._key);
                builder.append(", ");
            }
            if (this._pen != null) {
                builder.append("_pen=");
                builder.append(this._pen);
                builder.append(", ");
            }
            if (this._selectorId != null) {
                builder.append("_selectorId=");
                builder.append(this._selectorId);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

