/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ipfix.application.information.rev150410._class.id.dictionary;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ipfix.application.information.rev150410._class.id.dictionary.ClassId;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ipfix.application.information.rev150410._class.id.dictionary.ClassIdKey;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class ClassIdBuilder
implements Builder<ClassId> {
    private String _description;
    private Short _id;
    private ClassIdKey _key;
    private String _name;
    Map<Class<? extends Augmentation<ClassId>>, Augmentation<ClassId>> augmentation = Collections.emptyMap();

    public ClassIdBuilder() {
    }

    public ClassIdBuilder(ClassId base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new ClassIdKey(base.getName());
            this._name = base.getName();
        } else {
            this._key = base.getKey();
            this._name = this._key.getName();
        }
        this._description = base.getDescription();
        this._id = base.getId();
        if (base instanceof ClassIdImpl) {
            ClassIdImpl impl = (ClassIdImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<ClassId>>, Augmentation<ClassId>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ClassId>>, Augmentation<ClassId>>(casted.augmentations());
        }
    }

    public String getDescription() {
        return this._description;
    }

    public Short getId() {
        return this._id;
    }

    public ClassIdKey getKey() {
        return this._key;
    }

    public String getName() {
        return this._name;
    }

    public <E extends Augmentation<ClassId>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public ClassIdBuilder setDescription(String value) {
        this._description = value;
        return this;
    }

    private static void checkIdRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..255]].", value));
    }

    public ClassIdBuilder setId(Short value) {
        if (value != null) {
            ClassIdBuilder.checkIdRange(value);
        }
        this._id = value;
        return this;
    }

    public ClassIdBuilder setKey(ClassIdKey value) {
        this._key = value;
        return this;
    }

    public ClassIdBuilder setName(String value) {
        this._name = value;
        return this;
    }

    public ClassIdBuilder addAugmentation(Class<? extends Augmentation<ClassId>> augmentationType, Augmentation<ClassId> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ClassId>>, Augmentation<ClassId>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public ClassIdBuilder removeAugmentation(Class<? extends Augmentation<ClassId>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public ClassId build() {
        return new ClassIdImpl(this);
    }

    private static final class ClassIdImpl
    implements ClassId {
        private final String _description;
        private final Short _id;
        private final ClassIdKey _key;
        private final String _name;
        private Map<Class<? extends Augmentation<ClassId>>, Augmentation<ClassId>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<ClassId> getImplementedInterface() {
            return ClassId.class;
        }

        private ClassIdImpl(ClassIdBuilder base) {
            if (base.getKey() == null) {
                this._key = new ClassIdKey(base.getName());
                this._name = base.getName();
            } else {
                this._key = base.getKey();
                this._name = this._key.getName();
            }
            this._description = base.getDescription();
            this._id = base.getId();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<ClassId>>, Augmentation<ClassId>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<ClassId>>, Augmentation<ClassId>>(base.augmentation);
                }
            }
        }

        @Override
        public String getDescription() {
            return this._description;
        }

        @Override
        public Short getId() {
            return this._id;
        }

        @Override
        public ClassIdKey getKey() {
            return this._key;
        }

        @Override
        public String getName() {
            return this._name;
        }

        public <E extends Augmentation<ClassId>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._description);
            result = 31 * result + Objects.hashCode(this._id);
            result = 31 * result + Objects.hashCode(this._key);
            result = 31 * result + Objects.hashCode(this._name);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!ClassId.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            ClassId other = (ClassId)obj;
            if (!Objects.equals(this._description, other.getDescription())) {
                return false;
            }
            if (!Objects.equals(this._id, other.getId())) {
                return false;
            }
            if (!Objects.equals(this._key, other.getKey())) {
                return false;
            }
            if (!Objects.equals(this._name, other.getName())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                ClassIdImpl otherImpl = (ClassIdImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<ClassId>>, Augmentation<ClassId>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "ClassId [";
            StringBuilder builder = new StringBuilder(name);
            if (this._description != null) {
                builder.append("_description=");
                builder.append(this._description);
                builder.append(", ");
            }
            if (this._id != null) {
                builder.append("_id=");
                builder.append(this._id);
                builder.append(", ");
            }
            if (this._key != null) {
                builder.append("_key=");
                builder.append(this._key);
                builder.append(", ");
            }
            if (this._name != null) {
                builder.append("_name=");
                builder.append(this._name);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

