/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.List;
import java.util.regex.Pattern;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.ObjectIdentifier;

public class ObjectIdentifier128
extends ObjectIdentifier
implements Serializable {
    private static final long serialVersionUID = 1412134080859977896L;
    private static final Pattern[] patterns;
    public static final List<String> PATTERN_CONSTANTS;

    @ConstructorProperties(value={"value"})
    public ObjectIdentifier128(String _value) {
        super(_value);
        Preconditions.checkNotNull((Object)_value, (Object)"Supplied value may not be null");
        for (Pattern p : patterns) {
            Preconditions.checkArgument((boolean)p.matcher(_value).matches(), (String)"Supplied value \"%s\" does not match required pattern \"%s\"", (Object)_value, (Object)p);
        }
    }

    public ObjectIdentifier128(ObjectIdentifier128 source) {
        super(source);
    }

    public ObjectIdentifier128(ObjectIdentifier source) {
        super(source);
    }

    public static ObjectIdentifier128 getDefaultInstance(String defaultValue) {
        return new ObjectIdentifier128(defaultValue);
    }

    static {
        PATTERN_CONSTANTS = ImmutableList.of((Object)"^(?:\\d*(\\.\\d*){1,127})$");
        Pattern[] a = new Pattern[PATTERN_CONSTANTS.size()];
        int i = 0;
        for (String regEx : PATTERN_CONSTANTS) {
            a[i++] = Pattern.compile(regEx);
        }
        patterns = a;
    }
}

