/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.packet.fields.rev160218.acl.transport.header.fields;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.PortNumber;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.packet.fields.rev160218.acl.transport.header.fields.DestinationPortRange;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class DestinationPortRangeBuilder
implements Builder<DestinationPortRange> {
    private PortNumber _lowerPort;
    private PortNumber _upperPort;
    Map<Class<? extends Augmentation<DestinationPortRange>>, Augmentation<DestinationPortRange>> augmentation = Collections.emptyMap();

    public DestinationPortRangeBuilder() {
    }

    public DestinationPortRangeBuilder(DestinationPortRange base) {
        AugmentationHolder casted;
        this._lowerPort = base.getLowerPort();
        this._upperPort = base.getUpperPort();
        if (base instanceof DestinationPortRangeImpl) {
            DestinationPortRangeImpl impl = (DestinationPortRangeImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<DestinationPortRange>>, Augmentation<DestinationPortRange>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<DestinationPortRange>>, Augmentation<DestinationPortRange>>(casted.augmentations());
        }
    }

    public PortNumber getLowerPort() {
        return this._lowerPort;
    }

    public PortNumber getUpperPort() {
        return this._upperPort;
    }

    public <E extends Augmentation<DestinationPortRange>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public DestinationPortRangeBuilder setLowerPort(PortNumber value) {
        this._lowerPort = value;
        return this;
    }

    public DestinationPortRangeBuilder setUpperPort(PortNumber value) {
        this._upperPort = value;
        return this;
    }

    public DestinationPortRangeBuilder addAugmentation(Class<? extends Augmentation<DestinationPortRange>> augmentationType, Augmentation<DestinationPortRange> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<DestinationPortRange>>, Augmentation<DestinationPortRange>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public DestinationPortRangeBuilder removeAugmentation(Class<? extends Augmentation<DestinationPortRange>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public DestinationPortRange build() {
        return new DestinationPortRangeImpl(this);
    }

    private static final class DestinationPortRangeImpl
    implements DestinationPortRange {
        private final PortNumber _lowerPort;
        private final PortNumber _upperPort;
        private Map<Class<? extends Augmentation<DestinationPortRange>>, Augmentation<DestinationPortRange>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<DestinationPortRange> getImplementedInterface() {
            return DestinationPortRange.class;
        }

        private DestinationPortRangeImpl(DestinationPortRangeBuilder base) {
            this._lowerPort = base.getLowerPort();
            this._upperPort = base.getUpperPort();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<DestinationPortRange>>, Augmentation<DestinationPortRange>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<DestinationPortRange>>, Augmentation<DestinationPortRange>>(base.augmentation);
                }
            }
        }

        @Override
        public PortNumber getLowerPort() {
            return this._lowerPort;
        }

        @Override
        public PortNumber getUpperPort() {
            return this._upperPort;
        }

        public <E extends Augmentation<DestinationPortRange>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._lowerPort);
            result = 31 * result + Objects.hashCode(this._upperPort);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!DestinationPortRange.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            DestinationPortRange other = (DestinationPortRange)obj;
            if (!Objects.equals(this._lowerPort, other.getLowerPort())) {
                return false;
            }
            if (!Objects.equals(this._upperPort, other.getUpperPort())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                DestinationPortRangeImpl otherImpl = (DestinationPortRangeImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<DestinationPortRange>>, Augmentation<DestinationPortRange>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "DestinationPortRange [";
            StringBuilder builder = new StringBuilder(name);
            if (this._lowerPort != null) {
                builder.append("_lowerPort=");
                builder.append(this._lowerPort);
                builder.append(", ");
            }
            if (this._upperPort != null) {
                builder.append("_upperPort=");
                builder.append(this._upperPort);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

