/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.ip.rev140616.interfaces.state._interface.ipv6;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv6AddressNoZone;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.ip.rev140616.NeighborOrigin;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.ip.rev140616.interfaces.state._interface.ipv6.Neighbor;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.ip.rev140616.interfaces.state._interface.ipv6.NeighborKey;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.PhysAddress;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class NeighborBuilder
implements Builder<Neighbor> {
    private Ipv6AddressNoZone _ip;
    private NeighborKey _key;
    private PhysAddress _linkLayerAddress;
    private NeighborOrigin _origin;
    private Neighbor.State _state;
    private Boolean _isRouter;
    Map<Class<? extends Augmentation<Neighbor>>, Augmentation<Neighbor>> augmentation = Collections.emptyMap();

    public NeighborBuilder() {
    }

    public NeighborBuilder(Neighbor base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new NeighborKey(base.getIp());
            this._ip = base.getIp();
        } else {
            this._key = base.getKey();
            this._ip = this._key.getIp();
        }
        this._linkLayerAddress = base.getLinkLayerAddress();
        this._origin = base.getOrigin();
        this._state = base.getState();
        this._isRouter = base.isIsRouter();
        if (base instanceof NeighborImpl) {
            NeighborImpl impl = (NeighborImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Neighbor>>, Augmentation<Neighbor>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Neighbor>>, Augmentation<Neighbor>>(casted.augmentations());
        }
    }

    public Ipv6AddressNoZone getIp() {
        return this._ip;
    }

    public NeighborKey getKey() {
        return this._key;
    }

    public PhysAddress getLinkLayerAddress() {
        return this._linkLayerAddress;
    }

    public NeighborOrigin getOrigin() {
        return this._origin;
    }

    public Neighbor.State getState() {
        return this._state;
    }

    public Boolean isIsRouter() {
        return this._isRouter;
    }

    public <E extends Augmentation<Neighbor>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public NeighborBuilder setIp(Ipv6AddressNoZone value) {
        this._ip = value;
        return this;
    }

    public NeighborBuilder setKey(NeighborKey value) {
        this._key = value;
        return this;
    }

    public NeighborBuilder setLinkLayerAddress(PhysAddress value) {
        this._linkLayerAddress = value;
        return this;
    }

    public NeighborBuilder setOrigin(NeighborOrigin value) {
        this._origin = value;
        return this;
    }

    public NeighborBuilder setState(Neighbor.State value) {
        this._state = value;
        return this;
    }

    public NeighborBuilder setIsRouter(Boolean value) {
        this._isRouter = value;
        return this;
    }

    public NeighborBuilder addAugmentation(Class<? extends Augmentation<Neighbor>> augmentationType, Augmentation<Neighbor> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Neighbor>>, Augmentation<Neighbor>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public NeighborBuilder removeAugmentation(Class<? extends Augmentation<Neighbor>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Neighbor build() {
        return new NeighborImpl(this);
    }

    private static final class NeighborImpl
    implements Neighbor {
        private final Ipv6AddressNoZone _ip;
        private final NeighborKey _key;
        private final PhysAddress _linkLayerAddress;
        private final NeighborOrigin _origin;
        private final Neighbor.State _state;
        private final Boolean _isRouter;
        private Map<Class<? extends Augmentation<Neighbor>>, Augmentation<Neighbor>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<Neighbor> getImplementedInterface() {
            return Neighbor.class;
        }

        private NeighborImpl(NeighborBuilder base) {
            if (base.getKey() == null) {
                this._key = new NeighborKey(base.getIp());
                this._ip = base.getIp();
            } else {
                this._key = base.getKey();
                this._ip = this._key.getIp();
            }
            this._linkLayerAddress = base.getLinkLayerAddress();
            this._origin = base.getOrigin();
            this._state = base.getState();
            this._isRouter = base.isIsRouter();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<Neighbor>>, Augmentation<Neighbor>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<Neighbor>>, Augmentation<Neighbor>>(base.augmentation);
                }
            }
        }

        @Override
        public Ipv6AddressNoZone getIp() {
            return this._ip;
        }

        @Override
        public NeighborKey getKey() {
            return this._key;
        }

        @Override
        public PhysAddress getLinkLayerAddress() {
            return this._linkLayerAddress;
        }

        @Override
        public NeighborOrigin getOrigin() {
            return this._origin;
        }

        @Override
        public Neighbor.State getState() {
            return this._state;
        }

        @Override
        public Boolean isIsRouter() {
            return this._isRouter;
        }

        public <E extends Augmentation<Neighbor>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._ip);
            result = 31 * result + Objects.hashCode(this._key);
            result = 31 * result + Objects.hashCode(this._linkLayerAddress);
            result = 31 * result + Objects.hashCode((Object)this._origin);
            result = 31 * result + Objects.hashCode((Object)this._state);
            result = 31 * result + Objects.hashCode(this._isRouter);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Neighbor.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Neighbor other = (Neighbor)obj;
            if (!Objects.equals(this._ip, other.getIp())) {
                return false;
            }
            if (!Objects.equals(this._key, other.getKey())) {
                return false;
            }
            if (!Objects.equals(this._linkLayerAddress, other.getLinkLayerAddress())) {
                return false;
            }
            if (!Objects.equals((Object)this._origin, (Object)other.getOrigin())) {
                return false;
            }
            if (!Objects.equals((Object)this._state, (Object)other.getState())) {
                return false;
            }
            if (!Objects.equals(this._isRouter, other.isIsRouter())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                NeighborImpl otherImpl = (NeighborImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Neighbor>>, Augmentation<Neighbor>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "Neighbor [";
            StringBuilder builder = new StringBuilder(name);
            if (this._ip != null) {
                builder.append("_ip=");
                builder.append(this._ip);
                builder.append(", ");
            }
            if (this._key != null) {
                builder.append("_key=");
                builder.append(this._key);
                builder.append(", ");
            }
            if (this._linkLayerAddress != null) {
                builder.append("_linkLayerAddress=");
                builder.append(this._linkLayerAddress);
                builder.append(", ");
            }
            if (this._origin != null) {
                builder.append("_origin=");
                builder.append((Object)this._origin);
                builder.append(", ");
            }
            if (this._state != null) {
                builder.append("_state=");
                builder.append((Object)this._state);
                builder.append(", ");
            }
            if (this._isRouter != null) {
                builder.append("_isRouter=");
                builder.append(this._isRouter);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

