/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.ip.rev140616.interfaces.state._interface.ipv6;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv6AddressNoZone;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.ip.rev140616.NeighborOrigin;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.ip.rev140616.interfaces.state._interface.Ipv6;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.ip.rev140616.interfaces.state._interface.ipv6.NeighborKey;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.PhysAddress;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.Identifiable;
import org.opendaylight.yangtools.yang.common.QName;

public interface Neighbor
extends ChildOf<Ipv6>,
Augmentable<Neighbor>,
Identifiable<NeighborKey> {
    public static final QName QNAME = QName.create((String)"urn:ietf:params:xml:ns:yang:ietf-ip", (String)"2014-06-16", (String)"neighbor").intern();

    public Ipv6AddressNoZone getIp();

    public PhysAddress getLinkLayerAddress();

    public NeighborOrigin getOrigin();

    public Boolean isIsRouter();

    public State getState();

    public NeighborKey getKey();

    public static enum State {
        Incomplete(0, "incomplete"),
        Reachable(1, "reachable"),
        Stale(2, "stale"),
        Delay(3, "delay"),
        Probe(4, "probe");

        private static final Map<Integer, State> VALUE_MAP;
        private final String name;
        private final int value;

        private State(int value, String name) {
            this.value = value;
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public int getIntValue() {
            return this.value;
        }

        public static State forValue(int valueArg) {
            return VALUE_MAP.get(valueArg);
        }

        static {
            ImmutableMap.Builder b = ImmutableMap.builder();
            for (State enumItem : State.values()) {
                b.put((Object)enumItem.value, (Object)enumItem);
            }
            VALUE_MAP = b.build();
        }
    }
}

