/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.ip.rev140616.interfaces.state._interface.ipv6;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv6AddressNoZone;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.ip.rev140616.IpAddressOrigin;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.ip.rev140616.interfaces.state._interface.ipv6.Address;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.ip.rev140616.interfaces.state._interface.ipv6.AddressKey;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class AddressBuilder
implements Builder<Address> {
    private Ipv6AddressNoZone _ip;
    private AddressKey _key;
    private IpAddressOrigin _origin;
    private Short _prefixLength;
    private Address.Status _status;
    Map<Class<? extends Augmentation<Address>>, Augmentation<Address>> augmentation = Collections.emptyMap();

    public AddressBuilder() {
    }

    public AddressBuilder(Address base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new AddressKey(base.getIp());
            this._ip = base.getIp();
        } else {
            this._key = base.getKey();
            this._ip = this._key.getIp();
        }
        this._origin = base.getOrigin();
        this._prefixLength = base.getPrefixLength();
        this._status = base.getStatus();
        if (base instanceof AddressImpl) {
            AddressImpl impl = (AddressImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Address>>, Augmentation<Address>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Address>>, Augmentation<Address>>(casted.augmentations());
        }
    }

    public Ipv6AddressNoZone getIp() {
        return this._ip;
    }

    public AddressKey getKey() {
        return this._key;
    }

    public IpAddressOrigin getOrigin() {
        return this._origin;
    }

    public Short getPrefixLength() {
        return this._prefixLength;
    }

    public Address.Status getStatus() {
        return this._status;
    }

    public <E extends Augmentation<Address>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public AddressBuilder setIp(Ipv6AddressNoZone value) {
        this._ip = value;
        return this;
    }

    public AddressBuilder setKey(AddressKey value) {
        this._key = value;
        return this;
    }

    public AddressBuilder setOrigin(IpAddressOrigin value) {
        this._origin = value;
        return this;
    }

    private static void checkPrefixLengthRange(short value) {
        if (value >= 0 && value <= 128) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..128]].", value));
    }

    public AddressBuilder setPrefixLength(Short value) {
        if (value != null) {
            AddressBuilder.checkPrefixLengthRange(value);
        }
        this._prefixLength = value;
        return this;
    }

    public AddressBuilder setStatus(Address.Status value) {
        this._status = value;
        return this;
    }

    public AddressBuilder addAugmentation(Class<? extends Augmentation<Address>> augmentationType, Augmentation<Address> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Address>>, Augmentation<Address>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public AddressBuilder removeAugmentation(Class<? extends Augmentation<Address>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Address build() {
        return new AddressImpl(this);
    }

    private static final class AddressImpl
    implements Address {
        private final Ipv6AddressNoZone _ip;
        private final AddressKey _key;
        private final IpAddressOrigin _origin;
        private final Short _prefixLength;
        private final Address.Status _status;
        private Map<Class<? extends Augmentation<Address>>, Augmentation<Address>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<Address> getImplementedInterface() {
            return Address.class;
        }

        private AddressImpl(AddressBuilder base) {
            if (base.getKey() == null) {
                this._key = new AddressKey(base.getIp());
                this._ip = base.getIp();
            } else {
                this._key = base.getKey();
                this._ip = this._key.getIp();
            }
            this._origin = base.getOrigin();
            this._prefixLength = base.getPrefixLength();
            this._status = base.getStatus();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<Address>>, Augmentation<Address>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<Address>>, Augmentation<Address>>(base.augmentation);
                }
            }
        }

        @Override
        public Ipv6AddressNoZone getIp() {
            return this._ip;
        }

        @Override
        public AddressKey getKey() {
            return this._key;
        }

        @Override
        public IpAddressOrigin getOrigin() {
            return this._origin;
        }

        @Override
        public Short getPrefixLength() {
            return this._prefixLength;
        }

        @Override
        public Address.Status getStatus() {
            return this._status;
        }

        public <E extends Augmentation<Address>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._ip);
            result = 31 * result + Objects.hashCode(this._key);
            result = 31 * result + Objects.hashCode((Object)this._origin);
            result = 31 * result + Objects.hashCode(this._prefixLength);
            result = 31 * result + Objects.hashCode((Object)this._status);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Address.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Address other = (Address)obj;
            if (!Objects.equals(this._ip, other.getIp())) {
                return false;
            }
            if (!Objects.equals(this._key, other.getKey())) {
                return false;
            }
            if (!Objects.equals((Object)this._origin, (Object)other.getOrigin())) {
                return false;
            }
            if (!Objects.equals(this._prefixLength, other.getPrefixLength())) {
                return false;
            }
            if (!Objects.equals((Object)this._status, (Object)other.getStatus())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                AddressImpl otherImpl = (AddressImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Address>>, Augmentation<Address>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "Address [";
            StringBuilder builder = new StringBuilder(name);
            if (this._ip != null) {
                builder.append("_ip=");
                builder.append(this._ip);
                builder.append(", ");
            }
            if (this._key != null) {
                builder.append("_key=");
                builder.append(this._key);
                builder.append(", ");
            }
            if (this._origin != null) {
                builder.append("_origin=");
                builder.append((Object)this._origin);
                builder.append(", ");
            }
            if (this._prefixLength != null) {
                builder.append("_prefixLength=");
                builder.append(this._prefixLength);
                builder.append(", ");
            }
            if (this._status != null) {
                builder.append("_status=");
                builder.append((Object)this._status);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

