/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.ip.rev140616.interfaces.state._interface.ipv6;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv6AddressNoZone;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.ip.rev140616.IpAddressOrigin;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.ip.rev140616.interfaces.state._interface.Ipv6;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.ip.rev140616.interfaces.state._interface.ipv6.AddressKey;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.Identifiable;
import org.opendaylight.yangtools.yang.common.QName;

public interface Address
extends ChildOf<Ipv6>,
Augmentable<Address>,
Identifiable<AddressKey> {
    public static final QName QNAME = QName.create((String)"urn:ietf:params:xml:ns:yang:ietf-ip", (String)"2014-06-16", (String)"address").intern();

    public Ipv6AddressNoZone getIp();

    public Short getPrefixLength();

    public IpAddressOrigin getOrigin();

    public Status getStatus();

    public AddressKey getKey();

    public static enum Status {
        Preferred(0, "preferred"),
        Deprecated(1, "deprecated"),
        Invalid(2, "invalid"),
        Inaccessible(3, "inaccessible"),
        Unknown(4, "unknown"),
        Tentative(5, "tentative"),
        Duplicate(6, "duplicate"),
        Optimistic(7, "optimistic");

        private static final Map<Integer, Status> VALUE_MAP;
        private final String name;
        private final int value;

        private Status(int value, String name) {
            this.value = value;
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public int getIntValue() {
            return this.value;
        }

        public static Status forValue(int valueArg) {
            return VALUE_MAP.get(valueArg);
        }

        static {
            ImmutableMap.Builder b = ImmutableMap.builder();
            for (Status enumItem : Status.values()) {
                b.put((Object)enumItem.value, (Object)enumItem);
            }
            VALUE_MAP = b.build();
        }
    }
}

