/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.ip.rev140616.interfaces.state._interface.ipv4.address.subnet;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.ip.rev140616.interfaces.state._interface.ipv4.address.subnet.Netmask;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.DottedQuad;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class NetmaskBuilder
implements Builder<Netmask> {
    private DottedQuad _netmask;
    Map<Class<? extends Augmentation<Netmask>>, Augmentation<Netmask>> augmentation = Collections.emptyMap();

    public NetmaskBuilder() {
    }

    public NetmaskBuilder(Netmask base) {
        AugmentationHolder casted;
        this._netmask = base.getNetmask();
        if (base instanceof NetmaskImpl) {
            NetmaskImpl impl = (NetmaskImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Netmask>>, Augmentation<Netmask>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Netmask>>, Augmentation<Netmask>>(casted.augmentations());
        }
    }

    public DottedQuad getNetmask() {
        return this._netmask;
    }

    public <E extends Augmentation<Netmask>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public NetmaskBuilder setNetmask(DottedQuad value) {
        this._netmask = value;
        return this;
    }

    public NetmaskBuilder addAugmentation(Class<? extends Augmentation<Netmask>> augmentationType, Augmentation<Netmask> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Netmask>>, Augmentation<Netmask>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public NetmaskBuilder removeAugmentation(Class<? extends Augmentation<Netmask>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Netmask build() {
        return new NetmaskImpl(this);
    }

    private static final class NetmaskImpl
    implements Netmask {
        private final DottedQuad _netmask;
        private Map<Class<? extends Augmentation<Netmask>>, Augmentation<Netmask>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<Netmask> getImplementedInterface() {
            return Netmask.class;
        }

        private NetmaskImpl(NetmaskBuilder base) {
            this._netmask = base.getNetmask();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<Netmask>>, Augmentation<Netmask>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<Netmask>>, Augmentation<Netmask>>(base.augmentation);
                }
            }
        }

        @Override
        public DottedQuad getNetmask() {
            return this._netmask;
        }

        public <E extends Augmentation<Netmask>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._netmask);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Netmask.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Netmask other = (Netmask)obj;
            if (!Objects.equals(this._netmask, other.getNetmask())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                NetmaskImpl otherImpl = (NetmaskImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Netmask>>, Augmentation<Netmask>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "Netmask [";
            StringBuilder builder = new StringBuilder(name);
            if (this._netmask != null) {
                builder.append("_netmask=");
                builder.append(this._netmask);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

