/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.ip.rev140616.interfaces._interface.ipv4;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4AddressNoZone;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.ip.rev140616.interfaces._interface.ipv4.Address;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.ip.rev140616.interfaces._interface.ipv4.AddressKey;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.ip.rev140616.interfaces._interface.ipv4.address.Subnet;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class AddressBuilder
implements Builder<Address> {
    private Ipv4AddressNoZone _ip;
    private AddressKey _key;
    private Subnet _subnet;
    Map<Class<? extends Augmentation<Address>>, Augmentation<Address>> augmentation = Collections.emptyMap();

    public AddressBuilder() {
    }

    public AddressBuilder(Address base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new AddressKey(base.getIp());
            this._ip = base.getIp();
        } else {
            this._key = base.getKey();
            this._ip = this._key.getIp();
        }
        this._subnet = base.getSubnet();
        if (base instanceof AddressImpl) {
            AddressImpl impl = (AddressImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Address>>, Augmentation<Address>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Address>>, Augmentation<Address>>(casted.augmentations());
        }
    }

    public Ipv4AddressNoZone getIp() {
        return this._ip;
    }

    public AddressKey getKey() {
        return this._key;
    }

    public Subnet getSubnet() {
        return this._subnet;
    }

    public <E extends Augmentation<Address>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public AddressBuilder setIp(Ipv4AddressNoZone value) {
        this._ip = value;
        return this;
    }

    public AddressBuilder setKey(AddressKey value) {
        this._key = value;
        return this;
    }

    public AddressBuilder setSubnet(Subnet value) {
        this._subnet = value;
        return this;
    }

    public AddressBuilder addAugmentation(Class<? extends Augmentation<Address>> augmentationType, Augmentation<Address> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Address>>, Augmentation<Address>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public AddressBuilder removeAugmentation(Class<? extends Augmentation<Address>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Address build() {
        return new AddressImpl(this);
    }

    private static final class AddressImpl
    implements Address {
        private final Ipv4AddressNoZone _ip;
        private final AddressKey _key;
        private final Subnet _subnet;
        private Map<Class<? extends Augmentation<Address>>, Augmentation<Address>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<Address> getImplementedInterface() {
            return Address.class;
        }

        private AddressImpl(AddressBuilder base) {
            if (base.getKey() == null) {
                this._key = new AddressKey(base.getIp());
                this._ip = base.getIp();
            } else {
                this._key = base.getKey();
                this._ip = this._key.getIp();
            }
            this._subnet = base.getSubnet();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<Address>>, Augmentation<Address>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<Address>>, Augmentation<Address>>(base.augmentation);
                }
            }
        }

        @Override
        public Ipv4AddressNoZone getIp() {
            return this._ip;
        }

        @Override
        public AddressKey getKey() {
            return this._key;
        }

        @Override
        public Subnet getSubnet() {
            return this._subnet;
        }

        public <E extends Augmentation<Address>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._ip);
            result = 31 * result + Objects.hashCode(this._key);
            result = 31 * result + Objects.hashCode(this._subnet);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Address.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Address other = (Address)obj;
            if (!Objects.equals(this._ip, other.getIp())) {
                return false;
            }
            if (!Objects.equals(this._key, other.getKey())) {
                return false;
            }
            if (!Objects.equals(this._subnet, other.getSubnet())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                AddressImpl otherImpl = (AddressImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Address>>, Augmentation<Address>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "Address [";
            StringBuilder builder = new StringBuilder(name);
            if (this._ip != null) {
                builder.append("_ip=");
                builder.append(this._ip);
                builder.append(", ");
            }
            if (this._key != null) {
                builder.append("_key=");
                builder.append(this._key);
                builder.append(", ");
            }
            if (this._subnet != null) {
                builder.append("_subnet=");
                builder.append(this._subnet);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

