/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.ip.rev140616.interfaces._interface;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.ip.rev140616.interfaces._interface.Ipv6;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.ip.rev140616.interfaces._interface.ipv6.Address;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.ip.rev140616.interfaces._interface.ipv6.Autoconf;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.ip.rev140616.interfaces._interface.ipv6.Neighbor;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class Ipv6Builder
implements Builder<Ipv6> {
    private List<Address> _address;
    private Autoconf _autoconf;
    private Long _dupAddrDetectTransmits;
    private Long _mtu;
    private List<Neighbor> _neighbor;
    private Boolean _enabled;
    private Boolean _forwarding;
    Map<Class<? extends Augmentation<Ipv6>>, Augmentation<Ipv6>> augmentation = Collections.emptyMap();

    public Ipv6Builder() {
    }

    public Ipv6Builder(Ipv6 base) {
        AugmentationHolder casted;
        this._address = base.getAddress();
        this._autoconf = base.getAutoconf();
        this._dupAddrDetectTransmits = base.getDupAddrDetectTransmits();
        this._mtu = base.getMtu();
        this._neighbor = base.getNeighbor();
        this._enabled = base.isEnabled();
        this._forwarding = base.isForwarding();
        if (base instanceof Ipv6Impl) {
            Ipv6Impl impl = (Ipv6Impl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Ipv6>>, Augmentation<Ipv6>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Ipv6>>, Augmentation<Ipv6>>(casted.augmentations());
        }
    }

    public List<Address> getAddress() {
        return this._address;
    }

    public Autoconf getAutoconf() {
        return this._autoconf;
    }

    public Long getDupAddrDetectTransmits() {
        return this._dupAddrDetectTransmits;
    }

    public Long getMtu() {
        return this._mtu;
    }

    public List<Neighbor> getNeighbor() {
        return this._neighbor;
    }

    public Boolean isEnabled() {
        return this._enabled;
    }

    public Boolean isForwarding() {
        return this._forwarding;
    }

    public <E extends Augmentation<Ipv6>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public Ipv6Builder setAddress(List<Address> value) {
        this._address = value;
        return this;
    }

    public Ipv6Builder setAutoconf(Autoconf value) {
        this._autoconf = value;
        return this;
    }

    private static void checkDupAddrDetectTransmitsRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..4294967295]].", value));
    }

    public Ipv6Builder setDupAddrDetectTransmits(Long value) {
        if (value != null) {
            Ipv6Builder.checkDupAddrDetectTransmitsRange(value);
        }
        this._dupAddrDetectTransmits = value;
        return this;
    }

    private static void checkMtuRange(long value) {
        if (value >= 1280L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[1280..4294967295]].", value));
    }

    public Ipv6Builder setMtu(Long value) {
        if (value != null) {
            Ipv6Builder.checkMtuRange(value);
        }
        this._mtu = value;
        return this;
    }

    public Ipv6Builder setNeighbor(List<Neighbor> value) {
        this._neighbor = value;
        return this;
    }

    public Ipv6Builder setEnabled(Boolean value) {
        this._enabled = value;
        return this;
    }

    public Ipv6Builder setForwarding(Boolean value) {
        this._forwarding = value;
        return this;
    }

    public Ipv6Builder addAugmentation(Class<? extends Augmentation<Ipv6>> augmentationType, Augmentation<Ipv6> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Ipv6>>, Augmentation<Ipv6>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public Ipv6Builder removeAugmentation(Class<? extends Augmentation<Ipv6>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Ipv6 build() {
        return new Ipv6Impl(this);
    }

    private static final class Ipv6Impl
    implements Ipv6 {
        private final List<Address> _address;
        private final Autoconf _autoconf;
        private final Long _dupAddrDetectTransmits;
        private final Long _mtu;
        private final List<Neighbor> _neighbor;
        private final Boolean _enabled;
        private final Boolean _forwarding;
        private Map<Class<? extends Augmentation<Ipv6>>, Augmentation<Ipv6>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<Ipv6> getImplementedInterface() {
            return Ipv6.class;
        }

        private Ipv6Impl(Ipv6Builder base) {
            this._address = base.getAddress();
            this._autoconf = base.getAutoconf();
            this._dupAddrDetectTransmits = base.getDupAddrDetectTransmits();
            this._mtu = base.getMtu();
            this._neighbor = base.getNeighbor();
            this._enabled = base.isEnabled();
            this._forwarding = base.isForwarding();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<Ipv6>>, Augmentation<Ipv6>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<Ipv6>>, Augmentation<Ipv6>>(base.augmentation);
                }
            }
        }

        @Override
        public List<Address> getAddress() {
            return this._address;
        }

        @Override
        public Autoconf getAutoconf() {
            return this._autoconf;
        }

        @Override
        public Long getDupAddrDetectTransmits() {
            return this._dupAddrDetectTransmits;
        }

        @Override
        public Long getMtu() {
            return this._mtu;
        }

        @Override
        public List<Neighbor> getNeighbor() {
            return this._neighbor;
        }

        @Override
        public Boolean isEnabled() {
            return this._enabled;
        }

        @Override
        public Boolean isForwarding() {
            return this._forwarding;
        }

        public <E extends Augmentation<Ipv6>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._address);
            result = 31 * result + Objects.hashCode(this._autoconf);
            result = 31 * result + Objects.hashCode(this._dupAddrDetectTransmits);
            result = 31 * result + Objects.hashCode(this._mtu);
            result = 31 * result + Objects.hashCode(this._neighbor);
            result = 31 * result + Objects.hashCode(this._enabled);
            result = 31 * result + Objects.hashCode(this._forwarding);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Ipv6.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Ipv6 other = (Ipv6)obj;
            if (!Objects.equals(this._address, other.getAddress())) {
                return false;
            }
            if (!Objects.equals(this._autoconf, other.getAutoconf())) {
                return false;
            }
            if (!Objects.equals(this._dupAddrDetectTransmits, other.getDupAddrDetectTransmits())) {
                return false;
            }
            if (!Objects.equals(this._mtu, other.getMtu())) {
                return false;
            }
            if (!Objects.equals(this._neighbor, other.getNeighbor())) {
                return false;
            }
            if (!Objects.equals(this._enabled, other.isEnabled())) {
                return false;
            }
            if (!Objects.equals(this._forwarding, other.isForwarding())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                Ipv6Impl otherImpl = (Ipv6Impl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Ipv6>>, Augmentation<Ipv6>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "Ipv6 [";
            StringBuilder builder = new StringBuilder(name);
            if (this._address != null) {
                builder.append("_address=");
                builder.append(this._address);
                builder.append(", ");
            }
            if (this._autoconf != null) {
                builder.append("_autoconf=");
                builder.append(this._autoconf);
                builder.append(", ");
            }
            if (this._dupAddrDetectTransmits != null) {
                builder.append("_dupAddrDetectTransmits=");
                builder.append(this._dupAddrDetectTransmits);
                builder.append(", ");
            }
            if (this._mtu != null) {
                builder.append("_mtu=");
                builder.append(this._mtu);
                builder.append(", ");
            }
            if (this._neighbor != null) {
                builder.append("_neighbor=");
                builder.append(this._neighbor);
                builder.append(", ");
            }
            if (this._enabled != null) {
                builder.append("_enabled=");
                builder.append(this._enabled);
                builder.append(", ");
            }
            if (this._forwarding != null) {
                builder.append("_forwarding=");
                builder.append(this._forwarding);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

