/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.ip.rev140616;

import com.google.common.collect.ImmutableMap;
import java.util.Map;

public enum IpAddressOrigin {
    Other(0, "other"),
    Static(1, "static"),
    Dhcp(2, "dhcp"),
    LinkLayer(3, "link-layer"),
    Random(4, "random");

    private static final Map<Integer, IpAddressOrigin> VALUE_MAP;
    private final String name;
    private final int value;

    private IpAddressOrigin(int value, String name) {
        this.value = value;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public int getIntValue() {
        return this.value;
    }

    public static IpAddressOrigin forValue(int valueArg) {
        return VALUE_MAP.get(valueArg);
    }

    static {
        ImmutableMap.Builder b = ImmutableMap.builder();
        for (IpAddressOrigin enumItem : IpAddressOrigin.values()) {
            b.put((Object)enumItem.value, (Object)enumItem);
        }
        VALUE_MAP = b.build();
    }
}

