/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.interfaces.rev140508.interfaces.state;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.interfaces.rev140508.InterfaceType;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.interfaces.rev140508.interfaces.state.Interface;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.interfaces.rev140508.interfaces.state.InterfaceKey;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.interfaces.rev140508.interfaces.state._interface.Statistics;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.DateAndTime;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.Gauge64;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.PhysAddress;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class InterfaceBuilder
implements Builder<Interface> {
    private Interface.AdminStatus _adminStatus;
    private List<String> _higherLayerIf;
    private Integer _ifIndex;
    private InterfaceKey _key;
    private DateAndTime _lastChange;
    private List<String> _lowerLayerIf;
    private String _name;
    private Interface.OperStatus _operStatus;
    private PhysAddress _physAddress;
    private Gauge64 _speed;
    private Statistics _statistics;
    private Class<? extends InterfaceType> _type;
    Map<Class<? extends Augmentation<Interface>>, Augmentation<Interface>> augmentation = Collections.emptyMap();

    public InterfaceBuilder() {
    }

    public InterfaceBuilder(Interface base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new InterfaceKey(base.getName());
            this._name = base.getName();
        } else {
            this._key = base.getKey();
            this._name = this._key.getName();
        }
        this._adminStatus = base.getAdminStatus();
        this._higherLayerIf = base.getHigherLayerIf();
        this._ifIndex = base.getIfIndex();
        this._lastChange = base.getLastChange();
        this._lowerLayerIf = base.getLowerLayerIf();
        this._operStatus = base.getOperStatus();
        this._physAddress = base.getPhysAddress();
        this._speed = base.getSpeed();
        this._statistics = base.getStatistics();
        this._type = base.getType();
        if (base instanceof InterfaceImpl) {
            InterfaceImpl impl = (InterfaceImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Interface>>, Augmentation<Interface>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Interface>>, Augmentation<Interface>>(casted.augmentations());
        }
    }

    public Interface.AdminStatus getAdminStatus() {
        return this._adminStatus;
    }

    public List<String> getHigherLayerIf() {
        return this._higherLayerIf;
    }

    public Integer getIfIndex() {
        return this._ifIndex;
    }

    public InterfaceKey getKey() {
        return this._key;
    }

    public DateAndTime getLastChange() {
        return this._lastChange;
    }

    public List<String> getLowerLayerIf() {
        return this._lowerLayerIf;
    }

    public String getName() {
        return this._name;
    }

    public Interface.OperStatus getOperStatus() {
        return this._operStatus;
    }

    public PhysAddress getPhysAddress() {
        return this._physAddress;
    }

    public Gauge64 getSpeed() {
        return this._speed;
    }

    public Statistics getStatistics() {
        return this._statistics;
    }

    public Class<? extends InterfaceType> getType() {
        return this._type;
    }

    public <E extends Augmentation<Interface>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public InterfaceBuilder setAdminStatus(Interface.AdminStatus value) {
        this._adminStatus = value;
        return this;
    }

    public InterfaceBuilder setHigherLayerIf(List<String> value) {
        this._higherLayerIf = value;
        return this;
    }

    private static void checkIfIndexRange(int value) {
        if (value >= 1) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[1..2147483647]].", value));
    }

    public InterfaceBuilder setIfIndex(Integer value) {
        if (value != null) {
            InterfaceBuilder.checkIfIndexRange(value);
        }
        this._ifIndex = value;
        return this;
    }

    public InterfaceBuilder setKey(InterfaceKey value) {
        this._key = value;
        return this;
    }

    public InterfaceBuilder setLastChange(DateAndTime value) {
        this._lastChange = value;
        return this;
    }

    public InterfaceBuilder setLowerLayerIf(List<String> value) {
        this._lowerLayerIf = value;
        return this;
    }

    public InterfaceBuilder setName(String value) {
        this._name = value;
        return this;
    }

    public InterfaceBuilder setOperStatus(Interface.OperStatus value) {
        this._operStatus = value;
        return this;
    }

    public InterfaceBuilder setPhysAddress(PhysAddress value) {
        this._physAddress = value;
        return this;
    }

    public InterfaceBuilder setSpeed(Gauge64 value) {
        this._speed = value;
        return this;
    }

    public InterfaceBuilder setStatistics(Statistics value) {
        this._statistics = value;
        return this;
    }

    public InterfaceBuilder setType(Class<? extends InterfaceType> value) {
        this._type = value;
        return this;
    }

    public InterfaceBuilder addAugmentation(Class<? extends Augmentation<Interface>> augmentationType, Augmentation<Interface> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Interface>>, Augmentation<Interface>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public InterfaceBuilder removeAugmentation(Class<? extends Augmentation<Interface>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Interface build() {
        return new InterfaceImpl(this);
    }

    private static final class InterfaceImpl
    implements Interface {
        private final Interface.AdminStatus _adminStatus;
        private final List<String> _higherLayerIf;
        private final Integer _ifIndex;
        private final InterfaceKey _key;
        private final DateAndTime _lastChange;
        private final List<String> _lowerLayerIf;
        private final String _name;
        private final Interface.OperStatus _operStatus;
        private final PhysAddress _physAddress;
        private final Gauge64 _speed;
        private final Statistics _statistics;
        private final Class<? extends InterfaceType> _type;
        private Map<Class<? extends Augmentation<Interface>>, Augmentation<Interface>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<Interface> getImplementedInterface() {
            return Interface.class;
        }

        private InterfaceImpl(InterfaceBuilder base) {
            if (base.getKey() == null) {
                this._key = new InterfaceKey(base.getName());
                this._name = base.getName();
            } else {
                this._key = base.getKey();
                this._name = this._key.getName();
            }
            this._adminStatus = base.getAdminStatus();
            this._higherLayerIf = base.getHigherLayerIf();
            this._ifIndex = base.getIfIndex();
            this._lastChange = base.getLastChange();
            this._lowerLayerIf = base.getLowerLayerIf();
            this._operStatus = base.getOperStatus();
            this._physAddress = base.getPhysAddress();
            this._speed = base.getSpeed();
            this._statistics = base.getStatistics();
            this._type = base.getType();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<Interface>>, Augmentation<Interface>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<Interface>>, Augmentation<Interface>>(base.augmentation);
                }
            }
        }

        @Override
        public Interface.AdminStatus getAdminStatus() {
            return this._adminStatus;
        }

        @Override
        public List<String> getHigherLayerIf() {
            return this._higherLayerIf;
        }

        @Override
        public Integer getIfIndex() {
            return this._ifIndex;
        }

        @Override
        public InterfaceKey getKey() {
            return this._key;
        }

        @Override
        public DateAndTime getLastChange() {
            return this._lastChange;
        }

        @Override
        public List<String> getLowerLayerIf() {
            return this._lowerLayerIf;
        }

        @Override
        public String getName() {
            return this._name;
        }

        @Override
        public Interface.OperStatus getOperStatus() {
            return this._operStatus;
        }

        @Override
        public PhysAddress getPhysAddress() {
            return this._physAddress;
        }

        @Override
        public Gauge64 getSpeed() {
            return this._speed;
        }

        @Override
        public Statistics getStatistics() {
            return this._statistics;
        }

        @Override
        public Class<? extends InterfaceType> getType() {
            return this._type;
        }

        public <E extends Augmentation<Interface>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode((Object)this._adminStatus);
            result = 31 * result + Objects.hashCode(this._higherLayerIf);
            result = 31 * result + Objects.hashCode(this._ifIndex);
            result = 31 * result + Objects.hashCode(this._key);
            result = 31 * result + Objects.hashCode(this._lastChange);
            result = 31 * result + Objects.hashCode(this._lowerLayerIf);
            result = 31 * result + Objects.hashCode(this._name);
            result = 31 * result + Objects.hashCode((Object)this._operStatus);
            result = 31 * result + Objects.hashCode(this._physAddress);
            result = 31 * result + Objects.hashCode(this._speed);
            result = 31 * result + Objects.hashCode(this._statistics);
            result = 31 * result + Objects.hashCode(this._type);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Interface.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Interface other = (Interface)obj;
            if (!Objects.equals((Object)this._adminStatus, (Object)other.getAdminStatus())) {
                return false;
            }
            if (!Objects.equals(this._higherLayerIf, other.getHigherLayerIf())) {
                return false;
            }
            if (!Objects.equals(this._ifIndex, other.getIfIndex())) {
                return false;
            }
            if (!Objects.equals(this._key, other.getKey())) {
                return false;
            }
            if (!Objects.equals(this._lastChange, other.getLastChange())) {
                return false;
            }
            if (!Objects.equals(this._lowerLayerIf, other.getLowerLayerIf())) {
                return false;
            }
            if (!Objects.equals(this._name, other.getName())) {
                return false;
            }
            if (!Objects.equals((Object)this._operStatus, (Object)other.getOperStatus())) {
                return false;
            }
            if (!Objects.equals(this._physAddress, other.getPhysAddress())) {
                return false;
            }
            if (!Objects.equals(this._speed, other.getSpeed())) {
                return false;
            }
            if (!Objects.equals(this._statistics, other.getStatistics())) {
                return false;
            }
            if (!Objects.equals(this._type, other.getType())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                InterfaceImpl otherImpl = (InterfaceImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Interface>>, Augmentation<Interface>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "Interface [";
            StringBuilder builder = new StringBuilder(name);
            if (this._adminStatus != null) {
                builder.append("_adminStatus=");
                builder.append((Object)this._adminStatus);
                builder.append(", ");
            }
            if (this._higherLayerIf != null) {
                builder.append("_higherLayerIf=");
                builder.append(this._higherLayerIf);
                builder.append(", ");
            }
            if (this._ifIndex != null) {
                builder.append("_ifIndex=");
                builder.append(this._ifIndex);
                builder.append(", ");
            }
            if (this._key != null) {
                builder.append("_key=");
                builder.append(this._key);
                builder.append(", ");
            }
            if (this._lastChange != null) {
                builder.append("_lastChange=");
                builder.append(this._lastChange);
                builder.append(", ");
            }
            if (this._lowerLayerIf != null) {
                builder.append("_lowerLayerIf=");
                builder.append(this._lowerLayerIf);
                builder.append(", ");
            }
            if (this._name != null) {
                builder.append("_name=");
                builder.append(this._name);
                builder.append(", ");
            }
            if (this._operStatus != null) {
                builder.append("_operStatus=");
                builder.append((Object)this._operStatus);
                builder.append(", ");
            }
            if (this._physAddress != null) {
                builder.append("_physAddress=");
                builder.append(this._physAddress);
                builder.append(", ");
            }
            if (this._speed != null) {
                builder.append("_speed=");
                builder.append(this._speed);
                builder.append(", ");
            }
            if (this._statistics != null) {
                builder.append("_statistics=");
                builder.append(this._statistics);
                builder.append(", ");
            }
            if (this._type != null) {
                builder.append("_type=");
                builder.append(this._type);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

