/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.interfaces.rev140508.interfaces.state;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.interfaces.rev140508.InterfaceType;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.interfaces.rev140508.InterfacesState;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.interfaces.rev140508.interfaces.state.InterfaceKey;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.interfaces.rev140508.interfaces.state._interface.Statistics;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.DateAndTime;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.Gauge64;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.PhysAddress;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.Identifiable;
import org.opendaylight.yangtools.yang.common.QName;

public interface Interface
extends ChildOf<InterfacesState>,
Augmentable<Interface>,
Identifiable<InterfaceKey> {
    public static final QName QNAME = QName.create((String)"urn:ietf:params:xml:ns:yang:ietf-interfaces", (String)"2014-05-08", (String)"interface").intern();

    public String getName();

    public Class<? extends InterfaceType> getType();

    public AdminStatus getAdminStatus();

    public OperStatus getOperStatus();

    public DateAndTime getLastChange();

    public Integer getIfIndex();

    public PhysAddress getPhysAddress();

    public List<String> getHigherLayerIf();

    public List<String> getLowerLayerIf();

    public Gauge64 getSpeed();

    public Statistics getStatistics();

    public InterfaceKey getKey();

    public static enum OperStatus {
        Up(1, "up"),
        Down(2, "down"),
        Testing(3, "testing"),
        Unknown(4, "unknown"),
        Dormant(5, "dormant"),
        NotPresent(6, "not-present"),
        LowerLayerDown(7, "lower-layer-down");

        private static final Map<Integer, OperStatus> VALUE_MAP;
        private final String name;
        private final int value;

        private OperStatus(int value, String name) {
            this.value = value;
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public int getIntValue() {
            return this.value;
        }

        public static OperStatus forValue(int valueArg) {
            return VALUE_MAP.get(valueArg);
        }

        static {
            ImmutableMap.Builder b = ImmutableMap.builder();
            for (OperStatus enumItem : OperStatus.values()) {
                b.put((Object)enumItem.value, (Object)enumItem);
            }
            VALUE_MAP = b.build();
        }
    }

    public static enum AdminStatus {
        Up(1, "up"),
        Down(2, "down"),
        Testing(3, "testing");

        private static final Map<Integer, AdminStatus> VALUE_MAP;
        private final String name;
        private final int value;

        private AdminStatus(int value, String name) {
            this.value = value;
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public int getIntValue() {
            return this.value;
        }

        public static AdminStatus forValue(int valueArg) {
            return VALUE_MAP.get(valueArg);
        }

        static {
            ImmutableMap.Builder b = ImmutableMap.builder();
            for (AdminStatus enumItem : AdminStatus.values()) {
                b.put((Object)enumItem.value, (Object)enumItem);
            }
            VALUE_MAP = b.build();
        }
    }
}

