/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.interfaces.rev140508;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.interfaces.rev140508.Interfaces;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.interfaces.rev140508.interfaces.Interface;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class InterfacesBuilder
implements Builder<Interfaces> {
    private List<Interface> _interface;
    Map<Class<? extends Augmentation<Interfaces>>, Augmentation<Interfaces>> augmentation = Collections.emptyMap();

    public InterfacesBuilder() {
    }

    public InterfacesBuilder(Interfaces base) {
        AugmentationHolder casted;
        this._interface = base.getInterface();
        if (base instanceof InterfacesImpl) {
            InterfacesImpl impl = (InterfacesImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Interfaces>>, Augmentation<Interfaces>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Interfaces>>, Augmentation<Interfaces>>(casted.augmentations());
        }
    }

    public List<Interface> getInterface() {
        return this._interface;
    }

    public <E extends Augmentation<Interfaces>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public InterfacesBuilder setInterface(List<Interface> value) {
        this._interface = value;
        return this;
    }

    public InterfacesBuilder addAugmentation(Class<? extends Augmentation<Interfaces>> augmentationType, Augmentation<Interfaces> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Interfaces>>, Augmentation<Interfaces>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public InterfacesBuilder removeAugmentation(Class<? extends Augmentation<Interfaces>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Interfaces build() {
        return new InterfacesImpl(this);
    }

    private static final class InterfacesImpl
    implements Interfaces {
        private final List<Interface> _interface;
        private Map<Class<? extends Augmentation<Interfaces>>, Augmentation<Interfaces>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<Interfaces> getImplementedInterface() {
            return Interfaces.class;
        }

        private InterfacesImpl(InterfacesBuilder base) {
            this._interface = base.getInterface();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<Interfaces>>, Augmentation<Interfaces>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<Interfaces>>, Augmentation<Interfaces>>(base.augmentation);
                }
            }
        }

        @Override
        public List<Interface> getInterface() {
            return this._interface;
        }

        public <E extends Augmentation<Interfaces>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._interface);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Interfaces.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Interfaces other = (Interfaces)obj;
            if (!Objects.equals(this._interface, other.getInterface())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                InterfacesImpl otherImpl = (InterfacesImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Interfaces>>, Augmentation<Interfaces>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "Interfaces [";
            StringBuilder builder = new StringBuilder(name);
            if (this._interface != null) {
                builder.append("_interface=");
                builder.append(this._interface);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

